/*
 * Decompiled with CFR 0.152.
 */
package r.builtins;

import r.Utils;
import r.builtins.Builtin;
import r.builtins.CallFactory;
import r.data.RAny;
import r.data.RArray;
import r.data.RDouble;
import r.data.RInt;
import r.data.RLogical;
import r.data.RString;
import r.data.RSymbol;
import r.data.internal.ScalarDoubleImpl;
import r.data.internal.ScalarIntImpl;
import r.data.internal.ScalarLogicalImpl;
import r.data.internal.View;
import r.nodes.ast.ASTNode;
import r.nodes.exec.AbstractCall;
import r.nodes.exec.RNode;
import r.runtime.Frame;
import r.runtime.SpecializationException;

final class IsNA
extends CallFactory {
    static final CallFactory _ = new IsNA("is.na", new String[]{"x"}, new String[]{"x"});

    private IsNA(String name, String[] params, String[] required) {
        super(name, params, required);
    }

    @Override
    public RNode create(ASTNode call, RSymbol[] names, RNode[] exprs) {
        this.check(call, names, exprs);
        return Specialized.createUninitialized(call, names, exprs);
    }

    public static RLogical generic(RAny arg) {
        if (arg instanceof RArray) {
            final RArray a = (RArray)arg;
            final int asize = a.size();
            if (asize == 1) {
                return a.isNAorNaN(0) ? RLogical.BOXED_TRUE : RLogical.BOXED_FALSE;
            }
            if (asize > 1) {
                return new View.RLogicalProxy<RArray>(a){

                    @Override
                    public int size() {
                        return asize;
                    }

                    @Override
                    public int getLogical(int i) {
                        return a.isNAorNaN(i) ? 1 : 0;
                    }
                };
            }
            return RLogical.EMPTY;
        }
        throw Utils.nyi("unsupported argument");
    }

    public static Builtin createGeneric(ASTNode ast, RSymbol[] names, RNode[] exprs) {
        return new Builtin(ast, names, exprs){

            @Override
            public RAny doBuiltIn(Frame frame, RAny[] params) {
                return IsNA.generic(params[0]);
            }
        };
    }

    public static class Specialized
    extends AbstractCall {
        final IsNAAction isNA;

        public Specialized(ASTNode orig, RSymbol[] argNames, RNode[] argExprs, IsNAAction isNA) {
            super(orig, argNames, argExprs);
            this.isNA = isNA;
        }

        public static Specialized createUninitialized(ASTNode ast, RSymbol[] names, RNode[] exprs) {
            return Specialized.createTransition(ast, names, exprs, Transition.SCALAR);
        }

        public static Specialized createTransition(ASTNode ast, RSymbol[] names, RNode[] exprs, final Transition t) {
            IsNAAction a = new IsNAAction(){

                @Override
                public final int isNA(Frame frame, RAny param) throws SpecializationException {
                    throw new SpecializationException((Object)t);
                }
            };
            return new Specialized(ast, names, exprs, a);
        }

        private static void checkScalar(RArray a, Transition t) throws SpecializationException {
            if (a.size() != 1) {
                throw new SpecializationException((Object)t);
            }
        }

        public static Specialized createScalar(ASTNode ast, RSymbol[] names, RNode[] exprs, RAny typeTemplate) {
            if (typeTemplate instanceof ScalarDoubleImpl) {
                IsNAAction a = new IsNAAction(){

                    @Override
                    public final int isNA(Frame frame, RAny param) throws SpecializationException {
                        if (!(param instanceof ScalarDoubleImpl)) {
                            throw new SpecializationException((Object)Transition.GENERIC);
                        }
                        return ((ScalarDoubleImpl)param).isNAorNaN() ? 1 : 0;
                    }
                };
                return new Specialized(ast, names, exprs, a);
            }
            if (typeTemplate instanceof RDouble) {
                IsNAAction a = new IsNAAction(){

                    @Override
                    public final int isNA(Frame frame, RAny param) throws SpecializationException {
                        if (!(param instanceof RDouble)) {
                            throw new SpecializationException((Object)Transition.GENERIC);
                        }
                        RDouble v = (RDouble)param;
                        Specialized.checkScalar(v, Transition.GENERIC);
                        return RDouble.RDoubleUtils.isNAorNaN(v.getDouble(0)) ? 1 : 0;
                    }
                };
                return new Specialized(ast, names, exprs, a);
            }
            if (typeTemplate instanceof ScalarIntImpl) {
                IsNAAction a = new IsNAAction(){

                    @Override
                    public final int isNA(Frame frame, RAny param) throws SpecializationException {
                        if (!(param instanceof ScalarIntImpl)) {
                            throw new SpecializationException((Object)Transition.GENERIC);
                        }
                        return ((ScalarIntImpl)param).isNAorNaN() ? 1 : 0;
                    }
                };
                return new Specialized(ast, names, exprs, a);
            }
            if (typeTemplate instanceof RInt) {
                IsNAAction a = new IsNAAction(){

                    @Override
                    public final int isNA(Frame frame, RAny param) throws SpecializationException {
                        if (!(param instanceof RInt)) {
                            throw new SpecializationException((Object)Transition.GENERIC);
                        }
                        RInt v = (RInt)param;
                        Specialized.checkScalar(v, Transition.GENERIC);
                        return v.getInt(0) == Integer.MIN_VALUE ? 1 : 0;
                    }
                };
                return new Specialized(ast, names, exprs, a);
            }
            if (typeTemplate instanceof ScalarLogicalImpl) {
                IsNAAction a = new IsNAAction(){

                    @Override
                    public final int isNA(Frame frame, RAny param) throws SpecializationException {
                        if (!(param instanceof ScalarLogicalImpl)) {
                            throw new SpecializationException((Object)Transition.GENERIC);
                        }
                        return ((ScalarLogicalImpl)param).isNAorNaN() ? 1 : 0;
                    }
                };
                return new Specialized(ast, names, exprs, a);
            }
            if (typeTemplate instanceof RLogical) {
                IsNAAction a = new IsNAAction(){

                    @Override
                    public final int isNA(Frame frame, RAny param) throws SpecializationException {
                        if (!(param instanceof RLogical)) {
                            throw new SpecializationException((Object)Transition.GENERIC);
                        }
                        RLogical v = (RLogical)param;
                        Specialized.checkScalar(v, Transition.GENERIC);
                        return v.getLogical(0) == Integer.MIN_VALUE ? 1 : 0;
                    }
                };
                return new Specialized(ast, names, exprs, a);
            }
            if (typeTemplate instanceof RString) {
                IsNAAction a = new IsNAAction(){

                    @Override
                    public final int isNA(Frame frame, RAny param) throws SpecializationException {
                        if (!(param instanceof RString)) {
                            throw new SpecializationException((Object)Transition.GENERIC);
                        }
                        RString v = (RString)param;
                        Specialized.checkScalar(v, Transition.GENERIC);
                        return v.getString(0) == RString.NA ? 1 : 0;
                    }
                };
                return new Specialized(ast, names, exprs, a);
            }
            return Specialized.createTransition(ast, names, exprs, Transition.GENERIC);
        }

        @Override
        public final int executeScalarNonNALogical(Frame frame) throws SpecializationException {
            RAny arg = (RAny)this.argExprs[0].execute(frame);
            return this.executeScalarNonNALogical(frame, arg);
        }

        @Override
        public final int executeScalarLogical(Frame frame) throws SpecializationException {
            RAny arg = (RAny)this.argExprs[0].execute(frame);
            return this.executeScalarNonNALogical(frame, arg);
        }

        @Override
        public final Object execute(Frame frame) {
            try {
                return RLogical.RLogicalFactory.getScalar(this.executeScalarNonNALogical(frame));
            }
            catch (SpecializationException e) {
                return e.getResult();
            }
        }

        public final int executeScalarNonNALogical(Frame frame, RAny arg) throws SpecializationException {
            try {
                return this.isNA.isNA(frame, arg);
            }
            catch (SpecializationException e) {
                Transition t = (Transition)((Object)e.getResult());
                Specialized s = null;
                switch (t) {
                    case SCALAR: {
                        s = Specialized.createScalar(this.ast, this.argNames, this.argExprs, arg);
                        this.replace(s, "install SimpleScalars in IsNA.Specialized");
                        return s.executeScalarNonNALogical(frame, arg);
                    }
                }
                this.replace(IsNA.createGeneric(this.ast, this.argNames, this.argExprs), "install Generic in IsNA.Specialized");
                RLogical res = IsNA.generic(arg);
                throw new SpecializationException(res);
            }
        }
    }

    public static abstract class IsNAAction {
        public abstract int isNA(Frame var1, RAny var2) throws SpecializationException;
    }

    static enum Transition {
        SCALAR,
        GENERIC;

    }
}

