/*
 * Decompiled with CFR 0.152.
 */
package r.builtins;

import r.Convert;
import r.Utils;
import r.builtins.Builtin;
import r.builtins.CallFactory;
import r.data.RAny;
import r.data.RArray;
import r.data.RCallable;
import r.data.RInt;
import r.data.RList;
import r.data.RString;
import r.data.RSymbol;
import r.data.internal.IntImpl;
import r.errors.RError;
import r.nodes.ast.ASTNode;
import r.nodes.ast.SimpleAccessVariable;
import r.nodes.exec.BaseR;
import r.nodes.exec.FunctionCall;
import r.nodes.exec.MatchCallable;
import r.nodes.exec.RNode;
import r.runtime.Frame;
import r.runtime.SpecializationException;

final class LApply
extends CallFactory {
    static final CallFactory _ = new LApply("lapply", new String[]{"X", "FUN", "..."}, new String[]{"X", "FUN"});

    private LApply(String name, String[] params, String[] required) {
        super(name, params, required);
    }

    @Override
    public RNode create(ASTNode call, RSymbol[] names, RNode[] exprs) {
        CallFactory.ArgumentInfo ia = this.check(call, names, exprs);
        int cnArgs = 1 + names.length - 2;
        RSymbol[] cnNames = new RSymbol[cnArgs];
        RNode[] cnExprs = new RNode[cnArgs];
        cnNames[0] = null;
        ValueProvider firstArgProvider = new ValueProvider(call);
        cnExprs[0] = firstArgProvider;
        ValueProvider[] constantArgProviders = new ValueProvider[cnArgs];
        int j = 0;
        for (int i = 0; i < names.length; ++i) {
            if (ia.position("X") == i || ia.position("FUN") == i) continue;
            cnNames[1 + j] = names[i];
            ValueProvider vp = new ValueProvider(call);
            cnExprs[1 + j] = vp;
            constantArgProviders[j] = vp;
            ++j;
        }
        CallableProvider callableProvider = new CallableProvider(call, exprs[ia.position("FUN")]);
        FunctionCall callNode = FunctionCall.getFunctionCall(call, callableProvider, cnNames, cnExprs);
        return new Lapply(call, names, exprs, callNode, firstArgProvider, constantArgProviders, callableProvider, ia.position("X"), ia.position("FUN"));
    }

    public static abstract class ArgIterator {
        ValueProvider argProvider;
        int size;

        public abstract void reset(ValueProvider var1, RAny var2) throws SpecializationException;

        public abstract void setNext();

        public int size() {
            return this.size;
        }

        public abstract RArray.Names names();

        public abstract RString stringNames();

        public abstract boolean hasNames();

        public static ArgIterator create(RAny sourceTemplate) {
            if (sourceTemplate instanceof IntImpl.RIntSequence) {
                return new IntSequence();
            }
            if (sourceTemplate instanceof RList) {
                return new List();
            }
            if (sourceTemplate instanceof RString) {
                return new StringArray();
            }
            if (sourceTemplate instanceof RArray) {
                return new NonlistNonstringArray();
            }
            return new Generic();
        }

        public static final class Generic
        extends ArgIterator {
            RArray array;
            int i;

            @Override
            public void reset(ValueProvider provider, RAny source) {
                if (!(source instanceof RArray)) {
                    Utils.nyi("unsupported type");
                }
                this.argProvider = provider;
                this.array = (RArray)source;
                this.i = 0;
                this.size = this.array.size();
            }

            @Override
            public void setNext() {
                this.argProvider.setValue(this.array.boxedGet(this.i));
                ++this.i;
            }

            @Override
            public RArray.Names names() {
                RArray.Names anames = this.array.names();
                if (anames != null) {
                    return anames;
                }
                if (this.array instanceof RString) {
                    return RArray.Names.create(RSymbol.getSymbols((RString)this.array));
                }
                return null;
            }

            @Override
            public RString stringNames() {
                RArray.Names anames = this.array.names();
                if (anames != null) {
                    return RString.RStringFactory.getFor(Convert.symbols2strings(this.array.names().sequence()));
                }
                return (RString)this.array;
            }

            @Override
            public boolean hasNames() {
                return this.array.names() != null || this.array instanceof RString && this.size > 0;
            }
        }

        public static final class List
        extends ArgIterator {
            RList list;
            int i;

            @Override
            public void reset(ValueProvider provider, RAny source) throws SpecializationException {
                if (!(source instanceof RList)) {
                    throw new SpecializationException((Object)null);
                }
                this.argProvider = provider;
                this.list = (RList)source;
                this.i = 0;
                this.size = this.list.size();
            }

            @Override
            public void setNext() {
                this.argProvider.setValue(this.list.getRAny(this.i));
                ++this.i;
            }

            @Override
            public RArray.Names names() {
                return this.list.names();
            }

            @Override
            public RString stringNames() {
                return RString.RStringFactory.getFor(Convert.symbols2strings(this.names().sequence()));
            }

            @Override
            public boolean hasNames() {
                return this.list.names() != null;
            }
        }

        public static final class NonlistNonstringArray
        extends ArgIterator {
            RArray array;
            int i;

            @Override
            public void reset(ValueProvider provider, RAny source) throws SpecializationException {
                if (source instanceof RList || source instanceof RString || !(source instanceof RArray)) {
                    throw new SpecializationException((Object)null);
                }
                this.argProvider = provider;
                this.array = (RArray)source;
                this.i = 0;
                this.size = this.array.size();
            }

            @Override
            public void setNext() {
                this.argProvider.setValue(this.array.boxedGet(this.i));
                ++this.i;
            }

            @Override
            public RArray.Names names() {
                return this.array.names();
            }

            @Override
            public RString stringNames() {
                return RString.RStringFactory.getFor(Convert.symbols2strings(this.names().sequence()));
            }

            @Override
            public boolean hasNames() {
                return this.array.names() != null;
            }
        }

        public static final class StringArray
        extends ArgIterator {
            RString string;
            int i;

            @Override
            public void reset(ValueProvider provider, RAny source) throws SpecializationException {
                if (!(source instanceof RString)) {
                    throw new SpecializationException((Object)null);
                }
                this.argProvider = provider;
                this.string = (RString)source;
                this.i = 0;
                this.size = this.string.size();
            }

            @Override
            public void setNext() {
                this.argProvider.setValue(this.string.boxedGet(this.i));
                ++this.i;
            }

            @Override
            public RArray.Names names() {
                RArray.Names snames = this.string.names();
                if (snames != null) {
                    return snames;
                }
                return RArray.Names.create(RSymbol.getSymbols(this.string));
            }

            @Override
            public RString stringNames() {
                RArray.Names snames = this.string.names();
                if (snames != null) {
                    return RString.RStringFactory.getFor(Convert.symbols2strings(snames.sequence()));
                }
                return this.string;
            }

            @Override
            public boolean hasNames() {
                return this.size > 0;
            }
        }

        public static final class IntSequence
        extends ArgIterator {
            int to;
            int step;
            int next;

            @Override
            public void reset(ValueProvider provider, RAny source) throws SpecializationException {
                if (!(source instanceof IntImpl.RIntSequence)) {
                    throw new SpecializationException((Object)null);
                }
                IntImpl.RIntSequence seq = (IntImpl.RIntSequence)source;
                this.argProvider = provider;
                this.next = seq.from();
                this.to = seq.to();
                this.step = seq.step();
                this.size = seq.size();
            }

            @Override
            public void setNext() {
                this.argProvider.setValue(RInt.RIntFactory.getScalar(this.next));
                this.next += this.step;
            }

            @Override
            public RArray.Names names() {
                return null;
            }

            @Override
            public RString stringNames() {
                return null;
            }

            @Override
            public boolean hasNames() {
                return false;
            }
        }
    }

    public static class Lapply
    extends Builtin {
        ValueProvider firstArgProvider;
        ValueProvider[] constantArgProviders;
        CallableProvider callableProvider;
        @RNode.Child
        RNode callNode;
        final int xPosition;
        final int funPosition;

        public Lapply(ASTNode call, RSymbol[] names, RNode[] exprs, RNode callNode, ValueProvider firstArgProvider, ValueProvider[] constantArgProviders, CallableProvider callableProvider, int xPosition, int funPosition) {
            super(call, names, exprs);
            this.callableProvider = callableProvider;
            this.firstArgProvider = firstArgProvider;
            this.constantArgProviders = constantArgProviders;
            this.callNode = this.adoptChild(callNode);
            this.xPosition = xPosition;
            this.funPosition = funPosition;
        }

        @Override
        protected <N extends RNode> N replaceChild(RNode oldNode, N newNode) {
            assert (oldNode != null);
            assert (Utils.check(oldNode != this.firstArgProvider));
            assert (Utils.check(oldNode != this.callableProvider));
            if (this.callNode == oldNode) {
                this.callNode = newNode;
                return this.adoptInternal(newNode);
            }
            return super.replaceChild(oldNode, newNode);
        }

        public RAny generic(Frame frame, RAny argx, Lapply lapply) {
            if (!(argx instanceof RArray)) {
                throw Utils.nyi("unsupported type");
            }
            RArray x = (RArray)argx;
            int xsize = x.size();
            boolean isList = false;
            RList l = null;
            if (x instanceof RList) {
                l = (RList)x;
                isList = true;
            }
            RAny[] content = new RAny[xsize];
            for (int i = 0; i < xsize; ++i) {
                lapply.firstArgProvider.setValue(isList ? l.getRAny(i) : x.boxedGet(i));
                content[i] = (RAny)lapply.callNode.execute(frame);
            }
            return RList.RListFactory.getFor(content, null, isList ? l.names() : x.names());
        }

        public Specialized createSpecialized(RAny argxTemplate) {
            if (argxTemplate instanceof RList) {
                ApplyFunc a = new ApplyFunc(){

                    @Override
                    public RAny apply(Frame frame, RAny argx, Lapply lapply) throws SpecializationException {
                        if (!(argx instanceof RList)) {
                            throw new SpecializationException((Object)null);
                        }
                        RList x = (RList)argx;
                        int xsize = x.size();
                        RAny[] content = new RAny[xsize];
                        for (int i = 0; i < xsize; ++i) {
                            lapply.firstArgProvider.setValue(x.getRAny(i));
                            content[i] = (RAny)lapply.callNode.execute(frame);
                        }
                        return RList.RListFactory.getFor(content, null, x.names());
                    }
                };
                return new Specialized(this.ast, this.argNames, this.argExprs, this.callNode, this.firstArgProvider, this.constantArgProviders, this.callableProvider, this.xPosition, this.funPosition, a);
            }
            if (argxTemplate instanceof RArray) {
                ApplyFunc a = new ApplyFunc(){

                    @Override
                    public RAny apply(Frame frame, RAny argx, Lapply lapply) throws SpecializationException {
                        if (argx instanceof RList || !(argx instanceof RArray)) {
                            throw new SpecializationException((Object)null);
                        }
                        RArray x = (RArray)argx;
                        int xsize = x.size();
                        RAny[] content = new RAny[xsize];
                        for (int i = 0; i < xsize; ++i) {
                            lapply.firstArgProvider.setValue(x.boxedGet(i));
                            content[i] = (RAny)lapply.callNode.execute(frame);
                        }
                        return RList.RListFactory.getFor(content, null, x.names());
                    }
                };
                return new Specialized(this.ast, this.argNames, this.argExprs, this.callNode, this.firstArgProvider, this.constantArgProviders, this.callableProvider, this.xPosition, this.funPosition, a);
            }
            return null;
        }

        public Specialized createGeneric() {
            ApplyFunc a = new ApplyFunc(){

                @Override
                public RAny apply(Frame frame, RAny argx, Lapply lapply) throws SpecializationException {
                    return Lapply.this.generic(frame, argx, lapply);
                }
            };
            return new Specialized(this.ast, this.argNames, this.argExprs, this.callNode, this.firstArgProvider, this.constantArgProviders, this.callableProvider, this.xPosition, this.funPosition, a);
        }

        public RAny doApply(Frame frame, RAny[] args) {
            try {
                throw new SpecializationException((Object)null);
            }
            catch (SpecializationException e) {
                Specialized sn = this.createSpecialized(args[this.xPosition]);
                if (sn != null) {
                    this.replace(sn, "install Specialized from Lapply");
                    return sn.doApply(frame, args);
                }
                sn = this.createGeneric();
                this.replace(sn, "install Specialized<Generic> from Lapply");
                return sn.doApply(frame, args);
            }
        }

        @Override
        public RAny doBuiltIn(Frame frame, RAny[] args) {
            return this.doApply(frame, args);
        }

        static class Specialized
        extends Lapply {
            final ApplyFunc apply;

            public Specialized(ASTNode call, RSymbol[] names, RNode[] exprs, RNode callNode, ValueProvider firstArgProvider, ValueProvider[] constantArgProviders, CallableProvider callableProvider, int xPosition, int funPosition, ApplyFunc apply) {
                super(call, names, exprs, callNode, firstArgProvider, constantArgProviders, callableProvider, xPosition, funPosition);
                this.apply = apply;
            }

            @Override
            public RAny doApply(Frame frame, RAny[] args) {
                int j = 0;
                RAny argx = null;
                for (int i = 0; i < args.length; ++i) {
                    if (i == this.xPosition) {
                        argx = args[i];
                        continue;
                    }
                    if (i == this.funPosition) {
                        this.callableProvider.matchAndSet(frame, args[i]);
                        continue;
                    }
                    this.constantArgProviders[j].setValue(args[i]);
                    ++j;
                }
                try {
                    return this.apply.apply(frame, argx, this);
                }
                catch (SpecializationException e) {
                    Specialized sn = this.createGeneric();
                    this.replace(sn, "install Specialized<Generic> from Lapply.Specialized");
                    return sn.doApply(frame, args);
                }
            }
        }

        static abstract class ApplyFunc {
            ApplyFunc() {
            }

            public abstract RAny apply(Frame var1, RAny var2, Lapply var3) throws SpecializationException;
        }
    }

    public static class CallableProvider
    extends BaseR {
        RCallable value;
        final RSymbol callsiteSymbol;

        public CallableProvider(ASTNode ast, RNode functionExpr) {
            super(ast);
            ASTNode feAST = functionExpr.getAST();
            this.callsiteSymbol = feAST instanceof SimpleAccessVariable ? ((SimpleAccessVariable)feAST).getSymbol() : null;
        }

        @Override
        public final Object execute(Frame frame) {
            return this.value;
        }

        public void matchAndSet(Frame frame, RAny arg) {
            if (arg instanceof RCallable) {
                this.value = (RCallable)arg;
                return;
            }
            if (arg instanceof RString) {
                RString svalue = (RString)arg;
                if (svalue.size() != 1) {
                    throw RError.getNotFunction(this.ast, arg);
                }
                RSymbol symbol = RSymbol.getSymbol(svalue.getString(0));
                this.value = MatchCallable.matchGeneric(this.ast, frame, symbol);
                return;
            }
            if (this.callsiteSymbol != null) {
                this.value = MatchCallable.matchGeneric(this.ast, frame, this.callsiteSymbol);
                return;
            }
            throw RError.getNotFunction(this.ast, arg);
        }
    }

    public static class ValueProvider
    extends BaseR {
        RAny value;

        public ValueProvider(ASTNode ast) {
            super(ast);
        }

        @Override
        public final Object execute(Frame frame) {
            return this.value;
        }

        public void setValue(RAny value) {
            this.value = value;
        }
    }
}

