/*
 * Decompiled with CFR 0.152.
 */
package r.builtins;

import r.Convert;
import r.Utils;
import r.builtins.Builtin;
import r.builtins.CallFactory;
import r.data.RAny;
import r.data.RArray;
import r.data.RDouble;
import r.data.RInt;
import r.data.RSymbol;
import r.errors.RError;
import r.nodes.ast.ASTNode;
import r.nodes.exec.RNode;
import r.runtime.Frame;

final class LengthAssign
extends CallFactory {
    static final CallFactory _ = new LengthAssign("length<-", new String[]{"x", "value"}, new String[]{"x", "value"});

    private LengthAssign(String name, String[] params, String[] required) {
        super(name, params, required);
    }

    @Override
    public RNode create(ASTNode call, RSymbol[] names, RNode[] exprs) {
        this.check(call, names, exprs);
        return new Builtin.Builtin2(call, names, exprs){

            @Override
            public RAny doBuiltIn(Frame frame, RAny x, RAny value) {
                if (!(x instanceof RArray)) {
                    throw RError.getInvalidUnnamedArgument(this.ast);
                }
                int nlen = LengthAssign.parseNewLength(value, this.ast);
                return LengthAssign.changeSize((RArray)x, nlen);
            }
        };
    }

    private static int parseNewLength(int value, ASTNode ast) {
        if (value >= 0) {
            return value;
        }
        throw RError.getVectorSizeNegative(ast);
    }

    private static int parseNewLength(RAny value, ASTNode ast) {
        RInt ivalue;
        RDouble dvalue;
        if (value instanceof RDouble && (dvalue = (RDouble)value).size() == 1) {
            return LengthAssign.parseNewLength(Convert.double2int(dvalue.getDouble(0)), ast);
        }
        if (value instanceof RInt && (ivalue = (RInt)value).size() == 1) {
            return LengthAssign.parseNewLength(ivalue.getInt(0), ast);
        }
        throw RError.getInvalidUnnamedValue(ast);
    }

    private static RArray changeSize(RArray x, int nsize) {
        int xsize = x.size();
        if (xsize == nsize) {
            return x;
        }
        RArray res = Utils.createArray(x, nsize);
        if (nsize > xsize) {
            int i;
            for (i = 0; i < xsize; ++i) {
                res.set(i, x.get(i));
            }
            for (i = xsize; i < nsize; ++i) {
                Utils.setNA(res, i);
            }
        } else {
            for (int i = 0; i < nsize; ++i) {
                res.set(i, x.get(i));
            }
        }
        return res;
    }
}

