/*
 * Decompiled with CFR 0.152.
 */
package r.builtins;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import r.builtins.Builtin;
import r.builtins.CallFactory;
import r.data.RAny;
import r.data.RLogical;
import r.data.RString;
import r.data.RSymbol;
import r.data.internal.ScalarStringImpl;
import r.errors.RError;
import r.nodes.ast.ASTNode;
import r.nodes.exec.RNode;
import r.runtime.Frame;

final class ListFiles
extends CallFactory {
    static final CallFactory _ = new ListFiles("list.files", new String[]{"path", "pattern", "all.files", "full.names", "recursive", "ignore.case", "include.dirs"}, new String[0]);
    private static int maxDepth = 100;

    private ListFiles(String name, String[] params, String[] required) {
        super(name, params, required);
    }

    @Override
    public RNode create(ASTNode call, RSymbol[] names, RNode[] exprs) {
        CallFactory.ArgumentInfo ai = this.check(call, names, exprs);
        final int pathPos = ai.position("path");
        final int patternPos = ai.position("pattern");
        final int allFilesPos = ai.position("all.files");
        final int fullNamesPos = ai.position("full.names");
        final int recursivePos = ai.position("recursive");
        final int ignoreCasePos = ai.position("ignore.case");
        final int includeDirsPos = ai.position("include.dirs");
        return new Builtin(call, names, exprs){

            @Override
            public RAny doBuiltIn(Frame frame, RAny[] args) {
                ScalarStringImpl path = pathPos == -1 ? RString.BOXED_DOT : ListFiles.parsePath(args[pathPos], this.ast);
                String pattern = patternPos == -1 ? null : ListFiles.parsePattern(args[patternPos], this.ast);
                boolean allFiles = allFilesPos == -1 ? false : ListFiles.parseLogical(args[allFilesPos], this.ast, "all.files");
                boolean fullNames = fullNamesPos == -1 ? false : ListFiles.parseLogical(args[fullNamesPos], this.ast, "full.names");
                boolean recursive = recursivePos == -1 ? false : ListFiles.parseLogical(args[recursivePos], this.ast, "recursive");
                boolean ignoreCase = ignoreCasePos == -1 ? false : ListFiles.parseLogical(args[ignoreCasePos], this.ast, "ignore.case");
                boolean includeDirs = includeDirsPos == -1 ? false : ListFiles.parseLogical(args[includeDirsPos], this.ast, "include.dirs");
                RString res = ListFiles.perform(path, pattern, allFiles, fullNames, recursive, ignoreCase, includeDirs, this.ast);
                return res;
            }
        };
    }

    static String convertPattern(String patternString) {
        if (patternString == null) {
            return null;
        }
        if (patternString.contains(".*") || patternString.contains("[") || patternString.contains("(")) {
            return patternString;
        }
        return ".*" + patternString.replaceAll("\\*", ".*").replaceAll("\\?", ".?") + ".*";
    }

    static RString perform(RString path, String patternString, boolean allFiles, boolean fullNames, boolean recursive, boolean ignoreCase, boolean includeDirs, ASTNode ast) {
        Pattern pattern = null;
        if (patternString != null) {
            try {
                String convertedPattern = ListFiles.convertPattern(patternString);
                pattern = Pattern.compile(convertedPattern, ignoreCase ? 2 : 0);
            }
            catch (PatternSyntaxException e) {
                throw RError.getInvalidRegexp(ast, "pattern");
            }
        }
        int pathSize = path.size();
        ArrayList<String> res = new ArrayList<String>();
        for (int i = 0; i < pathSize; ++i) {
            String dir = path.getString(i);
            ListFiles.list(dir, res, pattern, 0, allFiles, fullNames ? dir + File.separatorChar : "", recursive, ignoreCase, includeDirs);
        }
        Collections.sort(res);
        return RString.RStringFactory.getFor(res.toArray(new String[res.size()]));
    }

    static void list(String path, ArrayList<String> res, Pattern pattern, int depth, boolean allFiles, String prefix, boolean recursive, boolean ignoreCase, boolean includeDirs) {
        File dir = new File(path);
        File[] files = dir.listFiles();
        if (files == null) {
            return;
        }
        for (File f : files) {
            Matcher m;
            String name = f.getName();
            if ((f.isHidden() || name.startsWith(".")) && !allFiles) continue;
            if (recursive && f.isDirectory() && depth < maxDepth) {
                ListFiles.list(path + File.separatorChar + f.getName(), res, pattern, depth + 1, allFiles, prefix + name + '/', recursive, ignoreCase, includeDirs);
            }
            if (pattern != null && !(m = pattern.matcher(name)).matches() || recursive && !includeDirs && f.isDirectory()) continue;
            res.add(prefix + name);
        }
    }

    static RString parsePath(RAny arg, ASTNode ast) {
        if (!(arg instanceof RString)) {
            throw RError.getInvalidArgument(ast, "path");
        }
        return (RString)arg;
    }

    static String parsePattern(RAny arg, ASTNode ast) {
        if (arg instanceof RString) {
            RString rs = (RString)arg;
            if (rs.size() == 0) {
                return null;
            }
            String s = rs.getString(0);
            if (s != RString.NA) {
                if (s.length() > 0) {
                    return s;
                }
                return null;
            }
        }
        throw RError.getInvalidArgument(ast, "pattern");
    }

    static boolean parseLogical(RAny arg, ASTNode ast, String argName) {
        RLogical l = arg.asLogical();
        if (l.size() == 0) {
            throw RError.getInvalidArgument(ast, argName);
        }
        int value = l.getLogical(0);
        if (value == Integer.MIN_VALUE) {
            throw RError.getInvalidArgument(ast, argName);
        }
        return value == 1;
    }
}

