/*
 * Decompiled with CFR 0.152.
 */
package r.builtins;

import java.util.Arrays;
import r.Convert;
import r.Utils;
import r.builtins.Builtin;
import r.builtins.CallFactory;
import r.builtins.EnvBase;
import r.data.RAny;
import r.data.REnvironment;
import r.data.RLogical;
import r.data.RString;
import r.data.RSymbol;
import r.nodes.ast.ASTNode;
import r.nodes.exec.RNode;
import r.runtime.Frame;

final class Ls
extends CallFactory {
    static final CallFactory _ = new Ls("ls", new String[]{"name", "pos", "envir", "all.names", "pattern"}, new String[0]);

    private Ls(String name, String[] params, String[] required) {
        super(name, params, required);
    }

    @Override
    public RNode create(ASTNode call, RSymbol[] names, RNode[] exprs) {
        CallFactory.ArgumentInfo ia = this.check(call, names, exprs);
        if (ia.provided("pattern")) {
            throw Utils.nyi();
        }
        final int posName = ia.position("name");
        final int posPos = ia.position("pos");
        final int posEnvir = ia.position("envir");
        final int posAllNames = ia.position("all.names");
        return new Builtin(call, names, exprs){

            @Override
            public RAny doBuiltIn(Frame frame, RAny[] args) {
                REnvironment envir;
                RAny nameArg;
                RAny rAny = nameArg = posName != -1 ? args[posName] : null;
                if (nameArg != null) {
                    envir = EnvBase.asEnvironment(frame, this.ast, nameArg, true);
                } else {
                    RAny envirArg = posEnvir != -1 ? args[posEnvir] : null;
                    RAny posArg = posPos != -1 ? args[posPos] : null;
                    envir = EnvBase.extractEnvironment(envirArg, posArg, frame, this.ast);
                }
                boolean includeHidden = posAllNames == -1 ? false : Ls.parseAllNames(args[posAllNames]);
                Object[] varNames = Convert.symbols2strings(envir.ls(includeHidden));
                Arrays.sort(varNames);
                return RString.RStringFactory.getFor((String[])varNames);
            }
        };
    }

    public static boolean parseAllNames(RAny arg) {
        RLogical l = arg.asLogical();
        if (l.size() > 0) {
            int v = l.getLogical(0);
            return v == 1;
        }
        return false;
    }
}

