/*
 * Decompiled with CFR 0.152.
 */
package r.builtins;

import r.builtins.Builtin;
import r.builtins.CallFactory;
import r.data.RAny;
import r.data.RDouble;
import r.data.RInt;
import r.data.RLogical;
import r.data.RSymbol;
import r.data.internal.View;
import r.errors.RError;
import r.nodes.ast.ASTNode;
import r.nodes.exec.RNode;
import r.runtime.Frame;

abstract class MathBase
extends CallFactory {
    MathBase(String name) {
        super(name, new String[]{"x"}, null);
    }

    abstract double op(ASTNode var1, double var2);

    RDouble calc(final ASTNode ast, final RDouble value) {
        final int size = value.size();
        if (size == 1) {
            return RDouble.RDoubleFactory.getScalar(this.op(ast, value.getDouble(0)), value.dimensions(), value.names(), value.attributesRef());
        }
        if (size > 0) {
            return new View.RDoubleProxy<RDouble>(value){

                @Override
                public int size() {
                    return size;
                }

                @Override
                public double getDouble(int i) {
                    return MathBase.this.op(ast, value.getDouble(i));
                }
            };
        }
        return RDouble.EMPTY;
    }

    @Override
    public RNode create(ASTNode call, RSymbol[] names, RNode[] exprs) {
        this.check(call, names, exprs);
        return new Builtin.Builtin1(call, names, exprs){

            @Override
            public RAny doBuiltIn(Frame frame, RAny value) {
                if (value instanceof RDouble || value instanceof RInt || value instanceof RLogical) {
                    return MathBase.this.calc(this.ast, value.asDouble());
                }
                throw RError.getNonNumericMath(this.ast);
            }
        };
    }
}

