/*
 * Decompiled with CFR 0.152.
 */
package r.builtins;

import r.Convert;
import r.RContext;
import r.Utils;
import r.builtins.Builtin;
import r.builtins.CallFactory;
import r.data.RAny;
import r.data.RArray;
import r.data.RDouble;
import r.data.RInt;
import r.data.RLogical;
import r.data.RSymbol;
import r.data.internal.ScalarDoubleImpl;
import r.errors.RError;
import r.nodes.ast.ASTNode;
import r.nodes.exec.RNode;
import r.runtime.Frame;

final class Matrix
extends CallFactory {
    static final CallFactory _ = new Matrix("matrix", new String[]{"data", "nrow", "ncol", "byrow", "dimnames"}, new String[0]);

    private Matrix(String name, String[] params, String[] required) {
        super(name, params, required);
    }

    public static boolean parseByRow(ASTNode ast, RAny arg) {
        int il;
        RLogical l = arg.asLogical();
        if (l.size() == 0 || (il = l.getLogical(0)) == Integer.MIN_VALUE) {
            throw RError.getInvalidByRow(ast);
        }
        return il == 1;
    }

    public static RArray parseData(ASTNode ast, RAny arg) {
        if (arg instanceof RArray) {
            return (RArray)arg;
        }
        throw RError.getDataVector(ast);
    }

    public static int parseExtent(ASTNode ast, RAny arg) {
        if (arg instanceof RInt) {
            RInt v = (RInt)arg;
            if (v.size() == 0) {
                return Integer.MIN_VALUE;
            }
            return v.getInt(0);
        }
        if (arg instanceof RDouble) {
            RDouble v = (RDouble)arg;
            if (v.size() == 0) {
                return Integer.MIN_VALUE;
            }
            double d = v.getDouble(0);
            return Convert.double2int(d);
        }
        if (arg instanceof RLogical) {
            RLogical v = (RLogical)arg;
            if (v.size() == 0) {
                return Integer.MIN_VALUE;
            }
            return Convert.logical2int(v.getLogical(0));
        }
        throw RError.getNonNumericMatrixExtent(ast);
    }

    @Override
    public RNode create(ASTNode call, RSymbol[] names, RNode[] exprs) {
        CallFactory.ArgumentInfo ia = this.check(call, names, exprs);
        if (ia.provided("dimnames")) {
            throw Utils.nyi();
        }
        final int posData = ia.position("data");
        final int posNrow = ia.position("nrow");
        final int posNcol = ia.position("ncol");
        final int posByrow = ia.position("byrow");
        return new Builtin(call, names, exprs){

            @Override
            public RAny doBuiltIn(Frame frame, RAny[] args) {
                int size;
                RArray data = RLogical.BOXED_NA;
                if (posData != -1 && (data = Matrix.parseData(this.ast, args[posData])).size() == 0) {
                    data = Utils.getBoxedNA(data);
                }
                int dsize = data.size();
                int nRow = -1;
                if (posNrow != -1) {
                    nRow = Matrix.parseExtent(this.ast, args[posNrow]);
                    if (nRow == Integer.MIN_VALUE) {
                        throw RError.getInvalidNRow(this.ast);
                    }
                    if (nRow < 0) {
                        throw RError.getNegativeNRow(this.ast);
                    }
                }
                int nCol = -1;
                if (posNcol != -1) {
                    nCol = Matrix.parseExtent(this.ast, args[posNcol]);
                    if (nCol == Integer.MIN_VALUE) {
                        throw RError.getInvalidNCol(this.ast);
                    }
                    if (nCol < 0) {
                        throw RError.getNegativeNCol(this.ast);
                    }
                }
                if (nRow == -1) {
                    if (nCol == -1) {
                        nCol = 1;
                        nRow = dsize;
                    } else if (dsize >= nCol) {
                        nRow = dsize / nCol;
                        if (nRow * nCol != dsize) {
                            RContext.warning(this.ast, String.format("data length [%d] is not a sub-multiple or multiple of the number of rows [%d]", dsize, nRow));
                        }
                    } else {
                        nRow = 1;
                        if (nCol % dsize != 0) {
                            RContext.warning(this.ast, String.format("data length [%d] is not a sub-multiple or multiple of the number of rows [%d]", dsize, nRow));
                        }
                    }
                    size = nRow * nCol;
                } else if (nCol == -1) {
                    if (dsize >= nRow) {
                        nCol = dsize / nRow;
                        if (nCol * nRow != dsize) {
                            RContext.warning(this.ast, String.format("data length [%d] is not a sub-multiple or multiple of the number of rows [%d]", dsize, nRow));
                        }
                    } else {
                        nCol = 1;
                        if (nRow % dsize != 0) {
                            RContext.warning(this.ast, String.format("data length [%d] is not a sub-multiple or multiple of the number of rows [%d]", dsize, nRow));
                        }
                    }
                    size = nRow * nCol;
                } else {
                    size = nRow * nCol;
                    if (size % dsize != 0 && dsize % size != 0) {
                        RContext.warning(this.ast, String.format("data length [%d] is not a sub-multiple or multiple of the number of rows [%d]", dsize, nRow));
                    }
                }
                boolean byRow = posByrow != -1 ? Matrix.parseByRow(this.ast, args[posByrow]) : false;
                RArray res = Utils.createArray(data, size, new int[]{nRow, nCol}, null, null);
                if (data instanceof ScalarDoubleImpl && ((ScalarDoubleImpl)data).getDouble() == 0.0) {
                    return res;
                }
                int di = 0;
                if (!byRow) {
                    for (int i = 0; i < size; ++i) {
                        res.set(i, data.get(di++));
                        if (di != dsize) continue;
                        di = 0;
                    }
                } else {
                    for (int j = 0; j < nRow; ++j) {
                        for (int i = 0; i < nCol; ++i) {
                            res.set(i * nRow + j, data.get(di++));
                            if (di != dsize) continue;
                            di = 0;
                        }
                    }
                }
                return res;
            }
        };
    }
}

