/*
 * Decompiled with CFR 0.152.
 */
package r.builtins;

import r.Utils;
import r.builtins.Builtin;
import r.builtins.CallFactory;
import r.data.RAny;
import r.data.RDots;
import r.data.RLogical;
import r.data.RPromise;
import r.data.RString;
import r.data.RSymbol;
import r.errors.RError;
import r.nodes.ast.ASTNode;
import r.nodes.ast.SimpleAccessVariable;
import r.nodes.exec.BaseR;
import r.nodes.exec.RNode;
import r.runtime.Frame;

final class Missing
extends CallFactory {
    static final CallFactory _ = new Missing("missing", new String[]{"x"}, null);

    private Missing(String name, String[] params, String[] required) {
        super(name, params, required);
    }

    public static RSymbol parseX(Object arg, ASTNode ast) {
        RString sarg;
        if (arg instanceof RString && (sarg = (RString)arg).size() == 1) {
            return RSymbol.getSymbol(sarg.getString(0));
        }
        throw RError.getInvalidUse(ast, "missing");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RAny missing(Frame frame, RSymbol symbol, ASTNode ast) {
        Object value;
        int slot;
        if (frame == null) {
            Object value2 = symbol.getValueNoForce();
            if (value2 == null) {
                throw RError.getMissingArguments(ast);
            }
            if (!(value2 instanceof RPromise)) return RLogical.BOXED_FALSE;
            RPromise p = (RPromise)value2;
            return Missing.hasCycle(p) ? RLogical.BOXED_TRUE : RLogical.BOXED_FALSE;
        }
        int ddval = symbol.dotDotValue() - 1;
        if (ddval >= 0) {
            slot = frame.findVariable(RSymbol.THREE_DOTS_SYMBOL);
            if (slot == -1) {
                throw RError.getMissingArguments(ast);
            }
            RDots dots = (RDots)frame.get(slot);
            Object[] dvalues = dots.values();
            if (ddval >= dvalues.length) return RLogical.BOXED_TRUE;
            value = dvalues[ddval];
        } else {
            slot = frame.findVariable(symbol);
            if (slot == -1) {
                throw RError.getMissingArguments(ast);
            }
            value = frame.get(slot);
        }
        if (value == null) {
            throw RError.getMissingArguments(ast);
        }
        if (!(value instanceof RPromise)) return RLogical.BOXED_FALSE;
        RPromise p = (RPromise)value;
        if (!p.isDefault()) return Missing.isMissing(p) ? RLogical.BOXED_TRUE : RLogical.BOXED_FALSE;
        return RLogical.BOXED_TRUE;
    }

    @Override
    public RNode create(ASTNode call, RSymbol[] names, RNode[] exprs) {
        this.check(call, names, exprs);
        final RSymbol symbol = Missing.getAccessedSymbol(exprs[0].getAST());
        if (symbol != null) {
            return new BaseR(call){

                @Override
                public Object execute(Frame frame) {
                    return Missing.missing(frame, symbol, this.ast);
                }
            };
        }
        return new Builtin.Builtin1(call, names, exprs){

            @Override
            public RAny doBuiltIn(Frame frame, RAny arg) {
                assert (Utils.check(true));
                RSymbol xSymbol = Missing.parseX(arg, this.ast);
                return Missing.missing(frame, xSymbol, this.ast);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasCycle(RPromise p) {
        try {
            if (!p.markMissingDirty()) {
                boolean bl = true;
                return bl;
            }
            RSymbol symbol = Missing.getAccessedSymbol(p.expression().getAST());
            RPromise next = Missing.getPromiseNoForce(p.frame(), symbol);
            if (next != null) {
                boolean bl = Missing.hasCycle(next);
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            p.markMissingClean();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isMissing(RPromise p) {
        if (p.isMissing()) {
            return true;
        }
        try {
            if (!p.markMissingDirty()) {
                boolean bl = true;
                return bl;
            }
            RSymbol symbol = Missing.getAccessedSymbol(p.expression().getAST());
            if (symbol == null) {
                boolean bl = false;
                return bl;
            }
            RPromise next = Missing.getPromiseNoForce(p.frame(), symbol);
            if (next != null) {
                boolean bl = Missing.isMissing(next);
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            p.markMissingClean();
        }
    }

    private static RPromise getPromiseNoForce(Frame frame, RSymbol symbol) {
        Object value;
        if (frame != null) {
            int slot = frame.findVariable(symbol);
            if (slot == -1) {
                return null;
            }
            value = frame.get(slot);
        } else {
            value = symbol.getValueNoForce();
        }
        if (value != null && value instanceof RPromise) {
            return (RPromise)value;
        }
        return null;
    }

    private static RSymbol getAccessedSymbol(ASTNode ast) {
        if (ast instanceof SimpleAccessVariable) {
            RSymbol symbol = ((SimpleAccessVariable)ast).getSymbol();
            return symbol;
        }
        return null;
    }
}

