/*
 * Decompiled with CFR 0.152.
 */
package r.builtins;

import r.Convert;
import r.Utils;
import r.builtins.Builtin;
import r.builtins.CallFactory;
import r.data.RAny;
import r.data.RArray;
import r.data.RNull;
import r.data.RString;
import r.data.RSymbol;
import r.errors.RError;
import r.nodes.ast.ASTNode;
import r.nodes.exec.RNode;
import r.runtime.Frame;

final class NamesAssign
extends CallFactory {
    static final CallFactory _ = new NamesAssign("names<-", new String[]{"x", "value"}, new String[]{"x", "value"});

    private NamesAssign(String name, String[] params, String[] required) {
        super(name, params, required);
    }

    @Override
    public RNode create(ASTNode call, RSymbol[] names, RNode[] exprs) {
        this.check(call, names, exprs);
        return new Builtin.Builtin2(call, names, exprs){

            @Override
            public RAny doBuiltIn(Frame frame, RAny x, RAny value) {
                return NamesAssign.replaceNames(x, value, this.ast);
            }
        };
    }

    public static RAny replaceNames(RAny x, RAny value, ASTNode ast) {
        RArray.Names newNames;
        if (!(x instanceof RArray)) {
            throw RError.getNamesNonVector(ast);
        }
        RArray xarr = (RArray)x;
        if (value instanceof RNull) {
            newNames = null;
        } else {
            int i;
            RString str = Convert.coerceToStringError(value, ast);
            int xsize = xarr.size();
            int strsize = str.size();
            if (strsize > xsize) {
                throw RError.getAttributeVectorSameLength(ast, "names", strsize, xsize);
            }
            RSymbol[] symbols = new RSymbol[xsize];
            for (i = 0; i < strsize; ++i) {
                String s = str.getString(i);
                symbols[i] = RSymbol.getSymbol(s);
            }
            while (i < xsize) {
                symbols[i] = RSymbol.NA_SYMBOL;
                ++i;
            }
            newNames = RArray.Names.create(symbols);
        }
        if (!xarr.isShared()) {
            return xarr.setNames(newNames);
        }
        return Utils.copyArray(xarr).setNames(newNames);
    }
}

