/*
 * Decompiled with CFR 0.152.
 */
package r.builtins;

import r.Convert;
import r.builtins.Builtin;
import r.builtins.CallFactory;
import r.data.RAny;
import r.data.REnvironment;
import r.data.RInt;
import r.data.RSymbol;
import r.data.internal.EnvironmentImpl;
import r.errors.RError;
import r.nodes.ast.ASTNode;
import r.nodes.exec.RNode;
import r.runtime.Frame;

final class Newenv
extends CallFactory {
    static final CallFactory _ = new Newenv("new.env", new String[]{"hash", "parent", "size"}, new String[0]);
    private static final int DEFAULT_SIZE = 29;
    private static final boolean DEFAULT_HASH = true;

    private Newenv(String name, String[] params, String[] required) {
        super(name, params, required);
    }

    @Override
    public RNode create(ASTNode call, RSymbol[] names, RNode[] exprs) {
        CallFactory.ArgumentInfo ia = this.check(call, names, exprs);
        final int posHash = ia.position("hash");
        final int posParent = ia.position("parent");
        final int posSize = ia.position("size");
        return new Builtin(call, names, exprs){

            @Override
            public RAny doBuiltIn(Frame frame, RAny[] args) {
                boolean hash = posHash != -1 ? Newenv.parseHash(args[posHash], this.ast) : true;
                REnvironment rootEnvironment = null;
                Frame parentFrame = null;
                if (posParent != -1) {
                    REnvironment env = Newenv.parseParent(args[posParent], this.ast);
                    parentFrame = env.frame();
                    if (parentFrame == null) {
                        rootEnvironment = env;
                    }
                } else if (frame == null) {
                    rootEnvironment = REnvironment.GLOBAL;
                } else {
                    parentFrame = frame;
                }
                int size = 29;
                if (hash && posSize != -1) {
                    size = Newenv.parseSize(args[posSize], this.ast);
                }
                return EnvironmentImpl.Custom.create(parentFrame, rootEnvironment, hash, size);
            }
        };
    }

    static boolean parseHash(RAny arg, ASTNode ast) {
        RInt i = Convert.coerceToIntWarning(arg, ast);
        if (i.size() > 0 && i.getInt(0) != 0) {
            return true;
        }
        return true;
    }

    static int parseSize(RAny arg, ASTNode ast) {
        int v;
        RInt i = Convert.coerceToIntWarning(arg, ast);
        if (i.size() > 0 && (v = i.getInt(0)) != Integer.MIN_VALUE) {
            return v;
        }
        return 29;
    }

    static REnvironment parseParent(RAny arg, ASTNode ast) {
        if (arg instanceof REnvironment) {
            return (REnvironment)arg;
        }
        throw RError.getMustBeEnviron(ast, "parent");
    }
}

