/*
 * Decompiled with CFR 0.152.
 */
package r.builtins;

import java.util.Arrays;
import java.util.Comparator;
import r.Convert;
import r.RContext;
import r.Utils;
import r.builtins.Builtin;
import r.builtins.CallFactory;
import r.data.RAny;
import r.data.RArray;
import r.data.RDouble;
import r.data.RInt;
import r.data.RLogical;
import r.data.RNull;
import r.data.RRaw;
import r.data.RString;
import r.data.RSymbol;
import r.errors.RError;
import r.nodes.ast.ASTNode;
import r.nodes.exec.RNode;
import r.runtime.Frame;

final class Order
extends CallFactory {
    static final CallFactory _ = new Order("order", new String[]{"...", "na.last", "decreasing"}, new String[0]);
    static final Convert.ConversionStatus warn = new Convert.ConversionStatus();

    private Order(String name, String[] params, String[] required) {
        super(name, params, required);
    }

    @Override
    public RNode create(ASTNode call, RSymbol[] names, RNode[] exprs) {
        CallFactory.ArgumentInfo ia = this.check(call, names, exprs);
        final int naLastPosition = ia.position("na.last");
        final int decreasingPosition = ia.position("decreasing");
        return new Builtin(call, names, exprs){

            @Override
            public RAny doBuiltIn(Frame frame, RAny[] params) {
                boolean decreasing;
                int naLast;
                int nparams;
                int nkeys = nparams = params.length;
                if (naLastPosition == -1) {
                    naLast = 1;
                } else {
                    naLast = Order.parseNALast(params[naLastPosition], this.ast);
                    --nkeys;
                }
                if (decreasingPosition == -1) {
                    decreasing = false;
                } else {
                    decreasing = Order.parseDecreasing(params[decreasingPosition], this.ast);
                    --nkeys;
                }
                if (nkeys > 0) {
                    RArray[] keys = new RArray[nkeys];
                    int asize = -1;
                    int j = 0;
                    for (int i = 0; i < nparams; ++i) {
                        if (i == naLastPosition || i == decreasingPosition) continue;
                        RAny p = params[i];
                        if (p instanceof RArray) {
                            RArray arr = (RArray)p;
                            int size = arr.size();
                            if (size != asize) {
                                if (asize == -1) {
                                    asize = size;
                                } else {
                                    throw RError.getArgumentLengthsDiffer(this.ast);
                                }
                            }
                            keys[j++] = arr.materialize();
                            continue;
                        }
                        throw RError.getArgumentNotVector(this.ast, i);
                    }
                    return Order.sort(keys, decreasing, naLast, this.ast);
                }
                return RNull.getNull();
            }
        };
    }

    public static int parseNALast(RAny arg, ASTNode ast) {
        int res;
        Order.warn.naIntroduced = false;
        RLogical a = arg.asLogical();
        int size = a.size();
        if (size == 1) {
            res = a.getLogical(0);
            if (res != Integer.MIN_VALUE) {
                return res;
            }
        } else {
            if (size == 0) {
                throw RError.getLengthZero(ast);
            }
            RContext.warning(ast, "the condition has length > 1 and only the first element will be used");
            res = a.getLogical(0);
        }
        if (Order.warn.naIntroduced) {
            throw RError.getInvalidArgument(ast, "na.last");
        }
        return res;
    }

    public static boolean parseDecreasing(RAny arg, ASTNode ast) {
        RLogical a = arg.asLogical();
        int size = a.size();
        if (size >= 1) {
            int l = a.getLogical(0);
            if (l == 1) {
                return true;
            }
            if (l == 0) {
                return false;
            }
        }
        throw RError.getDecreasingTrueFalse(ast);
    }

    public static ElementsComparator createComparator(RArray arg, ASTNode ast) {
        if (arg instanceof RDouble) {
            return new DoubleComparator((RDouble)arg);
        }
        if (arg instanceof RInt) {
            return new IntComparator((RInt)arg);
        }
        if (arg instanceof RLogical) {
            return new LogicalComparator((RLogical)arg);
        }
        if (arg instanceof RString) {
            return new StringComparator((RString)arg);
        }
        if (arg instanceof RRaw) {
            throw RError.getRawSort(ast);
        }
        Utils.nyi("unsupported type");
        return null;
    }

    public static int resultWhenFirstNA(int naLast) {
        if (naLast != 0) {
            return 1;
        }
        return -1;
    }

    public static int resultWhenSecondNA(int naLast) {
        if (naLast != 0) {
            return -1;
        }
        return 1;
    }

    public static RInt sort(RArray[] keys, final boolean decreasing, int naLast, ASTNode ast) {
        final int nkeys = keys.length;
        int size = keys[0].size();
        final boolean removeNA = naLast == Integer.MIN_VALUE;
        int naElements = 0;
        boolean[] tmp = null;
        if (removeNA) {
            tmp = new boolean[size];
        }
        final boolean[] hasNA = tmp;
        final ElementsComparator[] comp = new ElementsComparator[nkeys];
        for (int i = 0; i < nkeys; ++i) {
            ElementsComparator c;
            comp[i] = c = Order.createComparator(keys[i], ast);
            if (!removeNA) continue;
            for (int j = 0; j < size; ++j) {
                if (hasNA[j] || !c.isNA(j)) continue;
                hasNA[j] = true;
                ++naElements;
            }
        }
        Integer[] order = new Integer[size];
        for (int i = 0; i < size; ++i) {
            order[i] = i;
        }
        final ElementsComparator firstComparator = comp[0];
        final int resFirstNA = Order.resultWhenFirstNA(naLast);
        final int resSecondNA = Order.resultWhenSecondNA(naLast);
        Comparator<Integer> mainComparator = new Comparator<Integer>(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public int compare(Integer o1, Integer o2) {
                int i1 = o1;
                int i2 = o2;
                boolean na1 = firstComparator.isNA(i1);
                boolean na2 = firstComparator.isNA(i2);
                if (removeNA) {
                    na1 = na1 || hasNA[i1];
                    na2 = na2 || hasNA[i2];
                }
                int res = 0;
                if (!na1) {
                    if (na2) return resSecondNA;
                    res = firstComparator.cmp(i1, i2);
                } else if (!na2) {
                    return resFirstNA;
                }
                int j = 1;
                while (res == 0 && j < nkeys) {
                    ElementsComparator c = comp[j];
                    na1 = c.isNA(i1);
                    na2 = c.isNA(i2);
                    if (!na1) {
                        if (na2) return resSecondNA;
                        res = c.cmp(i1, i2);
                        continue;
                    }
                    if (na2) continue;
                    return resFirstNA;
                }
                return !decreasing ? res : -res;
            }
        };
        Arrays.sort(order, mainComparator);
        if (!removeNA) {
            int[] content = new int[size];
            for (int i = 0; i < size; ++i) {
                content[i] = order[i] + 1;
            }
            return RInt.RIntFactory.getFor(content);
        }
        int nsize = size - naElements;
        int[] content = new int[nsize];
        for (int i = 0; i < nsize; ++i) {
            content[i] = order[i] + 1;
        }
        return RInt.RIntFactory.getFor(content);
    }

    public static final class StringComparator
    extends ElementsComparator {
        final RString v;

        public StringComparator(RString v) {
            this.v = v;
        }

        @Override
        public int cmp(int i, int j) {
            String a = this.v.getString(i);
            String b = this.v.getString(j);
            return a.compareTo(b);
        }

        @Override
        public boolean isNA(int i) {
            return this.v.getString(i) == RString.NA;
        }
    }

    public static final class LogicalComparator
    extends ElementsComparator {
        final RLogical v;

        public LogicalComparator(RLogical v) {
            this.v = v;
        }

        @Override
        public int cmp(int i, int j) {
            int a = this.v.getLogical(i);
            int b = this.v.getLogical(j);
            return a - b;
        }

        @Override
        public boolean isNA(int i) {
            return this.v.getLogical(i) == Integer.MIN_VALUE;
        }
    }

    public static final class IntComparator
    extends ElementsComparator {
        final RInt v;

        public IntComparator(RInt v) {
            this.v = v;
        }

        @Override
        public int cmp(int i, int j) {
            int b;
            int a = this.v.getInt(i);
            if (a > (b = this.v.getInt(j))) {
                return 1;
            }
            if (a == b) {
                return 0;
            }
            return -1;
        }

        @Override
        public boolean isNA(int i) {
            return this.v.getInt(i) == Integer.MIN_VALUE;
        }
    }

    public static final class DoubleComparator
    extends ElementsComparator {
        final RDouble v;

        public DoubleComparator(RDouble v) {
            this.v = v;
        }

        @Override
        public int cmp(int i, int j) {
            double b;
            double a = this.v.getDouble(i);
            if (a > (b = this.v.getDouble(j))) {
                return 1;
            }
            if (a < b) {
                return -1;
            }
            return 0;
        }

        @Override
        public boolean isNA(int i) {
            return RDouble.RDoubleUtils.isNAorNaN(this.v.getDouble(i));
        }
    }

    public static abstract class ElementsComparator {
        public abstract int cmp(int var1, int var2);

        public abstract boolean isNA(int var1);
    }
}

