/*
 * Decompiled with CFR 0.152.
 */
package r.builtins;

import java.util.Arrays;
import r.Utils;
import r.builtins.Builtin;
import r.builtins.CallFactory;
import r.builtins.LApply;
import r.data.RAny;
import r.data.RArray;
import r.data.RDouble;
import r.data.RInt;
import r.data.RString;
import r.data.RSymbol;
import r.data.internal.DoubleImpl;
import r.data.internal.IntImpl;
import r.data.internal.View;
import r.nodes.ast.ASTNode;
import r.nodes.exec.Constant;
import r.nodes.exec.FunctionCall;
import r.nodes.exec.MatrixOperation;
import r.nodes.exec.RNode;
import r.runtime.Frame;

final class Outer
extends CallFactory {
    static final CallFactory _ = new Outer("outer", new String[]{"X", "Y", "FUN", "..."}, new String[]{"X", "Y"});
    private static final boolean EAGER = true;

    private Outer(String name, String[] params, String[] required) {
        super(name, params, required);
    }

    @Override
    public RNode create(ASTNode call, RSymbol[] names, RNode[] exprs) {
        CallFactory.ArgumentInfo ia = this.check(call, names, exprs);
        boolean product = false;
        if (ia.provided("FUN")) {
            RString str;
            RAny value;
            RNode fnode = exprs[ia.position("FUN")];
            if (fnode instanceof Constant && (value = ((Constant)fnode).execute(null)) instanceof RString && (str = (RString)value).size() == 1 && str.getString(0).equals("*")) {
                product = true;
            }
        } else {
            product = true;
        }
        if (product) {
            return new MatrixOperation.OuterProduct(call, exprs[ia.position("X")], exprs[ia.position("Y")]);
        }
        int cnArgs = 2 + names.length - 3;
        RSymbol[] cnNames = new RSymbol[cnArgs];
        RNode[] cnExprs = new RNode[cnArgs];
        cnNames[0] = null;
        LApply.ValueProvider xArgProvider = new LApply.ValueProvider(call);
        cnExprs[0] = xArgProvider;
        LApply.ValueProvider yArgProvider = new LApply.ValueProvider(call);
        cnExprs[1] = yArgProvider;
        LApply.ValueProvider[] constantArgProviders = new LApply.ValueProvider[cnArgs];
        int j = 0;
        for (int i = 0; i < names.length; ++i) {
            if (ia.position("X") == i || ia.position("Y") == i || ia.position("FUN") == i) continue;
            cnNames[2 + j] = names[i];
            LApply.ValueProvider vp = new LApply.ValueProvider(call);
            cnExprs[2 + j] = vp;
            constantArgProviders[j] = vp;
            ++j;
        }
        LApply.CallableProvider callableProvider = new LApply.CallableProvider(call, exprs[ia.position("FUN")]);
        FunctionCall callNode = FunctionCall.getFunctionCall(call, callableProvider, cnNames, cnExprs);
        final int posX = ia.position("X");
        final int posY = ia.position("Y");
        final int posFUN = ia.position("FUN");
        return new OuterBuiltIn(call, names, exprs, callNode, callableProvider, xArgProvider, yArgProvider, constantArgProviders){

            @Override
            public RAny doBuiltIn(Frame frame, RAny[] args) {
                RAny argx = null;
                RAny argy = null;
                RAny argfun = null;
                int k = 0;
                for (int i = 0; i < args.length; ++i) {
                    if (i == posX) {
                        argx = args[i];
                        continue;
                    }
                    if (i == posY) {
                        argy = args[i];
                        continue;
                    }
                    if (i == posFUN) {
                        argfun = args[i];
                        continue;
                    }
                    this.constantArgProviders[k].setValue(args[i]);
                    ++k;
                }
                return this.outer(frame, argx, argy, argfun);
            }
        };
    }

    public static RArray expandYVector(RArray y, int ysize, int count) {
        int size = ysize;
        int nsize = size * count;
        RArray res = Utils.createArray(y, nsize);
        int offset = 0;
        for (int elem = 0; elem < size; ++elem) {
            Object v = y.get(elem);
            for (int i = 0; i < count; ++i) {
                res.set(offset + i, v);
            }
            offset += count;
        }
        return res;
    }

    public static RDouble expandYVector(DoubleImpl yarg, int ysize, int count) {
        int size = ysize;
        int nsize = size * count;
        double[] y = yarg.getContent();
        double[] res = new double[nsize];
        int offset = 0;
        for (int elem = 0; elem < size; ++elem) {
            double v = y[elem];
            Arrays.fill(res, offset, offset + count, v);
            offset += count;
        }
        return RDouble.RDoubleFactory.getFor(res);
    }

    public static RInt expandYVector(IntImpl yarg, int ysize, int count) {
        int size = ysize;
        int nsize = size * count;
        int[] y = yarg.getContent();
        int[] res = new int[nsize];
        int offset = 0;
        for (int elem = 0; elem < size; ++elem) {
            int v = y[elem];
            Arrays.fill(res, offset, offset + count, v);
            offset += count;
        }
        return RInt.RIntFactory.getFor(res);
    }

    public static RInt lazyExpandYVector(RInt yarg, int ysize, final int count) {
        final int nsize = ysize * count;
        return new View.RIntProxy<RInt>(yarg){

            @Override
            public int getInt(int i) {
                int j = i / count;
                return ((RInt)this.orig).getInt(j);
            }

            @Override
            public int size() {
                return nsize;
            }

            @Override
            public int[] dimensions() {
                return null;
            }

            @Override
            public RArray.Names names() {
                return null;
            }

            @Override
            public RAny.Attributes attributes() {
                return null;
            }
        };
    }

    public static RArray expandXVector(RArray x, int xsize, int count) {
        int nsize = xsize * count;
        RArray res = Utils.createArray(x, nsize);
        int offset = 0;
        for (int rep = 0; rep < count; ++rep) {
            for (int i = 0; i < xsize; ++i) {
                res.set(offset + i, x.get(i));
            }
            offset += xsize;
        }
        return res;
    }

    public static RDouble expandXVector(DoubleImpl xarg, int xsize, int count) {
        int nsize = xsize * count;
        double[] x = xarg.getContent();
        double[] res = new double[nsize];
        int offset = 0;
        for (int rep = 0; rep < count; ++rep) {
            System.arraycopy(x, 0, res, offset, xsize);
            offset += xsize;
        }
        return RDouble.RDoubleFactory.getFor(res);
    }

    public static RInt expandXVector(IntImpl xarg, int xsize, int count) {
        int nsize = xsize * count;
        int[] x = xarg.getContent();
        int[] res = new int[nsize];
        int offset = 0;
        for (int rep = 0; rep < count; ++rep) {
            System.arraycopy(x, 0, res, offset, xsize);
            offset += xsize;
        }
        return RInt.RIntFactory.getFor(res);
    }

    public static RInt expandXVectorCacheFriendly(IntImpl xarg, int xsize, int count) {
        int nsize = xsize * count;
        int[] x = xarg.getContent();
        int[] res = new int[nsize];
        int offset = 0;
        int rep = 0;
        int lastOffset = 0;
        if (rep < count) {
            System.arraycopy(x, 0, res, offset, xsize);
            lastOffset = offset;
            offset += xsize;
        }
        for (rep = 1; rep < count; ++rep) {
            System.arraycopy(res, lastOffset, res, offset, xsize);
            lastOffset = offset;
            offset += xsize;
        }
        return RInt.RIntFactory.getFor(res);
    }

    public static RInt lazyExpandXVector(RInt xarg, int xsize, final int count) {
        final int nsize = xsize * count;
        return new View.RIntProxy<RInt>(xarg){

            @Override
            public int getInt(int i) {
                int j = i % count;
                return ((RInt)this.orig).getInt(j);
            }

            @Override
            public int size() {
                return nsize;
            }

            @Override
            public int[] dimensions() {
                return null;
            }

            @Override
            public RArray.Names names() {
                return null;
            }

            @Override
            public RAny.Attributes attributes() {
                return null;
            }
        };
    }

    public static abstract class OuterBuiltIn
    extends Builtin {
        @RNode.Child
        RNode callNode;
        LApply.CallableProvider callableProvider;
        LApply.ValueProvider xArgProvider;
        LApply.ValueProvider yArgProvider;
        LApply.ValueProvider[] constantArgProviders;

        public OuterBuiltIn(ASTNode ast, RSymbol[] argNames, RNode[] argExprs, RNode callNode, LApply.CallableProvider callableProvider, LApply.ValueProvider xArgProvider, LApply.ValueProvider yArgProvider, LApply.ValueProvider[] constantArgProviders) {
            super(ast, argNames, argExprs);
            this.callNode = this.adoptChild(callNode);
            this.callableProvider = callableProvider;
            this.xArgProvider = xArgProvider;
            this.yArgProvider = yArgProvider;
            this.constantArgProviders = constantArgProviders;
        }

        @Override
        protected <N extends RNode> N replaceChild(RNode oldNode, N newNode) {
            assert (oldNode != null);
            if (this.callNode == oldNode) {
                this.callNode = newNode;
                return this.adoptInternal(newNode);
            }
            assert (Utils.check(oldNode != this.callableProvider));
            assert (Utils.check(oldNode != this.xArgProvider));
            assert (Utils.check(oldNode != this.yArgProvider));
            return super.replaceChild(oldNode, newNode);
        }

        public RAny outer(Frame frame, RAny xarg, RAny yarg, RAny farg) {
            int[] dim;
            if (!(xarg instanceof RArray) || !(yarg instanceof RArray)) {
                Utils.nyi("unsupported type");
                return null;
            }
            RArray x = (RArray)xarg;
            RArray y = (RArray)yarg;
            int xsize = x.size();
            int ysize = y.size();
            x = x.materialize();
            RArray expy = (y = y.materialize()) instanceof DoubleImpl ? Outer.expandYVector((DoubleImpl)y, ysize, xsize) : (y instanceof IntImpl ? Outer.expandYVector((IntImpl)y, ysize, xsize) : Outer.expandYVector(y, ysize, xsize));
            RArray expx = xsize > 0 ? (x instanceof DoubleImpl ? Outer.expandXVector((DoubleImpl)x, xsize, ysize) : (x instanceof IntImpl ? Outer.expandXVector((IntImpl)x, xsize, ysize) : Outer.expandXVector(x, xsize, ysize))) : x;
            this.xArgProvider.setValue(expx);
            this.yArgProvider.setValue(expy);
            this.callableProvider.matchAndSet(frame, farg);
            RArray res = (RArray)this.callNode.execute(frame);
            int[] dimx = x.dimensions();
            int[] dimy = y.dimensions();
            if (dimx == null) {
                if (dimy == null) {
                    dim = new int[]{xsize, ysize};
                } else {
                    dim = new int[1 + dimy.length];
                    dim[0] = xsize;
                    System.arraycopy(dimy, 0, dim, 1, dimy.length);
                }
            } else if (dimy == null) {
                dim = new int[dimx.length + 1];
                System.arraycopy(dimx, 0, dim, 0, dimx.length);
                dim[dimx.length] = ysize;
            } else {
                dim = new int[dimx.length + dimy.length];
                System.arraycopy(dimx, 0, dim, 0, dimx.length);
                System.arraycopy(dimy, 0, dim, dimx.length, dimy.length);
            }
            return res.setDimensions(dim);
        }
    }
}

