/*
 * Decompiled with CFR 0.152.
 */
package r.builtins;

import r.builtins.AsBase;
import r.builtins.Builtin;
import r.builtins.CallFactory;
import r.data.RAny;
import r.data.RNull;
import r.data.RString;
import r.data.RSymbol;
import r.errors.RError;
import r.nodes.ast.ASTNode;
import r.nodes.exec.RNode;
import r.runtime.Frame;

final class Paste
extends CallFactory {
    static final CallFactory _ = new Paste("paste", new String[]{"...", "sep", "collapse"}, new String[0]);

    private Paste(String name, String[] params, String[] required) {
        super(name, params, required);
    }

    @Override
    public RNode create(ASTNode call, RSymbol[] names, RNode[] exprs) {
        if (exprs.length == 0) {
            return new Builtin.Builtin0(call, names, exprs){

                @Override
                public RAny doBuiltIn(Frame frame) {
                    return RString.EMPTY;
                }
            };
        }
        CallFactory.ArgumentInfo ia = this.check(call, names, exprs);
        final int sepPosition = ia.position("sep");
        final int collapsePosition = ia.position("collapse");
        int args = exprs.length;
        if (sepPosition != -1) {
            --args;
        }
        if (collapsePosition != -1) {
            --args;
        }
        final int realArgs = args;
        return new Builtin(call, names, exprs){

            @Override
            public RAny doBuiltIn(Frame frame, RAny[] params) {
                return Paste.paste(params, realArgs, sepPosition, collapsePosition, this.ast);
            }
        };
    }

    public static String parseSeparator(ASTNode ast, RAny arg) {
        String str;
        RString s;
        if (arg instanceof RString && (s = (RString)arg).size() > 0 && (str = s.getString(0)) != RString.NA) {
            return str;
        }
        throw RError.getInvalidSeparator(ast);
    }

    public static String parseCollapse(ASTNode ast, RAny arg) {
        String str;
        if (arg instanceof RNull) {
            return null;
        }
        if (!(arg instanceof RString)) {
            throw RError.getInvalidArgument(ast, "collapse");
        }
        RString s = (RString)arg;
        if (s.size() > 0 && (str = s.getString(0)) != RString.NA) {
            return str;
        }
        throw RError.getInvalidArgument(ast, "collapse");
    }

    public static RString paste(RAny[] args, int realArgs, int sepPosition, int collapsePosition, ASTNode ast) {
        String separator = null;
        separator = sepPosition == -1 ? " " : Paste.parseSeparator(ast, args[sepPosition]);
        String collapse = null;
        if (collapsePosition != -1) {
            collapse = Paste.parseCollapse(ast, args[collapsePosition]);
        }
        RString[] stringArgs = new RString[realArgs];
        int j = 0;
        int maxLength = 0;
        for (int i = 0; i < args.length; ++i) {
            if (i == sepPosition || i == collapsePosition) continue;
            RString s = AsBase.genericAsString(ast, args[i]);
            stringArgs[j++] = s;
            int ssize = s.size();
            if (ssize <= maxLength) continue;
            maxLength = ssize;
        }
        if (collapse == null) {
            String[] content = new String[maxLength];
            for (int i = 0; i < maxLength; ++i) {
                StringBuilder str = new StringBuilder();
                for (j = 0; j < realArgs; ++j) {
                    if (j > 0) {
                        str.append(separator);
                    }
                    RString s = stringArgs[j];
                    str.append(s.getString(i % s.size()));
                }
                content[i] = str.toString();
            }
            return RString.RStringFactory.getFor(content);
        }
        StringBuilder str = new StringBuilder();
        for (int i = 0; i < maxLength; ++i) {
            if (i > 0) {
                str.append(collapse);
            }
            for (j = 0; j < realArgs; ++j) {
                if (j > 0) {
                    str.append(separator);
                }
                RString s = stringArgs[j];
                str.append(s.getString(i % s.size()));
            }
        }
        return RString.RStringFactory.getScalar(str.toString());
    }
}

