/*
 * Decompiled with CFR 0.152.
 */
package r.builtins;

import r.Utils;
import r.builtins.Builtin;
import r.builtins.CallFactory;
import r.builtins.File;
import r.data.RAny;
import r.data.RSymbol;
import r.data.internal.Connection;
import r.data.internal.ConnectionMode;
import r.nodes.ast.ASTNode;
import r.nodes.exec.RNode;
import r.runtime.Frame;

final class Pipe
extends CallFactory {
    static final CallFactory _ = new Pipe("pipe", new String[]{"description", "open", "encoding"}, new String[]{"description"});
    static final File.OpenConnection OPEN_PIPE = new File.OpenConnection(){

        @Override
        public Connection createUnopened(String description, ConnectionMode defaultMode) {
            return Connection.PipeConnection.createUnopened(description, defaultMode);
        }

        @Override
        public Connection createOpened(String description, ConnectionMode mode, ASTNode ast) {
            return Connection.PipeConnection.createOpened(description, mode, ast);
        }
    };

    private Pipe(String name, String[] params, String[] required) {
        super(name, params, required);
    }

    @Override
    public RNode create(ASTNode call, RSymbol[] names, RNode[] exprs) {
        CallFactory.ArgumentInfo ia = this.check(call, names, exprs);
        final int posDescription = ia.position("description");
        final int posOpen = ia.position("open");
        if (ia.provided("encoding")) {
            throw Utils.nyi();
        }
        return new Builtin(call, names, exprs){

            @Override
            public RAny doBuiltIn(Frame frame, RAny[] args) {
                String description = posDescription != -1 ? File.getScalarString(args[posDescription], this.ast, "description") : "";
                String open = posOpen != -1 ? File.getScalarString(args[posOpen], this.ast, "open") : "";
                return OPEN_PIPE.open(description, open, this.ast);
            }
        };
    }
}

