/*
 * Decompiled with CFR 0.152.
 */
package r.builtins;

import org.netlib.lapack.LAPACK;
import org.netlib.util.intW;
import r.Convert;
import r.Utils;
import r.builtins.Builtin;
import r.builtins.CallFactory;
import r.data.RAny;
import r.data.RArray;
import r.data.RComplex;
import r.data.RDouble;
import r.data.RInt;
import r.data.RList;
import r.data.RLogical;
import r.data.RSymbol;
import r.errors.RError;
import r.gnur.GNUR;
import r.nodes.ast.ASTNode;
import r.nodes.exec.RNode;
import r.runtime.Frame;

public class Qr
extends CallFactory {
    static final CallFactory _ = new Qr("qr", new String[]{"x", "tol", "LAPACK"}, new String[]{"x"});
    static RArray.Names resultNames = RArray.Names.create(RSymbol.getSymbols(new String[]{"qr", "rank", "qraux", "pivot"}));
    static RAny.Attributes useLAPACKAttr = RAny.Attributes.createAndPut("useLAPACK", RLogical.BOXED_TRUE);

    private Qr(String name, String[] params, String[] required) {
        super(name, params, required);
    }

    public static double parseTol(RAny arg, ASTNode ast) {
        RDouble d = Convert.coerceToDoubleError(arg, ast);
        if (d.size() != 1) {
            throw RError.getInvalidArgument(ast, "tol");
        }
        return d.getDouble(0);
    }

    public static RAny qr(RAny xArg, RAny tolArg, RAny lapackArg, ASTNode ast) {
        boolean lapack;
        int[] dims;
        if (xArg instanceof RComplex) {
            Utils.nyi("ZGEQP3 not supported by netlib");
            return null;
        }
        RDouble x = Convert.coerceToDoubleError(xArg, ast).materialize();
        if (!x.isTemporary()) {
            x = RDouble.RDoubleFactory.copy(x);
        }
        if ((dims = x.dimensions()) == null || dims.length != 2) {
            int size = x.size();
            int[] ndims = new int[]{size, 1};
            x = (RDouble)x.setDimensions(ndims);
            dims = ndims;
        }
        int m = dims[0];
        int n = dims[1];
        boolean bl = lapack = lapackArg == null ? false : Qr.parseUncheckedLogical(lapackArg, ast);
        if (lapack) {
            int[] laJPVT = new int[n];
            int rank = m < n ? m : n;
            double[] laTAU = new double[rank];
            double[] laA = x.getContent();
            double[] laWORK = new double[1];
            intW laINFO = new intW(0);
            LAPACK.getInstance().dgeqp3(m, n, laA, m, laJPVT, laTAU, laWORK, -1, laINFO);
            if (laINFO.val < 0) {
                throw RError.getLapackError(ast, laINFO.val, "dgeqp3");
            }
            int laLWORK = (int)laWORK[0];
            laWORK = new double[laLWORK];
            LAPACK.getInstance().dgeqp3(m, n, laA, m, laJPVT, laTAU, laWORK, laLWORK, laINFO);
            if (laINFO.val < 0) {
                throw RError.getLapackError(ast, laINFO.val, "dgeqp3");
            }
            RAny[] content = new RAny[]{x, RInt.RIntFactory.getScalar(rank), RDouble.RDoubleFactory.getFor(laTAU), RInt.RIntFactory.getFor(laJPVT)};
            return RList.RListFactory.getFor(content, null, resultNames, useLAPACKAttr);
        }
        double tol = tolArg == null ? 1.0E-7 : Qr.parseTol(tolArg, ast);
        double[] raX = x.getContent();
        int[] raK = new int[1];
        double[] raQRAUX = new double[n];
        int[] raJPVT = new int[n];
        for (int i = 0; i < n; ++i) {
            raJPVT[i] = i + 1;
        }
        double[] raWORK = new double[2 * n];
        GNUR.dqrdc2(raX, m, m, n, tol, raK, raQRAUX, raJPVT, raWORK);
        RAny[] content = new RAny[]{x, RInt.RIntFactory.getScalar(raK[0]), RDouble.RDoubleFactory.getFor(raQRAUX), RInt.RIntFactory.getFor(raJPVT)};
        return RList.RListFactory.getFor(content, null, resultNames);
    }

    @Override
    public RNode create(ASTNode call, RSymbol[] names, RNode[] exprs) {
        CallFactory.ArgumentInfo ia = this.check(call, names, exprs);
        final int xPosition = ia.position("x");
        final int tolPosition = ia.position("tol");
        final int lapackPosition = ia.position("LAPACK");
        return new Builtin(call, names, exprs){

            @Override
            public RAny doBuiltIn(Frame frame, RAny[] args) {
                return Qr.qr(args[xPosition], tolPosition == -1 ? null : args[tolPosition], lapackPosition == -1 ? null : args[lapackPosition], this.ast);
            }
        };
    }
}

