/*
 * Decompiled with CFR 0.152.
 */
package r.builtins;

import org.netlib.lapack.LAPACK;
import org.netlib.util.intW;
import r.Convert;
import r.Utils;
import r.builtins.AsMatrix;
import r.builtins.Builtin;
import r.builtins.CallFactory;
import r.data.RAny;
import r.data.RArray;
import r.data.RComplex;
import r.data.RDouble;
import r.data.RInt;
import r.data.RList;
import r.data.RLogical;
import r.data.RSymbol;
import r.errors.RError;
import r.gnur.GNUR;
import r.nodes.ast.ASTNode;
import r.nodes.exec.RNode;
import r.runtime.Frame;

final class QrCoef
extends CallFactory {
    static final CallFactory _ = new QrCoef("qr.coef", new String[]{"qr", "y"}, null);
    static final RSymbol pivotSymbol = RSymbol.getSymbol("pivot");
    static final RSymbol qrauxSymbol = RSymbol.getSymbol("qraux");
    static final RSymbol qrSymbol = RSymbol.getSymbol("qr");
    static final RSymbol rankSymbol = RSymbol.getSymbol("rank");
    static final RSymbol useLAPACKSymbol = RSymbol.getSymbol("useLAPACK");

    private QrCoef(String name, String[] params, String[] required) {
        super(name, params, required);
    }

    public static boolean parseUseLapack(RAny.Attributes attr, ASTNode ast) {
        if (attr == null) {
            return false;
        }
        RAny v = attr.map().get(useLAPACKSymbol);
        if (v != null && v instanceof RLogical) {
            return QrCoef.parseUncheckedLogical(v, ast);
        }
        return false;
    }

    public static RAny coef(RAny qrArg, RAny yArg, ASTNode ast) {
        double[] coef;
        int ny;
        boolean yWasMatrix;
        if (!(qrArg instanceof RList)) {
            throw RError.getFirstQR(ast);
        }
        RList qr = (RList)qrArg;
        RArray.Names qrNames = qr.names();
        int pivotIndex = qrNames.map(pivotSymbol);
        int qrauxIndex = qrNames.map(qrauxSymbol);
        int qrIndex = qrNames.map(qrSymbol);
        int rankIndex = qrNames.map(rankSymbol);
        if (pivotIndex == -1 || qrauxIndex == -1 || qrIndex == -1 || rankIndex == -1) {
            throw RError.getFirstQR(ast);
        }
        RAny qrqrArg = qr.getRAny(qrIndex);
        if (!(qrqrArg instanceof RArray)) {
            throw RError.getFirstQR(ast);
        }
        RArray qrqr = (RArray)qrqrArg;
        int[] dims = qrqr.dimensions();
        if (dims == null || dims.length != 2) {
            throw RError.getFirstQR(ast);
        }
        int n = dims[0];
        int p = dims[1];
        RAny qrRankArg = qr.getRAny(rankIndex);
        RInt qrRank = qrRankArg.asInt();
        if (qrRank.size() < 1) {
            throw RError.getFirstQR(ast);
        }
        int rank = qrRank.getInt(0);
        if (rank == Integer.MIN_VALUE) {
            throw RError.getFirstQR(ast);
        }
        if (!(yArg instanceof RArray)) {
            throw RError.getInvalidArgument(ast, "y");
        }
        RArray y = (RArray)yArg;
        int[] ydims = y.dimensions();
        boolean bl = yWasMatrix = ydims != null && ydims.length == 2;
        if (!yWasMatrix) {
            y = AsMatrix.castToMatrix(y);
            ny = 1;
        } else {
            ny = ydims[1];
        }
        if (p == 0) {
            if (yWasMatrix) {
                return RDouble.RDoubleFactory.getUninitializedArray(p * ny, new int[]{p, ny}, null, null);
            }
            return RDouble.EMPTY;
        }
        if (qrqr instanceof RComplex) {
            Utils.nyi("LAPACK routines zunmgr, ztrtrs not supported by netlib-java");
            return null;
        }
        RDouble dy = Convert.coerceToDoubleError(y, ast).materialize();
        if (!y.isTemporary()) {
            dy = RDouble.RDoubleFactory.copy(dy);
        }
        RDouble qrAux = qr.getRAny(qrauxIndex).asDouble();
        RInt qrPivot = qr.getRAny(pivotIndex).asInt();
        RDouble qrqrDouble = Convert.coerceToDoubleError(qrqr, ast);
        boolean useLAPACK = QrCoef.parseUseLapack(qr.attributes(), ast);
        if (useLAPACK) {
            int j;
            int tgtRow;
            int i;
            double[] laA = qrqrDouble.getContent();
            if (n != y.dimensions()[0]) {
                throw RError.getRHSShouldHaveRows(ast, n, y.dimensions()[0]);
            }
            double[] laTAU = qrAux.getContent();
            int laK = laTAU.length;
            double[] laC = dy.getContent();
            double[] laWORK = new double[1];
            intW laINFO = new intW(0);
            LAPACK.getInstance().dormqr("L", "T", n, ny, laK, laA, n, laTAU, laC, n, laWORK, -1, laINFO);
            if (laINFO.val != 0) {
                throw RError.getLapackError(ast, laINFO.val, "dormqr");
            }
            int laLWORK = (int)laWORK[0];
            laWORK = new double[laLWORK];
            LAPACK.getInstance().dormqr("L", "T", n, ny, laK, laA, n, laTAU, laC, n, laWORK, laLWORK, laINFO);
            if (laINFO.val != 0) {
                throw RError.getLapackError(ast, laINFO.val, "dormqr");
            }
            LAPACK.getInstance().dtrtrs("U", "N", "N", laK, ny, laA, n, laC, n, laINFO);
            if (laINFO.val != 0) {
                throw RError.getLapackError(ast, laINFO.val, "dtrtrs");
            }
            double[] coef2 = new double[p * ny];
            int minnp = n < p ? n : p;
            for (i = 0; i < minnp; ++i) {
                tgtRow = qrPivot.getInt(i) - 1;
                for (j = 0; j < ny; ++j) {
                    coef2[j * p + tgtRow] = laC[j * n + i];
                }
            }
            for (i = minnp; i < p; ++i) {
                tgtRow = qrPivot.getInt(i) - 1;
                for (j = 0; j < ny; ++j) {
                    coef2[j * p + tgtRow] = RDouble.NA;
                }
            }
            if (yWasMatrix) {
                return RDouble.RDoubleFactory.getFor(coef2, new int[]{p, ny}, null);
            }
            return RDouble.RDoubleFactory.getFor(coef2);
        }
        if (rank == 0) {
            if (yWasMatrix) {
                return RDouble.RDoubleFactory.getNAArray(p * ny, new int[]{p, ny});
            }
            return RDouble.RDoubleFactory.getNAArray(p);
        }
        if (n != y.dimensions()[0]) {
            throw RError.getSameNumberRows(ast, "qr", "y");
        }
        double[] raX = qrqrDouble.getContent();
        double[] raB = new double[rank * ny];
        int[] info = new int[1];
        GNUR.dqrcf(raX, n, rank, qrAux.getContent(), dy.getContent(), ny, raB, info);
        if (info[0] != 0) {
            throw RError.getExactSingularity(ast, "qr.coef");
        }
        int[] coefDims = null;
        if (rank < p) {
            int j;
            int tgtRow;
            int i;
            coef = new double[p * ny];
            for (i = 0; i < rank; ++i) {
                tgtRow = qrPivot.getInt(i) - 1;
                for (j = 0; j < ny; ++j) {
                    coef[j * p + tgtRow] = raB[j * n + i];
                }
            }
            for (i = rank; i < p; ++i) {
                tgtRow = qrPivot.getInt(i) - 1;
                for (j = 0; j < ny; ++j) {
                    coef[j * p + tgtRow] = RDouble.NA;
                }
            }
            if (yWasMatrix) {
                coefDims = new int[]{p, ny};
            }
        } else {
            coef = raB;
            if (yWasMatrix) {
                coefDims = new int[]{rank, ny};
            }
        }
        return RDouble.RDoubleFactory.getFor(coef, coefDims, null);
    }

    @Override
    public RNode create(ASTNode call, RSymbol[] names, RNode[] exprs) {
        CallFactory.ArgumentInfo ia = this.check(call, names, exprs);
        final int qrPosition = ia.position("qr");
        final int yPosition = ia.position("y");
        return new Builtin(call, names, exprs){

            @Override
            public RAny doBuiltIn(Frame frame, RAny[] args) {
                RAny qrArg = args[qrPosition];
                RAny yArg = args[yPosition];
                return QrCoef.coef(qrArg, yArg, this.ast);
            }
        };
    }
}

