/*
 * Decompiled with CFR 0.152.
 */
package r.builtins;

import r.Utils;
import r.builtins.Builtin;
import r.builtins.CallFactory;
import r.builtins.Qr;
import r.builtins.QrCoef;
import r.data.RAny;
import r.data.RArray;
import r.data.RDouble;
import r.data.RInt;
import r.data.RList;
import r.data.RSymbol;
import r.errors.RError;
import r.nodes.ast.ASTNode;
import r.nodes.exec.RNode;
import r.runtime.Frame;

final class QrSolve
extends CallFactory {
    static final CallFactory _ = new QrSolve("qr.solve", new String[]{"a", "b", "tol"}, new String[]{"a"});

    private QrSolve(String name, String[] params, String[] required) {
        super(name, params, required);
    }

    @Override
    public RNode create(ASTNode call, RSymbol[] names, RNode[] exprs) {
        CallFactory.ArgumentInfo ia = this.check(call, names, exprs);
        final int aPosition = ia.position("a");
        final int bPosition = ia.position("b");
        final int tolPosition = ia.position("tol");
        return new Builtin(call, names, exprs){

            @Override
            public RAny doBuiltIn(Frame frame, RAny[] args) {
                RAny b;
                int mind;
                RAny aArg = args[aPosition];
                RList a = !(aArg instanceof RList) ? (RList)Qr.qr(aArg, tolPosition == -1 ? null : args[tolPosition], null, this.ast) : (RList)aArg;
                RArray.Names aNames = a.names();
                int qrIndex = aNames.map(QrCoef.qrSymbol);
                int rankIndex = aNames.map(QrCoef.rankSymbol);
                RArray qr = (RArray)a.getRAny(qrIndex);
                int[] qdim = qr.dimensions();
                int nrow = qdim[0];
                int ncol = qdim[1];
                RInt qrRank = a.getRAny(rankIndex).asInt();
                int rank = qrRank.getInt(0);
                int n = mind = ncol > nrow ? nrow : ncol;
                if (rank != mind) {
                    throw RError.getSingularSolve(this.ast, "a");
                }
                if (bPosition == -1) {
                    if (ncol != nrow) {
                        throw RError.getOnlySquareInverted(this.ast);
                    }
                    double[] bcontent = new double[ncol * ncol];
                    for (int i = 0; i < ncol; ++i) {
                        bcontent[i * (ncol + 1)] = 1.0;
                    }
                    b = RDouble.RDoubleFactory.getMatrixFor(bcontent, ncol, ncol);
                } else {
                    b = args[bPosition];
                }
                RAny res = QrCoef.coef(a, b, this.ast);
                if (res instanceof RDouble) {
                    return RDouble.RDoubleUtils.convertNAandNaNtoZero((RDouble)res);
                }
                Utils.nyi("complex case not implemented");
                return null;
            }
        };
    }
}

