/*
 * Decompiled with CFR 0.152.
 */
package r.builtins;

import java.util.Arrays;
import java.util.Comparator;
import r.RContext;
import r.Utils;
import r.builtins.Builtin;
import r.builtins.CallFactory;
import r.builtins.Order;
import r.data.RAny;
import r.data.RArray;
import r.data.RComplex;
import r.data.RDouble;
import r.data.RInt;
import r.data.RLogical;
import r.data.RString;
import r.data.RSymbol;
import r.data.internal.DoubleImpl;
import r.data.internal.IntImpl;
import r.errors.RError;
import r.nodes.ast.ASTNode;
import r.nodes.exec.RNode;
import r.runtime.Frame;

final class Rank
extends CallFactory {
    static final CallFactory _ = new Rank("rank", new String[]{"x", "na.last", "ties.method"}, new String[]{"x"});
    static final CallFactory.ArgumentMatch tiesMethodMatch = new CallFactory.ArgumentMatch(new String[]{"average", "first", "random", "max", "min"});
    static final int TM_AVERAGE = 0;
    static final int TM_FIRST = 1;
    static final int TM_RANDOM = 2;
    static final int TM_MAX = 3;
    static final int TM_MIN = 4;

    private Rank(String name, String[] parameters, String[] required) {
        super(name, parameters, required);
    }

    public static NaLast parseNaLast(RAny arg, ASTNode ast) {
        if (arg instanceof RLogical || arg instanceof RInt || arg instanceof RDouble || arg instanceof RComplex) {
            RLogical larg = arg.asLogical();
            int size = larg.size();
            if (size == 0) {
                throw RError.getUnexpectedNA(ast);
            }
            if (size > 1) {
                RContext.warning(ast, "the condition has length > 1 and only the first element will be used");
            }
            switch (larg.getLogical(0)) {
                case 1: {
                    return NaLast.TRUE;
                }
                case 0: {
                    return NaLast.FALSE;
                }
            }
            return NaLast.NA;
        }
        if (arg instanceof RString) {
            String s;
            RString sarg = (RString)arg;
            int size = sarg.size();
            if (size == 0) {
                throw RError.getUnexpectedNA(ast);
            }
            if (size > 1) {
                RContext.warning(ast, "the condition has length > 1 and only the first element will be used");
            }
            if ((s = sarg.getString(0)) == RString.NA) {
                return NaLast.NA;
            }
            if (s.equals("keep")) {
                return NaLast.KEEP;
            }
        }
        throw RError.getInvalidArgument(ast, "na.last");
    }

    @Override
    public RNode create(ASTNode call, RSymbol[] names, RNode[] exprs) {
        CallFactory.ArgumentInfo ia = this.check(call, names, exprs);
        final int xPosition = ia.position("x");
        final int naLastPosition = ia.position("na.last");
        final int tiesMethodPosition = ia.position("ties.method");
        return new Builtin(call, names, exprs){

            @Override
            public RAny doBuiltIn(Frame frame, RAny[] args) {
                NaLast naLast = naLastPosition == -1 ? NaLast.TRUE : Rank.parseNaLast(args[naLastPosition], this.ast);
                int tiesMethod = tiesMethodPosition == -1 ? 0 : tiesMethodMatch.match(args[tiesMethodPosition], this.ast, "ties.method");
                RAny xarg = args[xPosition];
                if (!(xarg instanceof RArray)) {
                    throw RError.getInvalidArgument(this.ast, "x");
                }
                RArray x = (RArray)xarg;
                return Rank.rank(x, naLast, tiesMethod, this.ast);
            }
        };
    }

    public static RAny rank(RArray x, NaLast naLast, int tiesMethod, ASTNode ast) {
        RArray rank;
        int size = x.size();
        int oi = 0;
        Integer[] order = new Integer[size];
        boolean[] isna = null;
        for (int i = 0; i < size; ++i) {
            if (x.isNAorNaN(i)) {
                if (isna == null) {
                    isna = new boolean[size];
                }
                isna[i] = true;
                continue;
            }
            order[oi++] = i;
        }
        int nnas = size - oi;
        final Order.ElementsComparator c = Order.createComparator(x, ast);
        Comparator<Integer> mainComparator = new Comparator<Integer>(){

            @Override
            public int compare(Integer o1, Integer o2) {
                return c.cmp(o1, o2);
            }
        };
        Arrays.sort(order, 0, oi, mainComparator);
        switch (tiesMethod) {
            case 0: {
                rank = Rank.rankAverage(order, oi, c);
                break;
            }
            case 3: {
                rank = Rank.rankMax(order, oi, c);
                break;
            }
            case 4: {
                rank = Rank.rankMin(order, oi, c);
                break;
            }
            case 1: {
                rank = Rank.rankFirst(order, oi);
                break;
            }
            default: {
                Utils.nyi("unsupported ties method");
                return null;
            }
        }
        RArray.Names xnames = x.names();
        if (nnas == 0) {
            return rank.setNames(xnames);
        }
        if (naLast == NaLast.NA) {
            if (xnames == null) {
                return rank;
            }
            RArray nrank = Utils.createArray(rank, oi);
            RSymbol[] symbols = xnames.sequence();
            RSymbol[] nsymbols = new RSymbol[oi];
            int j = 0;
            for (int i = 0; i < size; ++i) {
                if (isna[i]) continue;
                nsymbols[j] = symbols[i];
                nrank.set(j, rank.get(i));
                ++j;
            }
            return nrank.setNames(RArray.Names.create(nsymbols));
        }
        if (naLast == NaLast.KEEP) {
            for (int i = 0; i < size; ++i) {
                if (!isna[i]) continue;
                rank.set(i, x.get(i));
            }
            return rank.setNames(xnames);
        }
        if (naLast == NaLast.TRUE) {
            if (tiesMethod == 0) {
                double[] content = ((DoubleImpl)rank).getContent();
                int newRank = oi;
                for (int i = 0; i < size; ++i) {
                    if (!isna[i]) continue;
                    content[i] = ++newRank;
                }
            } else {
                int[] content = ((IntImpl)rank).getContent();
                int newRank = oi;
                for (int i = 0; i < size; ++i) {
                    if (!isna[i]) continue;
                    content[i] = ++newRank;
                }
            }
            return rank.setNames(xnames);
        }
        assert (Utils.check(naLast == NaLast.FALSE));
        if (tiesMethod == 0) {
            double[] content = ((DoubleImpl)rank).getContent();
            int naIndex = 1;
            for (int i = 0; i < size; ++i) {
                if (!isna[i]) {
                    int n = i;
                    content[n] = content[n] + (double)nnas;
                    continue;
                }
                content[i] = naIndex++;
            }
        } else {
            int[] content = ((IntImpl)rank).getContent();
            int naIndex = 1;
            for (int i = 0; i < size; ++i) {
                if (!isna[i]) {
                    int n = i;
                    content[n] = content[n] + nnas;
                    continue;
                }
                content[i] = naIndex++;
            }
        }
        return rank.setNames(xnames);
    }

    public static RArray rankAverage(Integer[] order, int orderUsed, Order.ElementsComparator c) {
        double[] res = new double[order.length];
        int j = 0;
        int i = 0;
        while (i < orderUsed) {
            for (j = i; j < orderUsed - 1 && c.cmp(order[j], order[j + 1]) == 0; ++j) {
            }
            double value = ((double)(i + j) + 2.0) / 2.0;
            for (int k = i; k <= j; ++k) {
                res[order[k].intValue()] = value;
            }
            i = j + 1;
        }
        return RDouble.RDoubleFactory.getFor(res);
    }

    public static RArray rankMax(Integer[] order, int orderUsed, Order.ElementsComparator c) {
        int[] res = new int[order.length];
        int j = 0;
        int i = 0;
        while (i < orderUsed) {
            for (j = i; j < orderUsed - 1 && c.cmp(order[j], order[j + 1]) == 0; ++j) {
            }
            int value = j + 1;
            for (int k = i; k <= j; ++k) {
                res[order[k].intValue()] = value;
            }
            i = j + 1;
        }
        return RInt.RIntFactory.getFor(res);
    }

    public static RArray rankMin(Integer[] order, int orderUsed, Order.ElementsComparator c) {
        int[] res = new int[order.length];
        int j = 0;
        int i = 0;
        while (i < orderUsed) {
            for (j = i; j < orderUsed - 1 && c.cmp(order[j], order[j + 1]) == 0; ++j) {
            }
            int value = i + 1;
            for (int k = i; k <= j; ++k) {
                res[order[k].intValue()] = value;
            }
            i = j + 1;
        }
        return RInt.RIntFactory.getFor(res);
    }

    public static RArray rankFirst(Integer[] order, int orderUsed) {
        int[] res = new int[order.length];
        for (int i = 0; i < orderUsed; ++i) {
            res[order[i].intValue()] = i + 1;
        }
        return RInt.RIntFactory.getFor(res);
    }

    static enum NaLast {
        TRUE,
        FALSE,
        NA,
        KEEP;

    }
}

