/*
 * Decompiled with CFR 0.152.
 */
package r.builtins;

import r.RContext;
import r.builtins.Builtin;
import r.builtins.CallFactory;
import r.builtins.internal.Random;
import r.data.RAny;
import r.data.RDouble;
import r.data.RSymbol;
import r.gnur.GNUR;
import r.nodes.ast.ASTNode;
import r.nodes.exec.RNode;
import r.runtime.Frame;

public class Rbinom
extends CallFactory {
    static final CallFactory _ = new Rbinom("rbinom", new String[]{"n", "size", "prob"}, null);
    static final double[] defaultScale = new double[]{1.0};

    private Rbinom(String name, String[] params, String[] required) {
        super(name, params, required);
    }

    @Override
    public RNode create(ASTNode call, RSymbol[] names, RNode[] exprs) {
        CallFactory.ArgumentInfo ia = this.check(call, names, exprs);
        final int nPosition = ia.position("n");
        final int sizePosition = ia.position("size");
        final int probPosition = ia.position("prob");
        return new Builtin(call, names, exprs){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public RAny doBuiltIn(Frame frame, RAny[] args) {
                int n = Random.parseNArgument(args[nPosition], this.ast);
                double[] size = Random.parseNumericArgument(args[sizePosition], this.ast);
                double[] prob = Random.parseNumericArgument(args[probPosition], this.ast);
                if (size.length == 0 || prob.length == 0) {
                    return Random.allNAs(n, this.ast);
                }
                int[] rngKind = Random.updateNativeSeed(this.ast);
                try {
                    RDouble rDouble = RDouble.RDoubleFactory.getFor(Rbinom.rbinom(n, size, prob, this.ast));
                    return rDouble;
                }
                finally {
                    Random.updateWorkspaceSeed(rngKind);
                }
            }
        };
    }

    public static double[] rbinom(int n, double[] size, double[] prob, ASTNode ast) {
        double[] res = new double[n];
        boolean naProduced = GNUR.rbinom(res, n, size, size.length, prob, prob.length);
        if (naProduced) {
            RContext.warning(ast, "NAs produced");
        }
        return res;
    }
}

