/*
 * Decompiled with CFR 0.152.
 */
package r.builtins;

import r.RContext;
import r.builtins.Builtin;
import r.builtins.CallFactory;
import r.builtins.internal.Random;
import r.data.RAny;
import r.data.RDouble;
import r.data.RSymbol;
import r.gnur.GNUR;
import r.nodes.ast.ASTNode;
import r.nodes.exec.RNode;
import r.runtime.Frame;

public class Rcauchy
extends CallFactory {
    static final CallFactory _ = new Rcauchy("rcauchy", new String[]{"n", "location", "scale"}, new String[]{"n"});
    static final double[] defaultLocation = new double[]{0.0};
    static final double[] defaultScale = new double[]{1.0};

    private Rcauchy(String name, String[] params, String[] required) {
        super(name, params, required);
    }

    @Override
    public RNode create(ASTNode call, RSymbol[] names, RNode[] exprs) {
        CallFactory.ArgumentInfo ia = this.check(call, names, exprs);
        if (names.length == 1) {
            return new Builtin.Builtin1(call, names, exprs){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public RAny doBuiltIn(Frame frame, RAny narg) {
                    int n = Random.parseNArgument(narg, this.ast);
                    int[] rngKind = Random.updateNativeSeed(this.ast);
                    try {
                        RDouble rDouble = RDouble.RDoubleFactory.getFor(Rcauchy.rcauchyStd(n, this.ast));
                        return rDouble;
                    }
                    finally {
                        Random.updateWorkspaceSeed(rngKind);
                    }
                }
            };
        }
        final int nPosition = ia.position("n");
        final int locationPosition = ia.position("location");
        final int scalePosition = ia.position("scale");
        return new Builtin(call, names, exprs){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public RAny doBuiltIn(Frame frame, RAny[] args) {
                double[] scale;
                int n = Random.parseNArgument(args[nPosition], this.ast);
                double[] location = locationPosition == -1 ? defaultLocation : Random.parseNumericArgument(args[locationPosition], this.ast);
                double[] dArray = scale = scalePosition == -1 ? defaultScale : Random.parseNumericArgument(args[scalePosition], this.ast);
                if (location.length == 0 || scale.length == 0) {
                    return Random.allNAs(n, this.ast);
                }
                int[] rngKind = Random.updateNativeSeed(this.ast);
                try {
                    RDouble rDouble = RDouble.RDoubleFactory.getFor(Rcauchy.rcauchy(n, location, scale, this.ast));
                    return rDouble;
                }
                finally {
                    Random.updateWorkspaceSeed(rngKind);
                }
            }
        };
    }

    public static double[] rcauchyStd(int n, ASTNode ast) {
        double[] res = new double[n];
        boolean naProduced = GNUR.rcauchyStd(res, n);
        if (naProduced) {
            RContext.warning(ast, "NAs produced");
        }
        return res;
    }

    public static double[] rcauchy(int n, double[] location, double[] scale, ASTNode ast) {
        double[] res = new double[n];
        boolean naProduced = GNUR.rcauchy(res, n, location, location.length, scale, scale.length);
        if (naProduced) {
            RContext.warning(ast, "NAs produced");
        }
        return res;
    }
}

