/*
 * Decompiled with CFR 0.152.
 */
package r.builtins;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import r.Convert;
import r.RContext;
import r.Utils;
import r.builtins.Builtin;
import r.builtins.CallFactory;
import r.builtins.File;
import r.data.RAny;
import r.data.RInt;
import r.data.RLogical;
import r.data.RString;
import r.data.RSymbol;
import r.data.internal.Connection;
import r.data.internal.ConnectionMode;
import r.errors.RError;
import r.nodes.ast.ASTNode;
import r.nodes.exec.RNode;
import r.runtime.Frame;

final class ReadLines
extends CallFactory {
    static final CallFactory _ = new ReadLines("readLines", new String[]{"con", "n", "ok", "warn", "encoding"}, new String[0]);

    private ReadLines(String name, String[] params, String[] required) {
        super(name, params, required);
    }

    @Override
    public RNode create(ASTNode call, RSymbol[] names, RNode[] exprs) {
        CallFactory.ArgumentInfo ia = this.check(call, names, exprs);
        if (ia.provided("encoding")) {
            throw Utils.nyi();
        }
        final int posCon = ia.position("con");
        final int posN = ia.position("n");
        final int posOk = ia.position("ok");
        final int posWarn = ia.position("warn");
        final ConnectionMode defaultMode = ConnectionMode.get("rt");
        return new Builtin(call, names, exprs){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public RAny doBuiltIn(Frame frame, RAny[] args) {
                int n = posN == -1 ? -1 : ReadLines.parseN(args[posN], this.ast);
                boolean ok = posOk == -1 ? true : ReadLines.parseLogicalScalar(args[posOk], this.ast, "ok");
                boolean warn = posWarn == -1 ? true : ReadLines.parseLogicalScalar(args[posWarn], this.ast, "warn");
                Connection con = null;
                boolean wasOpen = false;
                if (posCon == -1) {
                    throw Utils.nyi("stdin");
                }
                RAny conArg = args[posCon];
                if (conArg instanceof RString) {
                    String description = File.getScalarString(conArg, this.ast, "description");
                    con = Connection.FileConnection.createOpened(description, defaultMode, this.ast);
                } else if (conArg instanceof RInt) {
                    RInt iarg = (RInt)conArg;
                    if (iarg.size() != 1) {
                        throw RError.getNotConnection(this.ast, "con");
                    }
                    int handle = iarg.getInt(0);
                    con = RContext.getConnection(handle);
                    Utils.check(con != null);
                    if (con.isOpen()) {
                        ConnectionMode mode = con.currentMode();
                        if (!mode.read()) {
                            throw RError.getCannotReadConnection(this.ast);
                        }
                        Utils.check(mode.text());
                        wasOpen = true;
                    } else {
                        con.open(defaultMode, this.ast);
                    }
                }
                try {
                    BufferedReader reader = con.reader(this.ast);
                    ArrayList<String> buf = new ArrayList<String>();
                    String line = "";
                    int nlines = 0;
                    try {
                        while ((line = reader.readLine()) != null) {
                            buf.add(line);
                            if (++nlines != n) continue;
                            break;
                        }
                    }
                    catch (IOException e) {
                        throw RError.getGenericError(this.ast, e.toString());
                    }
                    if (!ok && nlines < n) {
                        throw RError.getTooFewLinesReadLines(this.ast);
                    }
                    String[] content = new String[buf.size()];
                    buf.toArray(content);
                    if (nlines <= 0 || content[nlines - 1].length() != 0) {
                        // empty if block
                    }
                    RString rString = RString.RStringFactory.getFor(content);
                    return rString;
                }
                finally {
                    if (!wasOpen) {
                        con.close(this.ast);
                    }
                }
            }
        };
    }

    public static int parseN(RAny arg, ASTNode ast) {
        int n;
        RInt narg = Convert.coerceToIntWarning(arg, ast);
        if (narg.size() >= 1 && (n = narg.getInt(0)) != Integer.MIN_VALUE) {
            return n;
        }
        throw RError.getInvalidArgument(ast, "n");
    }

    public static boolean parseLogicalScalar(RAny arg, ASTNode ast, String argName) {
        RLogical larg = arg.asLogical();
        if (larg.size() >= 1) {
            int l = larg.getLogical(0);
            if (l == 1) {
                return true;
            }
            if (l == 0) {
                return false;
            }
        }
        throw RError.getInvalidArgument(ast, argName);
    }
}

