/*
 * Decompiled with CFR 0.152.
 */
package r.builtins;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import r.Convert;
import r.RContext;
import r.builtins.Builtin;
import r.builtins.CallFactory;
import r.builtins.Sub;
import r.data.RAny;
import r.data.RInt;
import r.data.RList;
import r.data.RString;
import r.data.RSymbol;
import r.errors.RError;
import r.nodes.ast.ASTNode;
import r.nodes.exec.RNode;
import r.runtime.Frame;

class Regexpr
extends CallFactory {
    static final CallFactory _ = new Regexpr("regexpr", new String[]{"pattern", "text", "ignore.case", "perl", "fixed", "useBytes"}, new String[]{"pattern", "text"}, false);
    boolean global;

    Regexpr(String name, String[] params, String[] required, boolean global) {
        super(name, params, required);
        this.global = global;
    }

    @Override
    public RNode create(ASTNode call, RSymbol[] names, RNode[] exprs) {
        CallFactory.ArgumentInfo ia = this.check(call, names, exprs);
        final int posUseBytes = ia.position("useBytes");
        final int posPattern = ia.position("pattern");
        final int posText = ia.position("text");
        final int posPerl = ia.position("perl");
        final int posFixed = ia.position("fixed");
        final int posIgnoreCase = ia.position("ignore.case");
        return new Builtin(call, names, exprs){

            @Override
            public RAny doBuiltIn(Frame frame, RAny[] args) {
                boolean fixed;
                if (posUseBytes != -1) {
                    RContext.warning(this.ast, "Ignoring useBytes.");
                }
                String pattern = Sub.parseScalarString(this.ast, args[posPattern], "pattern");
                RString text = Convert.coerceToStringError(args[posText], this.ast);
                boolean ignoreCase = posIgnoreCase != -1 ? Convert.checkFirstLogical(args[posIgnoreCase], 1) : false;
                boolean perl = posPerl != -1 ? Convert.checkFirstLogical(args[posPerl], 1) : false;
                boolean bl = fixed = posFixed != -1 ? Convert.checkFirstLogical(args[posFixed], 1) : false;
                if (pattern == RString.NA) {
                    throw RError.getInvalidArgument(this.ast, "pattern");
                }
                if (!perl) {
                    RContext.warning(this.ast, "Using a Perl-like regular expression syntax (non-Perl not implemented yet).");
                }
                Pattern p = Pattern.compile(pattern, (ignoreCase ? 2 : 0) | (fixed ? 16 : 0));
                return Regexpr.this.global ? Regexpr.gregexpr(p, text) : Regexpr.regexpr(p, text);
            }
        };
    }

    public static RInt regexpr(Pattern p, RString text) {
        int size = text.size();
        int[] content = new int[size];
        for (int i = 0; i < size; ++i) {
            String s = text.getString(i);
            if (s != RString.NA) {
                Matcher m = p.matcher(s);
                if (m.find()) {
                    content[i] = m.start() + 1;
                    continue;
                }
                content[i] = -1;
                continue;
            }
            content[i] = Integer.MIN_VALUE;
        }
        return RInt.RIntFactory.getFor(content);
    }

    public static RList gregexpr(Pattern p, RString text) {
        int size = text.size();
        RAny[] content = new RAny[size];
        int[] buf = new int[size];
        int bufUsed = 0;
        for (int i = 0; i < size; ++i) {
            String s = text.getString(i);
            if (s != RString.NA) {
                Matcher m = p.matcher(s);
                bufUsed = 0;
                while (m.find()) {
                    if (bufUsed == buf.length) {
                        int[] oldbuf = buf;
                        buf = new int[bufUsed * 2];
                        System.arraycopy(oldbuf, 0, buf, 0, bufUsed);
                    }
                    buf[bufUsed++] = m.start() + 1;
                }
                if (bufUsed > 0) {
                    int[] econtent = new int[bufUsed];
                    System.arraycopy(buf, 0, econtent, 0, bufUsed);
                    content[i] = RInt.RIntFactory.getFor(econtent);
                    continue;
                }
                content[i] = RInt.RIntFactory.getScalar(-1);
                continue;
            }
            content[i] = RInt.BOXED_NA;
        }
        return RList.RListFactory.getFor(content);
    }
}

