/*
 * Decompiled with CFR 0.152.
 */
package r.builtins;

import java.util.Arrays;
import r.Convert;
import r.Utils;
import r.builtins.Builtin;
import r.builtins.CallFactory;
import r.builtins.RepInt;
import r.data.RAny;
import r.data.RArray;
import r.data.RComplex;
import r.data.RDouble;
import r.data.RInt;
import r.data.RLogical;
import r.data.RRaw;
import r.data.RString;
import r.data.RSymbol;
import r.data.internal.ComplexImpl;
import r.data.internal.DoubleImpl;
import r.data.internal.IntImpl;
import r.data.internal.LogicalImpl;
import r.data.internal.RawImpl;
import r.data.internal.StringImpl;
import r.errors.RError;
import r.nodes.ast.ASTNode;
import r.nodes.exec.RNode;
import r.runtime.Frame;

class Rep
extends CallFactory {
    static final CallFactory _ = new Rep("rep", new String[]{"x", "..."}, new String[0]);
    public static final boolean EAGER = true;

    Rep(String name, String[] params, String[] required) {
        super(name, params, required);
    }

    @Override
    public RNode create(ASTNode call, RSymbol[] names, RNode[] exprs) {
        CallFactory.ArgumentInfo ia = this.check(call, names, exprs);
        if (names.length == 2) {
            int otherPos = ia.position("x") == 0 ? 1 : 0;
            RSymbol otherName = names[otherPos];
            if (otherName == null || otherName == RSymbol.TIMES_SYMBOL) {
                return RepInt._.create(call, names, exprs);
            }
            if (otherName == RSymbol.getSymbol("length.out")) {
                final boolean xfirst = ia.position("x") == 0;
                return new Builtin.Builtin2(call, names, exprs){

                    @Override
                    public RAny doBuiltIn(Frame frame, RAny arg0, RAny arg1) {
                        return Rep.genericRepLengthOut(this.ast, xfirst ? arg0 : arg1, xfirst ? arg1 : arg0);
                    }
                };
            }
        }
        throw Utils.nyi("unsupported rep arguments");
    }

    public static void checkScalar(RArray a, ASTNode ast) {
        int n = a.size();
        if (n != 1) {
            throw RError.getInvalidTimes(ast);
        }
    }

    public static RSymbol[] rep(RSymbol value, int size) {
        Object[] res = new RSymbol[size];
        Arrays.fill(res, value);
        return res;
    }

    public static RSymbol[] rep(RSymbol[] origArray, int origSize, int newSize) {
        int end;
        RSymbol[] newArray = new RSymbol[newSize];
        int start = 0;
        while ((end = start + origSize) <= newSize) {
            System.arraycopy(origArray, 0, newArray, start, origSize);
            start = end;
        }
        System.arraycopy(origArray, 0, newArray, start, newSize - start);
        return newArray;
    }

    public static byte[] rep(byte value, int size) {
        byte[] res = new byte[size];
        Arrays.fill(res, value);
        return res;
    }

    public static byte[] rep(byte[] origArray, int origSize, int newSize) {
        int end;
        byte[] newArray = new byte[newSize];
        int start = 0;
        while ((end = start + origSize) <= newSize) {
            System.arraycopy(origArray, 0, newArray, start, origSize);
            start = end;
        }
        System.arraycopy(origArray, 0, newArray, start, newSize - start);
        return newArray;
    }

    public static int[] rep(int value, int size) {
        int[] res = new int[size];
        Arrays.fill(res, value);
        return res;
    }

    public static int[] rep(int[] origArray, int origSize, int newSize) {
        int end;
        int[] newArray = new int[newSize];
        int start = 0;
        while ((end = start + origSize) <= newSize) {
            System.arraycopy(origArray, 0, newArray, start, origSize);
            start = end;
        }
        System.arraycopy(origArray, 0, newArray, start, newSize - start);
        return newArray;
    }

    public static double[] rep(double value, int size) {
        double[] res = new double[size];
        Arrays.fill(res, value);
        return res;
    }

    public static double[] rep(double[] origArray, int origSize, int newSize) {
        int end;
        double[] newArray = new double[newSize];
        int start = 0;
        while ((end = start + origSize) <= newSize) {
            System.arraycopy(origArray, 0, newArray, start, origSize);
            start = end;
        }
        System.arraycopy(origArray, 0, newArray, start, newSize - start);
        return newArray;
    }

    public static String[] rep(String value, int size) {
        Object[] res = new String[size];
        Arrays.fill(res, value);
        return res;
    }

    public static String[] rep(String[] origArray, int origSize, int newSize) {
        int end;
        String[] newArray = new String[newSize];
        int start = 0;
        while ((end = start + origSize) <= newSize) {
            System.arraycopy(origArray, 0, newArray, start, origSize);
            start = end;
        }
        System.arraycopy(origArray, 0, newArray, start, newSize - start);
        return newArray;
    }

    public static byte[] repValues(RRaw origArray, int origSize, int newSize) {
        if (origSize == 1) {
            return Rep.rep(origArray.getRaw(0), newSize);
        }
        return Rep.rep(((RawImpl)origArray.materialize()).getContent(), origSize, newSize);
    }

    public static int[] repValues(RInt origArray, int origSize, int newSize) {
        if (origSize == 1) {
            return Rep.rep(origArray.getInt(0), newSize);
        }
        return Rep.rep(((IntImpl)origArray.materialize()).getContent(), origSize, newSize);
    }

    public static int[] repValues(RLogical origArray, int origSize, int newSize) {
        if (origSize == 1) {
            return Rep.rep(origArray.getLogical(0), newSize);
        }
        return Rep.rep(((LogicalImpl)origArray.materialize()).getContent(), origSize, newSize);
    }

    public static double[] repValues(RDouble origArray, int origSize, int newSize) {
        if (origSize == 1) {
            return Rep.rep(origArray.getDouble(0), newSize);
        }
        return Rep.rep(((DoubleImpl)origArray.materialize()).getContent(), origSize, newSize);
    }

    public static double[] repValues(RComplex origArray, int origSize, int newSize) {
        if (origSize == 1) {
            return Rep.rep(new double[]{origArray.getReal(0), origArray.getImag(0)}, 2, newSize * 2);
        }
        return Rep.rep(((ComplexImpl)origArray.materialize()).getContent(), origSize * 2, newSize * 2);
    }

    public static String[] repValues(RString origArray, int origSize, int newSize) {
        if (origSize == 1) {
            return Rep.rep(origArray.getString(0), newSize);
        }
        return Rep.rep(((StringImpl)origArray.materialize()).getContent(), origSize, newSize);
    }

    public static RArray.Names repNames(RArray.Names origNames, int origSize, int size) {
        if (origNames == null) {
            return null;
        }
        return RArray.Names.create(Rep.rep(origNames.sequence(), origSize, size));
    }

    public static RRaw repInt(RRaw orig, int origSize, int size) {
        RArray.Names names = orig.names();
        return RRaw.RRawFactory.getFor(Rep.repValues(orig, origSize, size), null, Rep.repNames(names, origSize, size));
    }

    public static RLogical repInt(RLogical orig, int origSize, int size) {
        RArray.Names names = orig.names();
        return RLogical.RLogicalFactory.getFor(Rep.repValues(orig, origSize, size), null, Rep.repNames(names, origSize, size));
    }

    public static RInt repInt(RInt orig, int origSize, int size) {
        RArray.Names names = orig.names();
        return RInt.RIntFactory.getFor(Rep.repValues(orig, origSize, size), null, Rep.repNames(names, origSize, size));
    }

    public static RDouble repInt(RDouble orig, int origSize, int size) {
        RArray.Names names = orig.names();
        return RDouble.RDoubleFactory.getFor(Rep.repValues(orig, origSize, size), null, Rep.repNames(names, origSize, size));
    }

    public static RComplex repInt(RComplex orig, int origSize, int size) {
        RArray.Names names = orig.names();
        return RComplex.RComplexFactory.getFor(Rep.repValues(orig, origSize, size), null, Rep.repNames(names, origSize, size));
    }

    public static RString repInt(RString orig, int origSize, int size) {
        RArray.Names names = orig.names();
        return RString.RStringFactory.getFor(Rep.repValues(orig, origSize, size), null, Rep.repNames(names, origSize, size));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RAny genericRepInt(ASTNode ast, RAny arg0, RAny arg1) {
        RArray orig;
        int times = -1;
        if (arg1 instanceof RDouble) {
            RDouble da = (RDouble)arg1;
            Rep.checkScalar(da, ast);
            double d = da.getDouble(0);
            if (!RDouble.RDoubleUtils.isFinite(d) || d < 0.0 || !RDouble.RDoubleUtils.fitsRInt(d)) {
                throw RError.getInvalidTimes(ast);
            }
            times = (int)d;
        } else if (arg1 instanceof RInt) {
            RInt ia = (RInt)arg1;
            Rep.checkScalar(ia, ast);
            int i = ia.getInt(0);
            if (i < 0 || i == Integer.MIN_VALUE) {
                throw RError.getInvalidTimes(ast);
            }
            times = i;
        } else if (arg1 instanceof RLogical) {
            RLogical la = (RLogical)arg1;
            Rep.checkScalar(la, ast);
            int l = la.getLogical(0);
            if (l == 1) {
                return arg0;
            }
            if (l != 0) throw RError.getInvalidTimes(ast);
            times = 0;
        } else {
            Utils.nyi("unsupported times argument");
        }
        if (arg0 instanceof RInt) {
            orig = (RInt)arg0;
            int origSize = orig.size();
            return Rep.repInt((RInt)orig, origSize, origSize * times);
        }
        if (arg0 instanceof RDouble) {
            orig = (RDouble)arg0;
            int origSize = orig.size();
            return Rep.repInt((RDouble)orig, origSize, origSize * times);
        }
        if (arg0 instanceof RLogical) {
            orig = (RLogical)arg0;
            int origSize = orig.size();
            return Rep.repInt((RLogical)orig, origSize, origSize * times);
        }
        if (arg0 instanceof RString) {
            orig = (RString)arg0;
            int origSize = orig.size();
            return Rep.repInt((RString)orig, origSize, origSize * times);
        }
        if (arg0 instanceof RComplex) {
            orig = (RComplex)arg0;
            int origSize = orig.size();
            return Rep.repInt((RComplex)orig, origSize, origSize * times);
        }
        if (arg0 instanceof RRaw) {
            orig = (RRaw)arg0;
            int origSize = orig.size();
            return Rep.repInt((RRaw)orig, origSize, origSize * times);
        }
        Utils.nyi("unsupported base type for rep");
        return null;
    }

    public static RAny genericRepLengthOut(ASTNode ast, RAny argX, RAny argLengthOut) {
        int len;
        RInt ilengthOut = Convert.coerceToIntWarning(argLengthOut, ast);
        if (ilengthOut.size() == 1) {
            len = ilengthOut.getInt(0);
            if (len < 0) {
                if (len != Integer.MIN_VALUE) {
                    throw RError.getInvalidArgument(ast, "length.out");
                }
                return argX;
            }
        } else {
            return argX;
        }
        if (argX instanceof RDouble) {
            RDouble x = (RDouble)argX;
            return Rep.repInt(x, x.size(), len);
        }
        if (argX instanceof RInt) {
            RInt x = (RInt)argX;
            return Rep.repInt(x, x.size(), len);
        }
        if (argX instanceof RLogical) {
            RLogical x = (RLogical)argX;
            return Rep.repInt(x, x.size(), len);
        }
        if (argX instanceof RString) {
            RString x = (RString)argX;
            return Rep.repInt(x, x.size(), len);
        }
        if (argX instanceof RComplex) {
            RComplex x = (RComplex)argX;
            return Rep.repInt(x, x.size(), len);
        }
        throw Utils.nyi("unsupported base type for rep");
    }
}

