/*
 * Decompiled with CFR 0.152.
 */
package r.builtins;

import r.Utils;
import r.builtins.Builtin;
import r.builtins.CallFactory;
import r.data.RAny;
import r.data.RArray;
import r.data.RDouble;
import r.data.RInt;
import r.data.RLogical;
import r.data.RString;
import r.data.RSymbol;
import r.data.internal.View;
import r.nodes.ast.ASTNode;
import r.nodes.exec.RNode;
import r.runtime.Frame;

class Rev
extends CallFactory {
    static final CallFactory _ = new Rev("rev", new String[]{"x"}, new String[]{"x"});

    Rev(String name, String[] params, String[] required) {
        super(name, params, required);
    }

    @Override
    public RNode create(ASTNode call, RSymbol[] names, RNode[] exprs) {
        return new Builtin.Builtin1(call, names, exprs){

            @Override
            public RAny doBuiltIn(Frame frame, RAny arg) {
                return Rev.rev(arg);
            }
        };
    }

    public static RString rev(RString orig) {
        final int size = orig.size() - 1;
        return new View.RStringProxy<RString>(orig){

            @Override
            public String getString(int i) {
                return ((RString)this.orig).getString(size - i);
            }

            @Override
            public RAny.Attributes attributes() {
                return null;
            }
        };
    }

    public static RLogical rev(RLogical orig) {
        final int size = orig.size() - 1;
        return new View.RLogicalProxy<RLogical>(orig){

            @Override
            public int getLogical(int i) {
                return ((RLogical)this.orig).getLogical(size - i);
            }

            @Override
            public RAny.Attributes attributes() {
                return null;
            }
        };
    }

    public static RInt rev(RInt orig) {
        final int size = orig.size() - 1;
        return new View.RIntProxy<RInt>(orig){

            @Override
            public int getInt(int i) {
                return ((RInt)this.orig).getInt(size - i);
            }

            @Override
            public RAny.Attributes attributes() {
                return null;
            }
        };
    }

    public static RDouble rev(RDouble orig) {
        final int size = orig.size() - 1;
        return new View.RDoubleProxy<RDouble>(orig){

            @Override
            public double getDouble(int i) {
                return ((RDouble)this.orig).getDouble(size - i);
            }

            @Override
            public RAny.Attributes attributes() {
                return null;
            }
        };
    }

    public static RAny rev(RAny arg) {
        int size;
        if (!(arg instanceof RArray)) {
            throw Utils.nyi("unsupported type");
        }
        RArray a = (RArray)arg;
        RArray.Names names = a.names();
        if (names == null) {
            if (arg instanceof RDouble) {
                return Rev.rev((RDouble)arg);
            }
            if (arg instanceof RInt) {
                return Rev.rev((RInt)arg);
            }
            if (arg instanceof RLogical) {
                return Rev.rev((RLogical)arg);
            }
            if (arg instanceof RString) {
                return Rev.rev((RString)arg);
            }
            size = a.size();
        } else {
            RSymbol[] symbols = names.sequence();
            size = a.size();
            assert (Utils.check(size == symbols.length));
            RSymbol[] rsymbols = new RSymbol[size];
            for (int i = 0; i < size; ++i) {
                rsymbols[i] = symbols[size - i - 1];
            }
            names = RArray.Names.create(rsymbols);
        }
        RArray res = Utils.createArray(a, size, null, names, null);
        for (int i = 0; i < size; ++i) {
            res.set(i, a.getRef(size - 1 - i));
        }
        return res;
    }
}

