/*
 * Decompiled with CFR 0.152.
 */
package r.builtins;

import r.RContext;
import r.builtins.Builtin;
import r.builtins.CallFactory;
import r.builtins.internal.Random;
import r.data.RAny;
import r.data.RDouble;
import r.data.RSymbol;
import r.gnur.GNUR;
import r.nodes.ast.ASTNode;
import r.nodes.exec.RNode;
import r.runtime.Frame;

final class Rgamma
extends CallFactory {
    static final CallFactory _ = new Rgamma("rgamma", new String[]{"n", "shape", "rate", "scale"}, new String[]{"n", "shape"});
    static final double[] defaultScale = new double[]{1.0};

    private Rgamma(String name, String[] params, String[] required) {
        super(name, params, required);
    }

    @Override
    public RNode create(ASTNode call, RSymbol[] names, RNode[] exprs) {
        CallFactory.ArgumentInfo ia = this.check(call, names, exprs);
        final int nPosition = ia.position("n");
        final int shapePosition = ia.position("shape");
        final int ratePosition = ia.position("rate");
        final int scalePosition = ia.position("scale");
        return new Builtin(call, names, exprs){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public RAny doBuiltIn(Frame frame, RAny[] args) {
                double[] scale;
                int n = Random.parseNArgument(args[nPosition], this.ast);
                double[] shape = Random.parseNumericArgument(args[shapePosition], this.ast);
                if (scalePosition != -1) {
                    scale = Random.parseNumericArgument(args[scalePosition], this.ast);
                } else if (ratePosition != -1) {
                    double[] rate = Random.parseNumericArgument(args[ratePosition], this.ast);
                    for (int i = 0; i < rate.length; ++i) {
                        rate[i] = 1.0 / rate[i];
                    }
                    scale = rate;
                } else {
                    scale = defaultScale;
                }
                if (shape.length == 0 || scale.length == 0) {
                    return Random.allNAs(n, this.ast);
                }
                int[] rngKind = Random.updateNativeSeed(this.ast);
                try {
                    RDouble rDouble = RDouble.RDoubleFactory.getFor(Rgamma.rgamma(n, shape, scale, this.ast));
                    return rDouble;
                }
                finally {
                    Random.updateWorkspaceSeed(rngKind);
                }
            }
        };
    }

    public static double[] rgamma(int n, double[] shape, double[] scale, ASTNode ast) {
        double[] res = new double[n];
        boolean naProduced = GNUR.rgamma(res, n, shape, shape.length, scale, scale.length);
        if (naProduced) {
            RContext.warning(ast, "NAs produced");
        }
        return res;
    }
}

