/*
 * Decompiled with CFR 0.152.
 */
package r.builtins;

import r.RContext;
import r.builtins.Builtin;
import r.builtins.CallFactory;
import r.builtins.internal.Random;
import r.data.RAny;
import r.data.RDouble;
import r.data.RSymbol;
import r.gnur.GNUR;
import r.nodes.ast.ASTNode;
import r.nodes.exec.RNode;
import r.runtime.Frame;

public class Rlnorm
extends CallFactory {
    static final CallFactory _ = new Rlnorm("rlnorm", new String[]{"n", "meanlog", "sdlog"}, new String[]{"n"});
    static final double[] defaultMeanlog = new double[]{0.0};
    static final double[] defaultSdlog = new double[]{1.0};

    private Rlnorm(String name, String[] params, String[] required) {
        super(name, params, required);
    }

    @Override
    public RNode create(ASTNode call, RSymbol[] names, RNode[] exprs) {
        CallFactory.ArgumentInfo ia = this.check(call, names, exprs);
        if (names.length == 1) {
            return new Builtin.Builtin1(call, names, exprs){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public RAny doBuiltIn(Frame frame, RAny narg) {
                    int n = Random.parseNArgument(narg, this.ast);
                    int[] rngKind = Random.updateNativeSeed(this.ast);
                    try {
                        RDouble rDouble = RDouble.RDoubleFactory.getFor(Rlnorm.rlnormStd(n, this.ast));
                        return rDouble;
                    }
                    finally {
                        Random.updateWorkspaceSeed(rngKind);
                    }
                }
            };
        }
        final int nPosition = ia.position("n");
        final int meanlogPosition = ia.position("meanlog");
        final int sdlogPosition = ia.position("sdlog");
        return new Builtin(call, names, exprs){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public RAny doBuiltIn(Frame frame, RAny[] args) {
                double[] sdlog;
                int n = Random.parseNArgument(args[nPosition], this.ast);
                double[] meanlog = meanlogPosition == -1 ? defaultMeanlog : Random.parseNumericArgument(args[meanlogPosition], this.ast);
                double[] dArray = sdlog = sdlogPosition == -1 ? defaultSdlog : Random.parseNumericArgument(args[sdlogPosition], this.ast);
                if (meanlog.length == 0 || sdlog.length == 0) {
                    return Random.allNAs(n, this.ast);
                }
                int[] rngKind = Random.updateNativeSeed(this.ast);
                try {
                    RDouble rDouble = RDouble.RDoubleFactory.getFor(Rlnorm.rlnorm(n, meanlog, sdlog, this.ast));
                    return rDouble;
                }
                finally {
                    Random.updateWorkspaceSeed(rngKind);
                }
            }
        };
    }

    public static double[] rlnormStd(int n, ASTNode ast) {
        double[] res = new double[n];
        boolean naProduced = GNUR.rlnormStd(res, n);
        if (naProduced) {
            RContext.warning(ast, "NAs produced");
        }
        return res;
    }

    public static double[] rlnorm(int n, double[] meanlog, double[] sdlog, ASTNode ast) {
        double[] res = new double[n];
        boolean naProduced = GNUR.rlnorm(res, n, meanlog, meanlog.length, sdlog, sdlog.length);
        if (naProduced) {
            RContext.warning(ast, "NAs produced");
        }
        return res;
    }
}

