/*
 * Decompiled with CFR 0.152.
 */
package r.builtins;

import java.util.Arrays;
import r.RContext;
import r.builtins.Builtin;
import r.builtins.CallFactory;
import r.builtins.internal.Random;
import r.data.RAny;
import r.data.RDouble;
import r.data.RSymbol;
import r.gnur.GNUR;
import r.nodes.ast.ASTNode;
import r.nodes.exec.RNode;
import r.runtime.Frame;

final class Rnorm
extends CallFactory {
    static final CallFactory _ = new Rnorm("rnorm", new String[]{"n", "mean", "sd"}, new String[]{"n"});
    static final double[] defaultMean = new double[]{0.0};
    static final double[] defaultSD = new double[]{1.0};

    private Rnorm(String name, String[] params, String[] required) {
        super(name, params, required);
    }

    @Override
    public RNode create(ASTNode call, RSymbol[] names, RNode[] exprs) {
        CallFactory.ArgumentInfo ia = this.check(call, names, exprs);
        if (names.length == 1) {
            return new Builtin.Builtin1(call, names, exprs){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public RAny doBuiltIn(Frame frame, RAny narg) {
                    int n = Random.parseNArgument(narg, this.ast);
                    int[] rngKind = Random.updateNativeSeed(this.ast);
                    try {
                        RDouble rDouble = RDouble.RDoubleFactory.getFor(Rnorm.rnormStd(n, this.ast));
                        return rDouble;
                    }
                    finally {
                        Random.updateWorkspaceSeed(rngKind);
                    }
                }
            };
        }
        final int nPosition = ia.position("n");
        final int meanPosition = ia.position("mean");
        final int sdPosition = ia.position("sd");
        return new Builtin(call, names, exprs){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public RAny doBuiltIn(Frame frame, RAny[] args) {
                double[] sd;
                int n = Random.parseNArgument(args[nPosition], this.ast);
                double[] mean = meanPosition == -1 ? defaultMean : Random.parseNumericArgument(args[meanPosition], this.ast);
                double[] dArray = sd = sdPosition == -1 ? defaultSD : Random.parseNumericArgument(args[sdPosition], this.ast);
                if (mean.length == 0 || sd.length == 0) {
                    return Random.allNAs(n, this.ast);
                }
                int[] rngKind = Random.updateNativeSeed(this.ast);
                try {
                    RDouble rDouble = RDouble.RDoubleFactory.getFor(Rnorm.rnorm(n, mean, sd, this.ast));
                    return rDouble;
                }
                finally {
                    Random.updateWorkspaceSeed(rngKind);
                }
            }
        };
    }

    public static double[] rnormNaive(int n, double mu, double sigma, ASTNode ast) {
        double[] res = new double[n];
        boolean naProduced = false;
        for (int i = 0; i < n; ++i) {
            double d;
            res[i] = d = GNUR.rnorm(mu, sigma);
            naProduced = naProduced || RDouble.RDoubleUtils.isNAorNaN(d);
        }
        if (naProduced) {
            RContext.warning(ast, "NAs produced");
        }
        return res;
    }

    public static double[] rnormBatch(int n, double mu, double sigma, ASTNode ast) {
        double[] res = new double[n];
        boolean naProduced = GNUR.rnorm(res, n, mu, sigma);
        if (naProduced) {
            RContext.warning(ast, "NAs produced");
        }
        return res;
    }

    public static double[] rnormBatch2(int n, double mu, double sigma, ASTNode ast) {
        double[] res = new double[n];
        if (RDouble.RDoubleUtils.isNAorNaN(mu) || !RDouble.RDoubleUtils.isFinite(sigma) || sigma < 0.0) {
            Arrays.fill(res, Double.NaN);
            RContext.warning(ast, "NAs produced");
            return res;
        }
        if (sigma == 0.0 || !RDouble.RDoubleUtils.isFinite(mu)) {
            Arrays.fill(res, mu);
            return res;
        }
        boolean naProduced = GNUR.rnormNonChecking(res, n, mu, sigma);
        if (naProduced) {
            RContext.warning(ast, "NAs produced");
        }
        return res;
    }

    public static double[] rnormStd(int n, ASTNode ast) {
        double[] res = new double[n];
        boolean naProduced = GNUR.rnormStd(res, n);
        if (naProduced) {
            RContext.warning(ast, "NAs produced");
        }
        return res;
    }

    public static double[] rnorm(int n, double[] mean, double[] sd, ASTNode ast) {
        double[] res = new double[n];
        boolean naProduced = GNUR.rnorm(res, n, mean, mean.length, sd, sd.length);
        if (naProduced) {
            RContext.warning(ast, "NAs produced");
        }
        return res;
    }
}

