/*
 * Decompiled with CFR 0.152.
 */
package r.builtins;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Arrays;
import r.Utils;
import r.builtins.CallFactory;
import r.data.RAny;
import r.data.RArray;
import r.data.RComplex;
import r.data.RDouble;
import r.data.RSymbol;
import r.data.internal.ComplexImpl;
import r.nodes.ast.ASTNode;
import r.nodes.exec.Arithmetic;
import r.nodes.exec.Constant;
import r.nodes.exec.RNode;

final class Round
extends CallFactory {
    static final CallFactory _ = new Round("round", new String[]{"x", "digits"}, new String[]{"x"});
    static final int MAX_DIGITS = 37;
    public static final Arithmetic.ValueArithmetic ROUND_JAVA = new RoundJava();

    private Round(String name, String[] params, String[] required) {
        super(name, params, required);
    }

    @Override
    public RNode create(ASTNode call, RSymbol[] names, RNode[] exprs) {
        CallFactory.ArgumentInfo ia = this.check(call, names, exprs);
        int digitsPosition = ia.position("digits");
        if (digitsPosition == -1) {
            return new Arithmetic(call, exprs[0], new Constant(call, RDouble.BOXED_ZERO), ROUND_JAVA);
        }
        if (digitsPosition == 1) {
            return new Arithmetic(call, exprs[0], exprs[1], ROUND_JAVA);
        }
        return new Arithmetic(call, exprs[1], exprs[0], ROUND_JAVA);
    }

    public static double round(double x, double digits) {
        if (RDouble.RDoubleUtils.isNAorNaN(x) || RDouble.RDoubleUtils.isNAorNaN(digits)) {
            return x + digits;
        }
        if (digits == Double.NEGATIVE_INFINITY) {
            return 0.0;
        }
        if (digits == Double.POSITIVE_INFINITY) {
            return x;
        }
        int d = digits > 37.0 ? 37 : (int)Math.floor(digits + 0.5);
        if (!RDouble.RDoubleUtils.isFinite(x)) {
            return x;
        }
        return new BigDecimal(x).setScale(d, RoundingMode.HALF_EVEN).doubleValue();
    }

    public static void round(double[] x, double digits, double[] res) {
        int size = x.length;
        if (digits == Double.NEGATIVE_INFINITY) {
            Arrays.fill(res, 0.0);
            return;
        }
        if (digits == Double.POSITIVE_INFINITY) {
            if (res != x) {
                System.arraycopy(x, 0, res, 0, size);
            }
            return;
        }
        boolean naDigits = RDouble.RDoubleUtils.isNAorNaN(digits);
        int d = naDigits ? 0 : (digits > 37.0 ? 37 : (int)Math.floor(digits + 0.5));
        for (int i = 0; i < size; ++i) {
            double r = x[i];
            res[i] = naDigits || RDouble.RDoubleUtils.isNAorNaN(r) ? r + digits : new BigDecimal(r).setScale(d, RoundingMode.HALF_EVEN).doubleValue();
        }
    }

    public static final class RoundJava
    extends Arithmetic.ValueArithmetic {
        @Override
        public double opReal(ASTNode ast, double a, double b, double c, double d) {
            return Round.round(a, c);
        }

        @Override
        public double opImag(ASTNode ast, double a, double b, double c, double d) {
            return Round.round(b, c);
        }

        @Override
        public double op(ASTNode ast, double a, double b) {
            return Round.round(a, b);
        }

        @Override
        public int op(ASTNode ast, int a, int b) {
            Utils.nyi("unreachable");
            return -1;
        }

        @Override
        public void emitOverflowWarning(ASTNode ast) {
        }

        @Override
        public RComplex op(ASTNode ast, ComplexImpl xcomp, ComplexImpl ycomp, int size, int[] dimensions, RArray.Names names, RAny.Attributes attributes) {
            Utils.nyi();
            return null;
        }

        @Override
        public RComplex op(ASTNode ast, ComplexImpl xcomp, double c, double d, int size, int[] dimensions, RArray.Names names, RAny.Attributes attributes) {
            double[] x = xcomp.getContent();
            if (xcomp.isTemporary()) {
                Round.round(x, c, x);
                xcomp.setNames(names).setDimensions(dimensions).setAttributes(attributes);
                return xcomp;
            }
            double[] res = new double[x.length];
            Round.round(x, c, res);
            return RComplex.RComplexFactory.getFor(res, dimensions, names, attributes);
        }

        @Override
        public void op(ASTNode ast, double[] x, double[] y, double[] res, int size) {
            for (int i = 0; i < size; ++i) {
                double a = x[i];
                double b = y[i];
                double c = Round.round(a, b);
                if (RDouble.RDoubleUtils.arithIsNA(c)) {
                    if (!RDouble.RDoubleUtils.arithIsNA(a) && !RDouble.RDoubleUtils.arithIsNA(b)) continue;
                    res[i] = RDouble.NA;
                    continue;
                }
                res[i] = c;
            }
        }

        @Override
        public void op(ASTNode ast, double[] x, double y, double[] res, int size) {
            for (int i = 0; i < size; ++i) {
                double a = x[i];
                double c = Round.round(a, y);
                if (RDouble.RDoubleUtils.arithIsNA(c)) {
                    if (!RDouble.RDoubleUtils.arithIsNA(a) && !RDouble.RDoubleUtils.arithIsNA(y)) continue;
                    res[i] = RDouble.NA;
                    continue;
                }
                res[i] = c;
            }
        }

        @Override
        public void op(ASTNode ast, int[] x, int yfrom, int yto, int ystep, int[] res, int size) {
            Utils.nyi();
        }

        @Override
        public boolean returnsDouble() {
            return true;
        }
    }
}

