/*
 * Decompiled with CFR 0.152.
 */
package r.builtins;

import r.RContext;
import r.builtins.Builtin;
import r.builtins.CallFactory;
import r.builtins.internal.Random;
import r.data.RAny;
import r.data.RDouble;
import r.data.RSymbol;
import r.gnur.GNUR;
import r.nodes.ast.ASTNode;
import r.nodes.exec.RNode;
import r.runtime.Frame;

final class Runif
extends CallFactory {
    static final CallFactory _ = new Runif("runif", new String[]{"n", "min", "max"}, new String[]{"n"});
    static final double[] defaultMin = new double[]{0.0};
    static final double[] defaultMax = new double[]{1.0};

    private Runif(String name, String[] params, String[] required) {
        super(name, params, required);
    }

    @Override
    public RNode create(ASTNode call, RSymbol[] names, RNode[] exprs) {
        CallFactory.ArgumentInfo ia = this.check(call, names, exprs);
        if (names.length == 1) {
            return new Builtin.Builtin1(call, names, exprs){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public RAny doBuiltIn(Frame frame, RAny narg) {
                    int n = Random.parseNArgument(narg, this.ast);
                    int[] rngKind = Random.updateNativeSeed(this.ast);
                    try {
                        RDouble rDouble = RDouble.RDoubleFactory.getFor(Runif.runifStd(n, this.ast));
                        return rDouble;
                    }
                    finally {
                        Random.updateWorkspaceSeed(rngKind);
                    }
                }
            };
        }
        final int nPosition = ia.position("n");
        final int minPosition = ia.position("min");
        final int maxPosition = ia.position("max");
        return new Builtin(call, names, exprs){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public RAny doBuiltIn(Frame frame, RAny[] args) {
                double[] max;
                int n = Random.parseNArgument(args[nPosition], this.ast);
                double[] min = minPosition == -1 ? defaultMin : Random.parseNumericArgument(args[minPosition], this.ast);
                double[] dArray = max = maxPosition == -1 ? defaultMax : Random.parseNumericArgument(args[maxPosition], this.ast);
                if (min.length == 0 || max.length == 0) {
                    return Random.allNAs(n, this.ast);
                }
                int[] rngKind = Random.updateNativeSeed(this.ast);
                try {
                    RDouble rDouble = RDouble.RDoubleFactory.getFor(Runif.runif(n, min, max, this.ast));
                    return rDouble;
                }
                finally {
                    Random.updateWorkspaceSeed(rngKind);
                }
            }
        };
    }

    public static double[] runifStd(int n, ASTNode ast) {
        double[] res = new double[n];
        boolean naProduced = GNUR.runifStd(res, n);
        if (naProduced) {
            RContext.warning(ast, "NAs produced");
        }
        return res;
    }

    public static double[] runif(int n, double[] min, double[] max, ASTNode ast) {
        double[] res = new double[n];
        boolean naProduced = GNUR.runif(res, n, min, min.length, max, max.length);
        if (naProduced) {
            RContext.warning(ast, "NAs produced");
        }
        return res;
    }
}

