/*
 * Decompiled with CFR 0.152.
 */
package r.builtins;

import r.Convert;
import r.Utils;
import r.builtins.Builtin;
import r.builtins.CallFactory;
import r.builtins.LApply;
import r.data.RAny;
import r.data.RArray;
import r.data.RComplex;
import r.data.RDouble;
import r.data.RInt;
import r.data.RList;
import r.data.RLogical;
import r.data.RNull;
import r.data.RRaw;
import r.data.RString;
import r.data.RSymbol;
import r.data.internal.ScalarComplexImpl;
import r.data.internal.ScalarDoubleImpl;
import r.data.internal.ScalarIntImpl;
import r.data.internal.ScalarLogicalImpl;
import r.data.internal.ScalarStringImpl;
import r.nodes.ast.ASTNode;
import r.nodes.exec.FunctionCall;
import r.nodes.exec.RNode;
import r.runtime.Frame;
import r.runtime.SpecializationException;

final class SApply
extends CallFactory {
    static final CallFactory _ = new SApply("sapply", new String[]{"X", "FUN", "...", "simplify", "USE.NAMES"}, new String[]{"X", "FUN"});

    private SApply(String name, String[] params, String[] required) {
        super(name, params, required);
    }

    @Override
    public RNode create(ASTNode call, RSymbol[] names, RNode[] exprs) {
        CallFactory.ArgumentInfo ia = this.check(call, names, exprs);
        int cnArgs = 1 + names.length - 2;
        RSymbol[] cnNames = new RSymbol[cnArgs];
        RNode[] cnExprs = new RNode[cnArgs];
        cnNames[0] = null;
        LApply.ValueProvider firstArgProvider = new LApply.ValueProvider(call);
        cnExprs[0] = firstArgProvider;
        LApply.ValueProvider[] constantArgProviders = new LApply.ValueProvider[cnArgs];
        int j = 0;
        for (int i = 0; i < names.length; ++i) {
            if (ia.position("X") == i || ia.position("FUN") == i) continue;
            cnNames[1 + j] = names[i];
            LApply.ValueProvider vp = new LApply.ValueProvider(call);
            cnExprs[1 + j] = vp;
            constantArgProviders[j] = vp;
            ++j;
        }
        LApply.CallableProvider callableProvider = new LApply.CallableProvider(call, exprs[ia.position("FUN")]);
        FunctionCall callNode = FunctionCall.getFunctionCall(call, callableProvider, cnNames, cnExprs);
        return new Sapply(call, names, exprs, callNode, firstArgProvider, constantArgProviders, callableProvider, ia.position("X"), ia.position("FUN"));
    }

    public static class Sapply
    extends Builtin {
        LApply.ValueProvider firstArgProvider;
        LApply.ValueProvider[] constantArgProviders;
        LApply.CallableProvider callableProvider;
        @RNode.Child
        RNode callNode;
        final int xPosition;
        final int funPosition;

        public Sapply(ASTNode call, RSymbol[] names, RNode[] exprs, RNode callNode, LApply.ValueProvider firstArgProvider, LApply.ValueProvider[] constantArgProviders, LApply.CallableProvider callableProvider, int xPosition, int funPosition) {
            super(call, names, exprs);
            this.callableProvider = callableProvider;
            this.constantArgProviders = constantArgProviders;
            this.firstArgProvider = firstArgProvider;
            this.callNode = this.adoptChild(callNode);
            this.xPosition = xPosition;
            this.funPosition = funPosition;
        }

        @Override
        protected <N extends RNode> N replaceChild(RNode oldNode, N newNode) {
            assert (oldNode != null);
            assert (Utils.check(oldNode != this.firstArgProvider));
            assert (Utils.check(oldNode != this.callableProvider));
            if (this.callNode == oldNode) {
                this.callNode = newNode;
                return this.adoptInternal(newNode);
            }
            return super.replaceChild(oldNode, newNode);
        }

        public static RArray.Names extractNames(LApply.ArgIterator argIterator, boolean resultsHaveNames, RAny[] results, int size) {
            boolean argHasNames = argIterator.hasNames();
            if (!argHasNames) {
                if (!resultsHaveNames) {
                    return null;
                }
                RSymbol[] symbols = new RSymbol[size];
                for (int i = 0; i < size; ++i) {
                    RArray a = (RArray)results[i];
                    RArray.Names n = a.names();
                    symbols[i] = n != null ? n.sequence()[0] : RSymbol.EMPTY_SYMBOL;
                }
                return RArray.Names.create(symbols);
            }
            if (!resultsHaveNames) {
                return argIterator.names();
            }
            RString argNames = argIterator.stringNames();
            RSymbol[] symbols = new RSymbol[size];
            for (int i = 0; i < size; ++i) {
                String astr = argNames.getString(i);
                RArray a = (RArray)results[i];
                RArray.Names n = a.names();
                if (n != null) {
                    if (astr.length() == 0) {
                        symbols[i] = RSymbol.getSymbol(n.sequence()[0].name());
                        continue;
                    }
                    symbols[i] = RSymbol.getSymbol(astr + "." + n.sequence()[0].name());
                    continue;
                }
                symbols[i] = RSymbol.getSymbol(astr);
            }
            return RArray.Names.create(symbols);
        }

        public static RArray.Names mergeNames(RString argNames, RSymbol[] rnames, int size) {
            RSymbol[] symbols = new RSymbol[size];
            for (int i = 0; i < size; ++i) {
                String astr = argNames.getString(i);
                symbols[i] = astr.length() == 0 ? RSymbol.getSymbol(rnames[i].name()) : RSymbol.getSymbol(astr + "." + rnames[i].name());
            }
            return RArray.Names.create(symbols);
        }

        public static RAny generic(Frame frame, LApply.ArgIterator argIterator, Sapply sapply, RAny[] partialContent) {
            RAny v;
            int i;
            boolean hasRaw = false;
            boolean hasLogical = false;
            boolean hasInt = false;
            boolean hasDouble = false;
            boolean hasComplex = false;
            boolean hasString = false;
            boolean notAllScalarLists = false;
            boolean hasList = false;
            boolean hasMultipleSizes = false;
            boolean hasNames = false;
            int elementSize = -1;
            int xsize = argIterator.size();
            RAny[] content = partialContent == null ? new RAny[xsize] : partialContent;
            for (i = 0; i < xsize; ++i) {
                RArray.Names names;
                int vsize;
                if (partialContent == null || content[i] == null) {
                    argIterator.setNext();
                    content[i] = v = (RAny)sapply.callNode.execute(frame);
                } else {
                    v = content[i];
                }
                if (v instanceof RDouble) {
                    hasDouble = true;
                    notAllScalarLists = true;
                    vsize = ((RDouble)v).size();
                } else if (v instanceof RInt) {
                    hasInt = true;
                    notAllScalarLists = true;
                    vsize = ((RInt)v).size();
                } else if (v instanceof RLogical) {
                    hasLogical = true;
                    notAllScalarLists = true;
                    vsize = ((RLogical)v).size();
                } else if (v instanceof RList) {
                    hasList = true;
                    vsize = ((RList)v).size();
                    if (vsize != 1) {
                        notAllScalarLists = true;
                    }
                } else if (v instanceof RString) {
                    hasString = true;
                    notAllScalarLists = true;
                    vsize = ((RString)v).size();
                } else if (v instanceof RComplex) {
                    hasComplex = true;
                    notAllScalarLists = true;
                    vsize = ((RComplex)v).size();
                } else if (v instanceof RRaw) {
                    hasRaw = true;
                    notAllScalarLists = true;
                    vsize = ((RRaw)v).size();
                } else if (v instanceof RNull) {
                    hasList = true;
                    notAllScalarLists = true;
                    vsize = 0;
                } else {
                    throw Utils.nyi("unsupported type");
                }
                if (elementSize != -1) {
                    if (vsize != elementSize) {
                        hasMultipleSizes = true;
                    }
                } else {
                    elementSize = vsize;
                }
                if (hasNames || (names = ((RArray)v).names()) == null) continue;
                hasNames = true;
            }
            if (elementSize > 1 && !hasMultipleSizes) {
                int[] dimensions = new int[]{elementSize, xsize};
                int resSize = elementSize * xsize;
                if (hasList) {
                    RAny[] values = new RAny[resSize];
                    for (int i2 = 0; i2 < xsize; ++i2) {
                        RList v2 = content[i2].asList();
                        for (int j = 0; j < elementSize; ++j) {
                            values[i2 * elementSize + j] = v2.getRAny(j);
                        }
                    }
                    return RList.RListFactory.getFor(values, dimensions);
                }
                if (hasString) {
                    String[] values = new String[resSize];
                    for (int i3 = 0; i3 < xsize; ++i3) {
                        RString v3 = content[i3].asString();
                        for (int j = 0; j < elementSize; ++j) {
                            values[i3 * elementSize + j] = v3.getString(j);
                        }
                    }
                    return RString.RStringFactory.getFor(values, dimensions, null);
                }
                if (hasComplex) {
                    double[] values = new double[2 * resSize];
                    for (int i4 = 0; i4 < xsize; ++i4) {
                        RComplex v4 = content[i4].asComplex();
                        for (int j = 0; j < elementSize; ++j) {
                            int offset = 2 * (i4 * elementSize + j);
                            values[offset] = v4.getReal(j);
                            values[offset + 1] = v4.getImag(j);
                        }
                    }
                    return RComplex.RComplexFactory.getFor(values, dimensions, null);
                }
                if (hasDouble) {
                    double[] values = new double[resSize];
                    for (int i5 = 0; i5 < xsize; ++i5) {
                        RDouble v5 = content[i5].asDouble();
                        for (int j = 0; j < elementSize; ++j) {
                            values[i5 * elementSize + j] = v5.getDouble(j);
                        }
                    }
                    return RDouble.RDoubleFactory.getFor(values, dimensions, null);
                }
                if (hasInt) {
                    int[] values = new int[resSize];
                    for (int i6 = 0; i6 < xsize; ++i6) {
                        RInt v6 = content[i6].asInt();
                        for (int j = 0; j < elementSize; ++j) {
                            values[i6 * elementSize + j] = v6.getInt(j);
                        }
                    }
                    return RInt.RIntFactory.getFor(values, dimensions, null);
                }
                if (hasLogical) {
                    int[] values = new int[resSize];
                    for (int i7 = 0; i7 < xsize; ++i7) {
                        RLogical v7 = content[i7].asLogical();
                        for (int j = 0; j < elementSize; ++j) {
                            values[i7 * elementSize + j] = v7.getLogical(j);
                        }
                    }
                    return RLogical.RLogicalFactory.getFor(values, dimensions, null);
                }
                if (hasRaw) {
                    byte[] values = new byte[resSize];
                    for (int i8 = 0; i8 < xsize; ++i8) {
                        RRaw v8 = content[i8].asRaw();
                        for (int j = 0; j < elementSize; ++j) {
                            values[i8 * elementSize + j] = v8.getRaw(j);
                        }
                    }
                    return RRaw.RRawFactory.getFor(values, dimensions, null);
                }
                assert (Utils.check(false, "unreachable"));
            } else {
                RComplex cv;
                if (hasMultipleSizes) {
                    return RList.RListFactory.getFor(content, null, argIterator.names());
                }
                if (hasList) {
                    if (!notAllScalarLists) {
                        if (!hasNames) {
                            for (i = 0; i < xsize; ++i) {
                                v = (RList)content[i];
                                content[i] = v.getRAny(0);
                            }
                        } else {
                            RSymbol[] symbols = new RSymbol[xsize];
                            for (int i9 = 0; i9 < xsize; ++i9) {
                                RList v9 = (RList)content[i9];
                                content[i9] = v9.getRAny(0);
                                RArray.Names n = v9.names();
                                symbols[i9] = n != null ? n.sequence()[0] : RSymbol.EMPTY_SYMBOL;
                            }
                            if (!argIterator.hasNames()) {
                                return RList.RListFactory.getFor(content, null, RArray.Names.create(symbols));
                            }
                            return RList.RListFactory.getFor(content, null, Sapply.mergeNames(argIterator.stringNames(), symbols, xsize));
                        }
                    }
                    return RList.RListFactory.getFor(content, null, Sapply.extractNames(argIterator, hasNames, content, xsize));
                }
                if (hasString) {
                    String[] values = new String[xsize];
                    for (int i10 = 0; i10 < xsize; ++i10) {
                        RAny v10 = content[i10];
                        if (v10 instanceof RString) {
                            values[i10] = ((RString)v10).getString(0);
                            continue;
                        }
                        if (v10 instanceof RDouble) {
                            values[i10] = Convert.double2string(((RDouble)v10).getDouble(0));
                            continue;
                        }
                        if (v10 instanceof RInt) {
                            values[i10] = Convert.int2string(((RInt)v10).getInt(0));
                            continue;
                        }
                        if (v10 instanceof RLogical) {
                            values[i10] = Convert.logical2string(((RLogical)v10).getLogical(0));
                            continue;
                        }
                        if (v10 instanceof RComplex) {
                            cv = (RComplex)v10;
                            values[i10] = Convert.complex2string(cv.getReal(0), cv.getImag(0));
                            continue;
                        }
                        assert (Utils.check(v10 instanceof RRaw));
                        values[i10] = Convert.raw2string(((RRaw)v10).getRaw(0));
                    }
                    return RString.RStringFactory.getFor(values, null, Sapply.extractNames(argIterator, hasNames, content, xsize));
                }
                if (hasComplex) {
                    double[] values = new double[2 * xsize];
                    for (int i11 = 0; i11 < xsize; ++i11) {
                        RAny v11 = content[i11];
                        if (v11 instanceof RDouble) {
                            values[2 * i11] = ((RDouble)v11).getDouble(0);
                            continue;
                        }
                        if (v11 instanceof RInt) {
                            values[2 * i11] = Convert.int2double(((RInt)v11).getInt(0));
                            continue;
                        }
                        if (v11 instanceof RLogical) {
                            values[2 * i11] = Convert.logical2double(((RLogical)v11).getLogical(0));
                            continue;
                        }
                        if (v11 instanceof RComplex) {
                            cv = (RComplex)v11;
                            values[2 * i11] = cv.getReal(0);
                            values[2 * i11 + 1] = cv.getImag(0);
                            continue;
                        }
                        assert (Utils.check(v11 instanceof RRaw));
                        values[2 * i11] = Convert.raw2double(((RRaw)v11).getRaw(0));
                    }
                    return RComplex.RComplexFactory.getFor(values, null, Sapply.extractNames(argIterator, hasNames, content, xsize));
                }
                if (hasDouble) {
                    double[] values = new double[xsize];
                    for (int i12 = 0; i12 < xsize; ++i12) {
                        RAny v12 = content[i12];
                        if (v12 instanceof RDouble) {
                            values[i12] = ((RDouble)v12).getDouble(0);
                            continue;
                        }
                        if (v12 instanceof RInt) {
                            values[i12] = Convert.int2double(((RInt)v12).getInt(0));
                            continue;
                        }
                        if (v12 instanceof RLogical) {
                            values[i12] = Convert.logical2double(((RLogical)v12).getLogical(0));
                            continue;
                        }
                        assert (Utils.check(v12 instanceof RRaw));
                        values[i12] = Convert.raw2double(((RRaw)v12).getRaw(0));
                    }
                    return RDouble.RDoubleFactory.getFor(values, null, Sapply.extractNames(argIterator, hasNames, content, xsize));
                }
                if (hasInt) {
                    int[] values = new int[xsize];
                    for (int i13 = 0; i13 < xsize; ++i13) {
                        RAny v13 = content[i13];
                        if (v13 instanceof RInt) {
                            values[i13] = ((RInt)v13).getInt(0);
                            continue;
                        }
                        if (v13 instanceof RLogical) {
                            values[i13] = Convert.logical2int(((RLogical)v13).getLogical(0));
                            continue;
                        }
                        assert (Utils.check(v13 instanceof RRaw));
                        values[i13] = Convert.raw2int(((RRaw)v13).getRaw(0));
                    }
                    return RInt.RIntFactory.getFor(values, null, Sapply.extractNames(argIterator, hasNames, content, xsize));
                }
                if (hasLogical) {
                    int[] values = new int[xsize];
                    for (int i14 = 0; i14 < xsize; ++i14) {
                        RAny v14 = content[i14];
                        if (v14 instanceof RLogical) {
                            values[i14] = Convert.logical2int(((RLogical)v14).getLogical(0));
                            continue;
                        }
                        assert (Utils.check(v14 instanceof RRaw));
                        values[i14] = Convert.raw2logical(((RRaw)v14).getRaw(0));
                    }
                    return RLogical.RLogicalFactory.getFor(values, null, Sapply.extractNames(argIterator, hasNames, content, xsize));
                }
                if (hasRaw) {
                    byte[] values = new byte[xsize];
                    for (int i15 = 0; i15 < xsize; ++i15) {
                        RAny v15 = content[i15];
                        values[i15] = ((RRaw)v15).getRaw(0);
                    }
                    return RRaw.RRawFactory.getFor(values, null, Sapply.extractNames(argIterator, hasNames, content, xsize));
                }
            }
            return RList.EMPTY;
        }

        public static RAny[] unpackPartial(Object partial) {
            if (partial instanceof RAny[]) {
                return (RAny[])partial;
            }
            PartialResult p = (PartialResult)partial;
            int size = p.content.size();
            RAny[] res = new RAny[size];
            RArray content = p.content;
            int csize = p.contentSize;
            for (int i = 0; i < csize; ++i) {
                res[i] = content.boxedGet(i);
            }
            res[i] = p.lastValue;
            return res;
        }

        public Specialized createSpecialized(RAny resTemplate, LApply.ArgIterator argIterator) {
            if (resTemplate instanceof RDouble && ((RDouble)resTemplate).dimensions() == null) {
                ApplyFunc a = new ApplyFunc(){

                    @Override
                    public RAny apply(Frame frame, LApply.ArgIterator it, Sapply sapply) throws SpecializationException {
                        int xsize = it.size();
                        double[] content = new double[xsize];
                        for (int i = 0; i < xsize; ++i) {
                            it.setNext();
                            RAny v = (RAny)sapply.callNode.execute(frame);
                            if (!(v instanceof ScalarDoubleImpl)) {
                                throw new SpecializationException(new PartialResult(RDouble.RDoubleFactory.getFor(content), i, v));
                            }
                            content[i] = ((ScalarDoubleImpl)v).getDouble();
                        }
                        return RDouble.RDoubleFactory.getFor(content, null, it.names());
                    }
                };
                return new Specialized(this.ast, this.argNames, this.argExprs, this.callNode, this.firstArgProvider, this.constantArgProviders, this.callableProvider, this.xPosition, this.funPosition, argIterator, a, "<=RDouble>");
            }
            if (resTemplate instanceof RInt && ((RInt)resTemplate).dimensions() == null) {
                ApplyFunc a = new ApplyFunc(){

                    @Override
                    public RAny apply(Frame frame, LApply.ArgIterator it, Sapply sapply) throws SpecializationException {
                        int xsize = it.size();
                        int[] content = new int[xsize];
                        for (int i = 0; i < xsize; ++i) {
                            it.setNext();
                            RAny v = (RAny)sapply.callNode.execute(frame);
                            if (!(v instanceof ScalarIntImpl)) {
                                throw new SpecializationException(new PartialResult(RInt.RIntFactory.getFor(content), i, v));
                            }
                            content[i] = ((ScalarIntImpl)v).getInt();
                        }
                        return RInt.RIntFactory.getFor(content, null, it.names());
                    }
                };
                return new Specialized(this.ast, this.argNames, this.argExprs, this.callNode, this.firstArgProvider, this.constantArgProviders, this.callableProvider, this.xPosition, this.funPosition, argIterator, a, "<=RInt>");
            }
            if (resTemplate instanceof RLogical && ((RLogical)resTemplate).dimensions() == null) {
                ApplyFunc a = new ApplyFunc(){

                    @Override
                    public RAny apply(Frame frame, LApply.ArgIterator it, Sapply sapply) throws SpecializationException {
                        int xsize = it.size();
                        int[] content = new int[xsize];
                        for (int i = 0; i < xsize; ++i) {
                            it.setNext();
                            RAny v = (RAny)sapply.callNode.execute(frame);
                            if (!(v instanceof ScalarLogicalImpl)) {
                                throw new SpecializationException(new PartialResult(RLogical.RLogicalFactory.getFor(content), i, v));
                            }
                            content[i] = ((ScalarLogicalImpl)v).getLogical();
                        }
                        return RLogical.RLogicalFactory.getFor(content, null, it.names());
                    }
                };
                return new Specialized(this.ast, this.argNames, this.argExprs, this.callNode, this.firstArgProvider, this.constantArgProviders, this.callableProvider, this.xPosition, this.funPosition, argIterator, a, "<=RLogical>");
            }
            if (resTemplate instanceof RString && ((RString)resTemplate).dimensions() == null) {
                ApplyFunc a = new ApplyFunc(){

                    @Override
                    public RAny apply(Frame frame, LApply.ArgIterator it, Sapply sapply) throws SpecializationException {
                        int xsize = it.size();
                        String[] content = new String[xsize];
                        for (int i = 0; i < xsize; ++i) {
                            it.setNext();
                            RAny v = (RAny)sapply.callNode.execute(frame);
                            if (!(v instanceof ScalarStringImpl)) {
                                throw new SpecializationException(new PartialResult(RString.RStringFactory.getFor(content), i, v));
                            }
                            content[i] = ((ScalarStringImpl)v).getString();
                        }
                        return RString.RStringFactory.getFor(content, null, it.names());
                    }
                };
                return new Specialized(this.ast, this.argNames, this.argExprs, this.callNode, this.firstArgProvider, this.constantArgProviders, this.callableProvider, this.xPosition, this.funPosition, argIterator, a, "<=RString>");
            }
            if (resTemplate instanceof RComplex && ((RComplex)resTemplate).dimensions() == null) {
                ApplyFunc a = new ApplyFunc(){

                    @Override
                    public RAny apply(Frame frame, LApply.ArgIterator it, Sapply sapply) throws SpecializationException {
                        int xsize = it.size();
                        double[] content = new double[2 * xsize];
                        for (int i = 0; i < xsize; ++i) {
                            it.setNext();
                            RAny v = (RAny)sapply.callNode.execute(frame);
                            if (!(v instanceof ScalarComplexImpl)) {
                                throw new SpecializationException(new PartialResult(RComplex.RComplexFactory.getFor(content), i, v));
                            }
                            ScalarComplexImpl cv = (ScalarComplexImpl)v;
                            content[2 * i] = cv.getReal();
                            content[2 * i + 1] = cv.getImag();
                        }
                        return RComplex.RComplexFactory.getFor(content, null, it.names());
                    }
                };
                return new Specialized(this.ast, this.argNames, this.argExprs, this.callNode, this.firstArgProvider, this.constantArgProviders, this.callableProvider, this.xPosition, this.funPosition, argIterator, a, "<=RComplex>");
            }
            if (resTemplate instanceof RList && ((RList)resTemplate).dimensions() == null) {
                ApplyFunc a = new ApplyFunc(){

                    @Override
                    public RAny apply(Frame frame, LApply.ArgIterator it, Sapply sapply) throws SpecializationException {
                        int xsize = it.size();
                        RAny[] content = new RAny[xsize];
                        boolean returnsList = false;
                        for (int i = 0; i < xsize; ++i) {
                            RAny v;
                            it.setNext();
                            content[i] = v = (RAny)sapply.callNode.execute(frame);
                            if (returnsList) continue;
                            if (v instanceof RList || v instanceof RNull) {
                                returnsList = true;
                                continue;
                            }
                            assert (Utils.check(v instanceof RArray));
                            int size = ((RArray)v).size();
                            if (size == 1) continue;
                            returnsList = true;
                        }
                        if (!returnsList) {
                            throw new SpecializationException(content);
                        }
                        return RList.RListFactory.getFor(content, null, it.names());
                    }
                };
                return new Specialized(this.ast, this.argNames, this.argExprs, this.callNode, this.firstArgProvider, this.constantArgProviders, this.callableProvider, this.xPosition, this.funPosition, argIterator, a, "<=RList>");
            }
            if (resTemplate instanceof RRaw && ((RRaw)resTemplate).dimensions() == null) {
                ApplyFunc a = new ApplyFunc(){

                    @Override
                    public RAny apply(Frame frame, LApply.ArgIterator it, Sapply sapply) throws SpecializationException {
                        int xsize = it.size();
                        byte[] content = new byte[xsize];
                        for (int i = 0; i < xsize; ++i) {
                            it.setNext();
                            RAny v = (RAny)sapply.callNode.execute(frame);
                            if (!(v instanceof RRaw)) {
                                throw new SpecializationException(new PartialResult(RRaw.RRawFactory.getFor(content), i, v));
                            }
                            content[i] = ((RRaw)v).getRaw(0);
                        }
                        return RRaw.RRawFactory.getFor(content, null, it.names());
                    }
                };
                return new Specialized(this.ast, this.argNames, this.argExprs, this.callNode, this.firstArgProvider, this.constantArgProviders, this.callableProvider, this.xPosition, this.funPosition, argIterator, a, "<=RRaw>");
            }
            return null;
        }

        protected RAny processArgsAndReturnArgx(Frame frame, RAny[] args) {
            RAny argx = null;
            int j = 0;
            for (int i = 0; i < args.length; ++i) {
                if (i == this.xPosition) {
                    argx = args[i];
                    continue;
                }
                if (i == this.funPosition) {
                    this.callableProvider.matchAndSet(frame, args[i]);
                    continue;
                }
                this.constantArgProviders[j].setValue(args[i]);
                ++j;
            }
            return argx;
        }

        public RAny doApply(Frame frame, RAny[] args) {
            try {
                throw new SpecializationException((Object)null);
            }
            catch (SpecializationException e) {
                RAny argx = this.processArgsAndReturnArgx(frame, args);
                LApply.ArgIterator argIterator = LApply.ArgIterator.create(argx);
                try {
                    argIterator.reset(this.firstArgProvider, argx);
                }
                catch (SpecializationException e1) {
                    throw Utils.nyi("unsupported type");
                }
                RAny res = Sapply.generic(frame, argIterator, this, null);
                Specialized sn = this.createSpecialized(res, argIterator);
                if (sn != null) {
                    this.replace(sn, "install Specialized from Sapply");
                } else {
                    this.replace(this.createGeneric(argIterator), "install Generic from Sapply");
                }
                return res;
            }
        }

        @Override
        public RAny doBuiltIn(Frame frame, RAny[] args) {
            return this.doApply(frame, args);
        }

        public Specialized createGeneric(LApply.ArgIterator argIterator) {
            ApplyFunc a = new ApplyFunc(){

                @Override
                public RAny apply(Frame frame, LApply.ArgIterator it, Sapply sapply) throws SpecializationException {
                    return Sapply.generic(frame, it, sapply, null);
                }
            };
            return new Specialized(this.ast, this.argNames, this.argExprs, this.callNode, this.firstArgProvider, this.constantArgProviders, this.callableProvider, this.xPosition, this.funPosition, argIterator, a, "<Generic>");
        }

        static class Specialized
        extends Sapply {
            final ApplyFunc apply;
            final LApply.ArgIterator argIterator;
            final String dbg;

            public Specialized(ASTNode call, RSymbol[] names, RNode[] exprs, RNode callNode, LApply.ValueProvider firstArgProvider, LApply.ValueProvider[] constantArgProviders, LApply.CallableProvider callableProvider, int xPosition, int funPosition, LApply.ArgIterator argIterator, ApplyFunc apply, String dbg) {
                super(call, names, exprs, callNode, firstArgProvider, constantArgProviders, callableProvider, xPosition, funPosition);
                this.apply = apply;
                this.argIterator = argIterator;
                this.dbg = dbg;
            }

            @Override
            public RAny doApply(Frame frame, RAny[] args) {
                RAny argx = this.processArgsAndReturnArgx(frame, args);
                try {
                    this.argIterator.reset(this.firstArgProvider, argx);
                }
                catch (SpecializationException e) {
                    LApply.ArgIterator.Generic ai = new LApply.ArgIterator.Generic();
                    Specialized sn = new Specialized(this.ast, this.argNames, this.argExprs, this.callNode, this.firstArgProvider, this.constantArgProviders, this.callableProvider, this.xPosition, this.funPosition, ai, this.apply, this.dbg);
                    this.replace(sn, "install Specialized<Generic, ?> from Sapply.Specialized");
                    return sn.doApply(frame, args);
                }
                try {
                    return this.apply.apply(frame, this.argIterator, this);
                }
                catch (SpecializationException e) {
                    RAny[] partialContent = Specialized.unpackPartial(e.getResult());
                    Specialized sn = this.createGeneric(this.argIterator);
                    this.replace(sn, "install Specialized<?, Generic> from Sapply.Specialized");
                    return Specialized.generic(frame, this.argIterator, sn, partialContent);
                }
            }
        }

        static abstract class ApplyFunc {
            ApplyFunc() {
            }

            public abstract RAny apply(Frame var1, LApply.ArgIterator var2, Sapply var3) throws SpecializationException;
        }

        public class PartialResult {
            public final RArray content;
            public final int contentSize;
            public final RAny lastValue;

            PartialResult(RArray content, int contentSize, RAny lastValue) {
                this.content = content;
                this.contentSize = contentSize;
                this.lastValue = lastValue;
            }
        }
    }
}

