/*
 * Decompiled with CFR 0.152.
 */
package r.builtins;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import r.Console;
import r.Convert;
import r.RContext;
import r.Utils;
import r.builtins.Builtin;
import r.builtins.CallFactory;
import r.builtins.File;
import r.data.RAny;
import r.data.RComplex;
import r.data.RDouble;
import r.data.RInt;
import r.data.RList;
import r.data.RLogical;
import r.data.RNull;
import r.data.RRaw;
import r.data.RString;
import r.data.RSymbol;
import r.data.internal.Connection;
import r.data.internal.ConnectionMode;
import r.data.internal.DoubleImpl;
import r.errors.RError;
import r.nodes.ast.ASTNode;
import r.nodes.exec.RNode;
import r.runtime.Frame;

final class Scan
extends CallFactory {
    static final CallFactory _ = new Scan("scan", new String[]{"file", "what", "nmax", "quiet"}, new String[0]);
    private static Convert.ConversionStatus cs = new Convert.ConversionStatus();

    private Scan(String name, String[] params, String[] required) {
        super(name, params, required);
    }

    @Override
    public RNode create(ASTNode call, RSymbol[] names, RNode[] exprs) {
        CallFactory.ArgumentInfo ia = this.check(call, names, exprs);
        final ConnectionMode defaultMode = ConnectionMode.get("r");
        final int posWhat = ia.position("what");
        final int posNmax = ia.position("nmax");
        final int posQuiet = ia.position("quiet");
        final int posFile = ia.position("file");
        return new Builtin(call, names, exprs){

            @Override
            public RAny doBuiltIn(Frame frame, RAny[] args) {
                boolean quiet;
                DoubleImpl what = posWhat != -1 ? args[posWhat] : RDouble.EMPTY;
                int nmax = posNmax != -1 ? Scan.parseNMax(args[posNmax], this.ast) : -1;
                boolean bl = quiet = posQuiet != -1 ? Scan.parseQuiet(args[posQuiet]) : false;
                if (what instanceof RList) {
                    throw Utils.nyi("list not yet implemented");
                }
                if (what instanceof RNull) {
                    throw RError.getInvalidArgument(this.ast, "what");
                }
                Connection con = null;
                boolean wasOpen = false;
                if (posFile == -1) {
                    throw Utils.nyi("stdin, text");
                }
                RAny conArg = args[posFile];
                if (conArg instanceof RString) {
                    String description = File.getScalarString(conArg, this.ast, "file");
                    con = Connection.FileConnection.createOpened(description, defaultMode, this.ast);
                } else if (conArg instanceof RInt) {
                    RInt iarg = (RInt)conArg;
                    if (iarg.size() != 1) {
                        throw RError.getNotConnection(this.ast, "file");
                    }
                    int handle = iarg.getInt(0);
                    con = RContext.getConnection(handle);
                    Utils.check(con != null);
                    if (con.isOpen()) {
                        ConnectionMode mode = con.currentMode();
                        if (!mode.read()) {
                            throw RError.getCannotReadConnection(this.ast);
                        }
                        wasOpen = true;
                    } else {
                        con.open(defaultMode, this.ast);
                    }
                }
                try {
                    BufferedReader reader = con.reader(this.ast);
                    ArrayList<String> buf = new ArrayList<String>();
                    int nread = 0;
                    StringBuilder item = null;
                    int c = Scan.skip_whites(reader);
                    if (c != -1) {
                        while (true) {
                            if (Scan.is_white(c)) {
                                if (item != null) {
                                    buf.add(item.toString());
                                    ++nread;
                                }
                                if (nread == nmax) break;
                                c = Scan.skip_whites(reader);
                                item = null;
                                continue;
                            }
                            if (c == -1) {
                                if (item == null) break;
                                buf.add(item.toString());
                                ++nread;
                                break;
                            }
                            if (item == null) {
                                item = new StringBuilder();
                            }
                            item.append((char)c);
                            c = ((Reader)reader).read();
                        }
                    }
                    RAny res = Scan.scan(buf, this.ast, what);
                    if (!quiet) {
                        Console.println(String.format("Read %d item%s.", nread, nread == 1 ? "" : "s"));
                    }
                    RAny rAny = res;
                    return rAny;
                }
                catch (IOException e) {
                    throw RError.getGenericError(this.ast, e.toString());
                }
                finally {
                    if (!wasOpen) {
                        con.close(this.ast);
                    }
                }
            }
        };
    }

    public static int parseNMax(RAny arg, ASTNode ast) {
        RInt narg = Convert.coerceToIntWarning(arg, ast);
        if (narg.size() >= 1) {
            return narg.getInt(0);
        }
        return Integer.MIN_VALUE;
    }

    public static boolean parseQuiet(RAny arg) {
        RLogical narg = arg.asLogical();
        if (narg.size() >= 1) {
            return narg.getLogical(0) == 1;
        }
        return false;
    }

    public static RString scanString(ArrayList<String> src, ASTNode ast) {
        int size = src.size();
        String[] content = new String[size];
        return RString.RStringFactory.getFor(src.toArray(content));
    }

    public static RComplex scanComplex(ArrayList<String> src, ASTNode ast) {
        int size = src.size();
        Scan.cs.naIntroduced = false;
        double[] content = new double[2 * size];
        for (int i = 0; i < size; ++i) {
            String str = src.get(i);
            RComplex.Complex c = Convert.string2complex(str, cs);
            if (Scan.cs.naIntroduced) {
                if (str.equals("NA")) {
                    Scan.cs.naIntroduced = false;
                } else {
                    throw RError.getScanUnexpected(ast, "a complex", str);
                }
            }
            content[2 * i] = c.realValue();
            content[2 * i + 1] = c.imagValue();
        }
        return RComplex.RComplexFactory.getFor(content);
    }

    public static RDouble scanDouble(ArrayList<String> src, ASTNode ast) {
        int size = src.size();
        Scan.cs.naIntroduced = false;
        double[] content = new double[size];
        for (int i = 0; i < size; ++i) {
            String str = src.get(i);
            content[i] = Convert.string2double(str, cs);
            if (!Scan.cs.naIntroduced) continue;
            if (str.equals("NA")) {
                Scan.cs.naIntroduced = false;
                continue;
            }
            throw RError.getScanUnexpected(ast, "a real", str);
        }
        return RDouble.RDoubleFactory.getFor(content);
    }

    public static RInt scanInt(ArrayList<String> src, ASTNode ast) {
        int size = src.size();
        Scan.cs.naIntroduced = false;
        int[] content = new int[size];
        for (int i = 0; i < size; ++i) {
            String str = src.get(i);
            content[i] = Convert.string2int(str, cs);
            if (!Scan.cs.naIntroduced) continue;
            if (str.equals("NA")) {
                Scan.cs.naIntroduced = false;
                continue;
            }
            throw RError.getScanUnexpected(ast, "an integer", str);
        }
        return RInt.RIntFactory.getFor(content);
    }

    public static RLogical scanLogical(ArrayList<String> src, ASTNode ast) {
        int size = src.size();
        Scan.cs.naIntroduced = false;
        int[] content = new int[size];
        for (int i = 0; i < size; ++i) {
            String str = src.get(i);
            content[i] = Convert.string2logical(str, cs);
            if (!Scan.cs.naIntroduced) continue;
            if (str.equals("NA")) {
                Scan.cs.naIntroduced = false;
                continue;
            }
            throw RError.getScanUnexpected(ast, "a logical", str);
        }
        return RLogical.RLogicalFactory.getFor(content);
    }

    static int hexDigit(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'a' && c <= 'f') {
            return c - 97 + 10;
        }
        if (c >= 'A' && c <= 'F') {
            return c - 65 + 10;
        }
        return -1;
    }

    public static RRaw scanRaw(ArrayList<String> src, ASTNode ast) {
        int size = src.size();
        Scan.cs.naIntroduced = false;
        Scan.cs.outOfRange = false;
        byte[] content = new byte[size];
        for (int i = 0; i < size; ++i) {
            String str = src.get(i);
            if (str.equals("NA")) continue;
            int slen = str.length();
            if (slen == 2) {
                int a = Scan.hexDigit(str.charAt(0));
                int b = Scan.hexDigit(str.charAt(1));
                if (a != -1 && b != -1) {
                    content[i] = (byte)(a * 16 + b);
                    continue;
                }
            }
            if (slen == 1 && Scan.hexDigit(str.charAt(0)) != -1) continue;
            throw RError.getScanUnexpected(ast, "a raw", str);
        }
        return RRaw.RRawFactory.getFor(content);
    }

    public static RAny scan(ArrayList<String> src, ASTNode ast, RAny what) {
        if (what instanceof RString) {
            return Scan.scanString(src, ast);
        }
        if (what instanceof RDouble) {
            return Scan.scanDouble(src, ast);
        }
        if (what instanceof RInt) {
            return Scan.scanInt(src, ast);
        }
        if (what instanceof RLogical) {
            return Scan.scanLogical(src, ast);
        }
        if (what instanceof RRaw) {
            return Scan.scanRaw(src, ast);
        }
        if (what instanceof RComplex) {
            return Scan.scanComplex(src, ast);
        }
        throw RError.getInvalidArgument(ast, "what");
    }

    public static boolean is_white(int c) {
        return c == 13 || c == 10 || c == 9 || c == 32;
    }

    public static int skip_whites(Reader reader) throws IOException {
        int c;
        while (Scan.is_white(c = reader.read())) {
        }
        return c;
    }
}

