/*
 * Decompiled with CFR 0.152.
 */
package r.builtins;

import r.Utils;
import r.builtins.Builtin;
import r.builtins.C;
import r.builtins.CallFactory;
import r.builtins.Colon;
import r.builtins.Rep;
import r.data.RAny;
import r.data.RArray;
import r.data.RDouble;
import r.data.RInt;
import r.data.RLogical;
import r.data.RSymbol;
import r.errors.RError;
import r.nodes.ast.ASTNode;
import r.nodes.exec.RNode;
import r.runtime.Frame;

final class Seq
extends CallFactory {
    static final CallFactory _ = new Seq("seq", new String[]{"from", "to", "by", "length.out", "along.with", "..."}, new String[0]);

    Seq(String name, String[] params, String[] required) {
        super(name, params, required);
    }

    @Override
    public RNode create(ASTNode call, RSymbol[] names, RNode[] exprs) {
        if (exprs.length == 0) {
            return new Builtin.Builtin0(call, names, exprs){

                @Override
                public RAny doBuiltIn(Frame frame) {
                    return RInt.RIntFactory.getScalar(1);
                }
            };
        }
        CallFactory.ArgumentInfo ia = this.check(call, names, exprs);
        final int posFrom = ia.position("from");
        final int posTo = ia.position("to");
        final int posBy = ia.position("by");
        final int posLengthOut = ia.position("length.out");
        if (posFrom != -1 && posTo != -1) {
            if (exprs.length == 2) {
                if (posFrom == 0) {
                    return Colon._.create(call, names, exprs);
                }
                RSymbol[] newNames = new RSymbol[]{names[1], names[0]};
                RNode[] newExprs = new RNode[]{exprs[1], exprs[0]};
                return Colon._.create(call, newNames, newExprs);
            }
            if (exprs.length == 3) {
                if (posBy != -1) {
                    return new Builtin(call, names, exprs){

                        @Override
                        public RAny doBuiltIn(Frame frame, RAny[] args) {
                            RAny argfrom = args[posFrom];
                            RAny argto = args[posTo];
                            RAny argby = args[posBy];
                            if (!(argfrom instanceof RArray && argto instanceof RArray && argby instanceof RArray)) {
                                Utils.nyi("unsupported argument types");
                            }
                            RArray afrom = (RArray)argfrom;
                            RArray ato = (RArray)argto;
                            RArray aby = (RArray)argby;
                            Colon.checkScalar(afrom, this.ast);
                            Colon.checkScalar(ato, this.ast);
                            Colon.checkScalar(aby, this.ast);
                            double from = afrom.asDouble().getDouble(0);
                            double to = ato.asDouble().getDouble(0);
                            double by = aby.asDouble().getDouble(0);
                            double del = to - from;
                            if (del == 0.0 && to == 0.0) {
                                return argto;
                            }
                            double n = del / by;
                            if (!RDouble.RDoubleUtils.isFinite(n)) {
                                if (by == 0.0 && del == 0.0) {
                                    return argfrom;
                                }
                                throw RError.getInvalidTFB(this.ast);
                            }
                            if (n < 0.0) {
                                throw RError.getWrongSignInBy(this.ast);
                            }
                            if (n > 2.147483647E9) {
                                throw RError.getByTooSmall(this.ast);
                            }
                            double dd = Math.abs(del) / Math.max(Math.abs(to), Math.abs(from));
                            if (dd < 100.0 * RDouble.EPSILON) {
                                return argfrom;
                            }
                            if (ato instanceof RInt && afrom instanceof RInt && aby instanceof RInt) {
                                return RInt.RIntFactory.forSequence((int)from, (int)(from + (double)((int)n) * by), (int)by);
                            }
                            int in = (int)(n + 1.0E-10);
                            double[] content = new double[in + 1];
                            if (by > 0.0) {
                                for (int i = 0; i <= in; ++i) {
                                    double x = from + (double)i * by;
                                    content[i] = x <= to ? x : to;
                                }
                            } else {
                                for (int i = 0; i <= in; ++i) {
                                    double x = from + (double)i * by;
                                    content[i] = x >= to ? x : to;
                                }
                            }
                            return RDouble.RDoubleFactory.getFor(content);
                        }
                    };
                }
                if (posLengthOut != -1) {
                    return new Builtin(call, names, exprs){

                        @Override
                        public RAny doBuiltIn(Frame frame, RAny[] args) {
                            RAny argfrom = args[posFrom];
                            RAny argto = args[posTo];
                            RAny arglengthOut = args[posLengthOut];
                            if (!(argfrom instanceof RArray && argto instanceof RArray && arglengthOut instanceof RArray)) {
                                throw Utils.nyi("unsupported argument types");
                            }
                            RArray afrom = (RArray)argfrom;
                            RArray ato = (RArray)argto;
                            RArray alengthOut = (RArray)arglengthOut;
                            Colon.checkScalar(afrom, this.ast);
                            Colon.checkScalar(ato, this.ast);
                            Colon.checkScalar(alengthOut, this.ast);
                            double from = afrom.asDouble().getDouble(0);
                            double to = ato.asDouble().getDouble(0);
                            double lengthOut = alengthOut.asDouble().getDouble(0);
                            if (!RDouble.RDoubleUtils.isFinite(lengthOut) || lengthOut < 0.0) {
                                throw RError.getLengthNonnegative(this.ast);
                            }
                            if (lengthOut == 0.0) {
                                return RInt.EMPTY;
                            }
                            if (lengthOut == 1.0) {
                                return argfrom;
                            }
                            if (lengthOut == 2.0) {
                                return C.genericCombine(null, new RAny[]{argfrom, argto});
                            }
                            if (from == to) {
                                return Rep.genericRepInt(this.ast, argfrom, arglengthOut);
                            }
                            double by = (to - from) / (lengthOut - 1.0);
                            int len = (int)lengthOut;
                            RAny[] vec = new RAny[len];
                            vec[0] = argfrom;
                            vec[vec.length - 1] = argto;
                            for (int i = 1; i <= len - 2; ++i) {
                                vec[i] = RDouble.RDoubleFactory.getScalar(from + (double)i * by);
                            }
                            return C.genericCombine(null, vec);
                        }
                    };
                }
            }
        } else if (exprs.length == 1) {
            if (ia.provided("along.with")) {
                return new Builtin.Builtin1(call, names, exprs){

                    @Override
                    public RAny doBuiltIn(Frame frame, RAny arg) {
                        if (!(arg instanceof RArray)) {
                            throw Utils.nyi();
                        }
                        RArray aarg = (RArray)arg;
                        int len = aarg.size();
                        if (len == 0) {
                            return RInt.EMPTY;
                        }
                        return Colon.create(1, len);
                    }
                };
            }
            if (ia.provided("from")) {
                return new Builtin.Builtin1(call, names, exprs){

                    @Override
                    public RAny doBuiltIn(Frame frame, RAny arg) {
                        if (arg instanceof RArray) {
                            RArray aarg = (RArray)arg;
                            int len = aarg.size();
                            if (len == 0) {
                                return RInt.EMPTY;
                            }
                            if (len == 1) {
                                if (aarg instanceof RInt) {
                                    int ia = ((RInt)aarg).getInt(0);
                                    Colon.checkNA(ia, this.ast);
                                    return Colon.create(1, ia);
                                }
                                if (aarg instanceof RDouble) {
                                    double da = ((RDouble)aarg).getDouble(0);
                                    Colon.checkNAandNaN(da, this.ast);
                                    if (RDouble.RDoubleUtils.fitsRInt(da)) {
                                        return Colon.create(1, (int)da);
                                    }
                                    return Colon.create(1.0, da);
                                }
                            }
                            return Colon.create(1, len);
                        }
                        throw Utils.nyi();
                    }
                };
            }
            if (ia.provided("length.out")) {
                return new Builtin.Builtin1(call, names, exprs){

                    @Override
                    public RAny doBuiltIn(Frame frame, RAny arg) {
                        if (arg instanceof RInt) {
                            RInt lint = (RInt)arg;
                            Colon.checkScalar(lint, this.ast);
                            int li = lint.getInt(0);
                            if (li == 0) {
                                return RInt.EMPTY;
                            }
                            if (li < 0) {
                                throw RError.getLengthNonnegative(this.ast);
                            }
                            Colon.checkNA(li, this.ast);
                            return Colon.create(1, li);
                        }
                        if (arg instanceof RDouble) {
                            RDouble ldbl = (RDouble)arg;
                            Colon.checkScalar(ldbl, this.ast);
                            double ld = ldbl.getDouble(0);
                            if (RDouble.RDoubleUtils.isNAorNaN(ld) || ld < 0.0) {
                                throw RError.getLengthNonnegative(this.ast);
                            }
                            Colon.checkNAandNaN(ld, this.ast);
                            if (ld == 0.0) {
                                return RInt.EMPTY;
                            }
                            double id = Math.ceil(ld);
                            if (RDouble.RDoubleUtils.fitsRInt(id)) {
                                return Colon.create(1, (int)id);
                            }
                            return Colon.create(1.0, ld);
                        }
                        if (arg instanceof RLogical) {
                            RLogical llog = (RLogical)arg;
                            Colon.checkScalar(llog, this.ast);
                            int ll = llog.getLogical(0);
                            if (ll == 1) {
                                return RInt.BOXED_ONE;
                            }
                            if (ll == 0) {
                                return RInt.EMPTY;
                            }
                            throw RError.getLengthNonnegative(this.ast);
                        }
                        return RInt.RIntFactory.getScalar(1);
                    }
                };
            }
        }
        throw Utils.nyi("General case for seq to be implemented (in R?)");
    }
}

