/*
 * Decompiled with CFR 0.152.
 */
package r.builtins;

import java.io.File;
import r.builtins.Builtin;
import r.builtins.CallFactory;
import r.data.RAny;
import r.data.RString;
import r.data.RSymbol;
import r.errors.RError;
import r.nodes.ast.ASTNode;
import r.nodes.exec.RNode;
import r.runtime.Frame;

public class Setwd
extends CallFactory {
    static final CallFactory _ = new Setwd("setwd", new String[]{"dir"}, null);

    private Setwd(String name, String[] params, String[] required) {
        super(name, params, required);
    }

    @Override
    public RNode create(ASTNode call, RSymbol[] names, RNode[] exprs) {
        CallFactory.ArgumentInfo ai = this.check(call, names, exprs);
        final int dirPos = ai.position("dir");
        return new Builtin(call, names, exprs){

            @Override
            public RAny doBuiltIn(Frame frame, RAny[] args) {
                String dir = Setwd.parseDir(args[dirPos], this.ast);
                String res = Setwd.perform(dir, this.ast);
                return RString.RStringFactory.getScalar(res);
            }
        };
    }

    static String perform(String dir, ASTNode ast) {
        String old = System.getProperty("user.dir");
        File f = new File(dir);
        if (!f.isDirectory()) {
            throw RError.getCannotChangeDirectory(ast);
        }
        System.setProperty("user.dir", dir);
        return old;
    }

    static String parseDir(RAny arg, ASTNode ast) {
        RString rs;
        if (arg instanceof RString && (rs = (RString)arg).size() >= 1) {
            String s = rs.getString(0);
            if (s == RString.NA) {
                throw RError.getMissingInvalid(ast);
            }
            return s;
        }
        throw RError.getCharacterExpected(ast);
    }
}

