/*
 * Decompiled with CFR 0.152.
 */
package r.builtins;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import r.Utils;
import r.builtins.Builtin;
import r.builtins.CallFactory;
import r.builtins.Order;
import r.data.RAny;
import r.data.RArray;
import r.data.RComplex;
import r.data.RDouble;
import r.data.RInt;
import r.data.RList;
import r.data.RLogical;
import r.data.RNull;
import r.data.RRaw;
import r.data.RString;
import r.data.RSymbol;
import r.data.internal.ListImpl;
import r.errors.RError;
import r.nodes.ast.ASTNode;
import r.nodes.exec.RNode;
import r.runtime.Frame;

final class Sort
extends CallFactory {
    static final CallFactory _ = new Sort("sort", new String[]{"x", "partial", "na.last", "decreasing", "method", "index.return"}, new String[]{"x"});
    static final CallFactory.ArgumentMatch methodMatch = new CallFactory.ArgumentMatch(new String[]{"shell", "quick"});
    private static final RArray.Names resultNames = RArray.Names.create(new RSymbol[]{RSymbol.getSymbol("x"), RSymbol.getSymbol("ix")});

    private Sort(String name, String[] params, String[] required) {
        super(name, params, required);
    }

    public static boolean parseMethod(RAny arg, ASTNode ast) {
        int m = methodMatch.match(arg, ast, "method");
        return m == 1;
    }

    public static boolean parseIndexReturn(RAny arg, ASTNode ast) {
        if (!(arg instanceof RLogical || arg instanceof RInt || arg instanceof RDouble || arg instanceof RComplex)) {
            throw RError.getInvalidArgument(ast, "index.return");
        }
        RLogical a = arg.asLogical();
        int size = a.size();
        if (size >= 1) {
            int l = a.getLogical(0);
            if (l == 1) {
                return true;
            }
            if (l == 0) {
                return false;
            }
        }
        throw RError.getInvalidArgument(ast, "index.return");
    }

    public static RInt parsePartial(RAny arg, ASTNode ast) {
        if (arg instanceof RNull) {
            return null;
        }
        if (!(arg instanceof RDouble || arg instanceof RInt || arg instanceof RLogical || arg instanceof RRaw)) {
            throw RError.getNotNumericVector(ast);
        }
        return arg.asInt();
    }

    @Override
    public RNode create(ASTNode call, RSymbol[] names, RNode[] exprs) {
        CallFactory.ArgumentInfo ia = this.check(call, names, exprs);
        final int xPosition = ia.position("x");
        final int partialPosition = ia.position("partial");
        final int naLastPosition = ia.position("na.last");
        final int decreasingPosition = ia.position("decreasing");
        final int methodPosition = ia.position("method");
        final int indexReturnPosition = ia.position("index.return");
        return new Builtin(call, names, exprs){

            @Override
            public RAny doBuiltIn(Frame frame, RAny[] params) {
                boolean indexReturn;
                RAny xarg = params[xPosition];
                if (!(xarg instanceof RArray)) {
                    throw RError.getMustBeAtomic(this.ast, "x");
                }
                RArray x = (RArray)xarg;
                RInt partial = partialPosition == -1 ? null : Sort.parsePartial(params[partialPosition], this.ast);
                int naLast = naLastPosition == -1 ? Integer.MIN_VALUE : Order.parseNALast(params[naLastPosition], this.ast);
                boolean decreasing = decreasingPosition == -1 ? false : Order.parseDecreasing(params[decreasingPosition], this.ast);
                boolean quickSort = methodPosition == -1 ? false : Sort.parseMethod(params[methodPosition], this.ast);
                boolean bl = indexReturn = indexReturnPosition == -1 ? false : Sort.parseIndexReturn(params[indexReturnPosition], this.ast);
                if (partial != null) {
                    if (decreasing || methodPosition != -1 || indexReturn) {
                        throw RError.getUnsupportedPartial(this.ast);
                    }
                    Utils.nyi("partial sorting not implemented");
                    return null;
                }
                if (indexReturn && naLast != Integer.MIN_VALUE) {
                    throw RError.getIndexReturnRemoveNA(this.ast);
                }
                if (x.names() == null && !indexReturn && !decreasing) {
                    if (x instanceof RDouble) {
                        double[] a = RDouble.RDoubleUtils.copyAsDoubleArray((RDouble)x);
                        Arrays.sort(a);
                        a = Sort.fixNAs(a, naLast);
                        return RDouble.RDoubleFactory.getFor(a);
                    }
                    if (x instanceof RInt) {
                        int[] a = RInt.RIntUtils.copyAsIntArray((RInt)x);
                        Arrays.sort(a);
                        a = Sort.fixNAs(a, naLast);
                        return RInt.RIntFactory.getFor(a);
                    }
                }
                return Sort.sort(x, naLast, decreasing, indexReturn);
            }
        };
    }

    public static RArray sort(RArray x, int naLast, boolean decreasing, boolean indexReturn) {
        if (x instanceof RDouble) {
            return Sort.sort((RDouble)x, naLast, decreasing, indexReturn);
        }
        if (x instanceof RInt) {
            return Sort.sort((RInt)x, naLast, decreasing, indexReturn);
        }
        if (x instanceof RString) {
            return Sort.sort((RString)x, naLast, decreasing, indexReturn);
        }
        if (x instanceof RLogical) {
            return Sort.sort((RLogical)x, naLast, decreasing, indexReturn);
        }
        Utils.nyi("unsupported type for sorting");
        return null;
    }

    public static RArray sort(RDouble x, int naLast, final boolean decreasing, boolean indexReturn) {
        int size = x.size();
        Integer[] order = new Integer[size];
        ArrayList<Integer> naorder = new ArrayList<Integer>();
        int[] naRemoveIndex = indexReturn ? new int[size] : null;
        int nnas = 0;
        int oi = 0;
        boolean naRemove = naLast == Integer.MIN_VALUE;
        for (int i = 0; i < size; ++i) {
            double d;
            if (naRemoveIndex != null) {
                naRemoveIndex[i] = i - nnas;
            }
            if (RDouble.RDoubleUtils.isNAorNaN(d = x.getDouble(i))) {
                if (!naRemove) {
                    naorder.add(i);
                    continue;
                }
                ++nnas;
                continue;
            }
            order[oi++] = i;
        }
        final Order.DoubleComparator cmp = new Order.DoubleComparator(x);
        Comparator<Integer> mainComparator = new Comparator<Integer>(){

            @Override
            public int compare(Integer o1, Integer o2) {
                int res = cmp.cmp(o1, o2);
                return !decreasing ? res : -res;
            }
        };
        Arrays.sort(order, 0, oi, mainComparator);
        return Sort.buildSortResults(x, order, oi, naorder, naLast, naRemoveIndex);
    }

    public static RArray sort(RInt x, int naLast, final boolean decreasing, boolean indexReturn) {
        int size = x.size();
        Integer[] order = new Integer[size];
        ArrayList<Integer> naorder = new ArrayList<Integer>();
        int[] naRemoveIndex = indexReturn ? new int[size] : null;
        int nnas = 0;
        int oi = 0;
        boolean naRemove = naLast == Integer.MIN_VALUE;
        for (int i = 0; i < size; ++i) {
            int v;
            if (naRemoveIndex != null) {
                naRemoveIndex[i] = i - nnas;
            }
            if ((v = x.getInt(i)) == Integer.MIN_VALUE) {
                if (!naRemove) {
                    naorder.add(i);
                    continue;
                }
                ++nnas;
                continue;
            }
            order[oi++] = i;
        }
        final Order.IntComparator cmp = new Order.IntComparator(x);
        Comparator<Integer> mainComparator = new Comparator<Integer>(){

            @Override
            public int compare(Integer o1, Integer o2) {
                int res = cmp.cmp(o1, o2);
                return !decreasing ? res : -res;
            }
        };
        Arrays.sort(order, 0, oi, mainComparator);
        return Sort.buildSortResults(x, order, oi, naorder, naLast, naRemoveIndex);
    }

    public static RArray sort(RString x, int naLast, final boolean decreasing, boolean indexReturn) {
        int size = x.size();
        Integer[] order = new Integer[size];
        ArrayList<Integer> naorder = new ArrayList<Integer>();
        int[] naRemoveIndex = indexReturn ? new int[size] : null;
        int nnas = 0;
        int oi = 0;
        boolean naRemove = naLast == Integer.MIN_VALUE;
        for (int i = 0; i < size; ++i) {
            String v;
            if (naRemoveIndex != null) {
                naRemoveIndex[i] = i - nnas;
            }
            if ((v = x.getString(i)) == RString.NA) {
                if (!naRemove) {
                    naorder.add(i);
                    continue;
                }
                ++nnas;
                continue;
            }
            order[oi++] = i;
        }
        final Order.StringComparator cmp = new Order.StringComparator(x);
        Comparator<Integer> mainComparator = new Comparator<Integer>(){

            @Override
            public int compare(Integer o1, Integer o2) {
                int res = cmp.cmp(o1, o2);
                return !decreasing ? res : -res;
            }
        };
        Arrays.sort(order, 0, oi, mainComparator);
        return Sort.buildSortResults(x, order, oi, naorder, naLast, naRemoveIndex);
    }

    public static RArray sort(RLogical x, int naLast, final boolean decreasing, boolean indexReturn) {
        int size = x.size();
        Integer[] order = new Integer[size];
        ArrayList<Integer> naorder = new ArrayList<Integer>();
        int[] naRemoveIndex = indexReturn ? new int[size] : null;
        int nnas = 0;
        int oi = 0;
        boolean naRemove = naLast == Integer.MIN_VALUE;
        for (int i = 0; i < size; ++i) {
            int v;
            if (naRemoveIndex != null) {
                naRemoveIndex[i] = i - nnas;
            }
            if ((v = x.getLogical(i)) == Integer.MIN_VALUE) {
                if (!naRemove) {
                    naorder.add(i);
                    continue;
                }
                ++nnas;
                continue;
            }
            order[oi++] = i;
        }
        final Order.LogicalComparator cmp = new Order.LogicalComparator(x);
        Comparator<Integer> mainComparator = new Comparator<Integer>(){

            @Override
            public int compare(Integer o1, Integer o2) {
                int res = cmp.cmp(o1, o2);
                return !decreasing ? res : -res;
            }
        };
        Arrays.sort(order, 0, oi, mainComparator);
        return Sort.buildSortResults(x, order, oi, naorder, naLast, naRemoveIndex);
    }

    public static RArray buildSortResults(RArray x, Integer[] order, int orderLen, ArrayList<Integer> naorder, int naLast, int[] naRemoveIndex) {
        int i;
        RArray res;
        RSymbol[] symbols;
        int nalen = naorder.size();
        int size = x.size();
        RArray.Names names = x.names();
        RSymbol[] rSymbolArray = symbols = names == null ? null : names.sequence();
        if (nalen == 0) {
            res = Utils.createArray(x, orderLen);
            if (symbols == null) {
                for (int i2 = 0; i2 < orderLen; ++i2) {
                    int xi = order[i2];
                    res.set(i2, x.get(xi));
                }
            } else {
                RSymbol[] nsymbols = new RSymbol[orderLen];
                for (i = 0; i < orderLen; ++i) {
                    int xi = order[i];
                    res.set(i, x.get(xi));
                    nsymbols[i] = symbols[xi];
                }
                res = res.setNames(RArray.Names.create(nsymbols));
            }
        } else {
            int resi;
            int xi;
            int i3;
            int dataStart;
            int naStart;
            if (naLast == 1) {
                naStart = orderLen;
                dataStart = 0;
            } else {
                assert (Utils.check(naLast == 0));
                naStart = 0;
                dataStart = nalen;
            }
            res = Utils.createArray(x, size);
            RSymbol[] nsymbols = symbols == null ? null : new RSymbol[size];
            for (i3 = 0; i3 < orderLen; ++i3) {
                xi = order[i3];
                resi = i3 + dataStart;
                res.set(resi, x.get(xi));
                if (nsymbols == null) continue;
                nsymbols[resi] = symbols[xi];
            }
            for (i3 = 0; i3 < nalen; ++i3) {
                xi = naorder.get(i3);
                resi = i3 + naStart;
                res.set(resi, x.get(xi));
                if (nsymbols == null) continue;
                nsymbols[resi] = symbols[xi];
            }
            if (nsymbols != null) {
                res = res.setNames(RArray.Names.create(nsymbols));
            }
        }
        if (naRemoveIndex != null) {
            assert (Utils.check(naLast == Integer.MIN_VALUE));
            int[] ix = new int[orderLen];
            for (i = 0; i < orderLen; ++i) {
                int xi = order[i];
                int corrected = naRemoveIndex[xi];
                ix[i] = corrected + 1;
            }
            ListImpl list = RList.RListFactory.getFor(new RAny[]{res, RInt.RIntFactory.getFor(ix)}, null, resultNames);
            return list;
        }
        return res;
    }

    public static double[] fixNAs(double[] a, int naLast) {
        if (naLast == 1) {
            return a;
        }
        int nna = 0;
        for (int i = a.length - 1; i >= 0 && RDouble.RDoubleUtils.isNAorNaN(a[i]); --i) {
            ++nna;
        }
        if (nna == 0) {
            return a;
        }
        if (naLast == Integer.MIN_VALUE) {
            double[] res = new double[a.length - nna];
            System.arraycopy(a, 0, res, 0, res.length);
            return res;
        }
        double[] tmp = new double[nna];
        System.arraycopy(a, a.length - nna, tmp, 0, nna);
        System.arraycopy(a, 0, a, nna, a.length - nna);
        System.arraycopy(tmp, 0, a, 0, nna);
        return a;
    }

    public static int[] fixNAs(int[] a, int naLast) {
        if (naLast == 0) {
            return a;
        }
        int nna = 0;
        for (int i = 0; i < a.length && a[i] == Integer.MIN_VALUE; ++i) {
            ++nna;
        }
        if (nna == 0) {
            return a;
        }
        if (naLast == Integer.MIN_VALUE) {
            int[] res = new int[a.length - nna];
            System.arraycopy(a, nna, res, 0, res.length);
            return res;
        }
        System.arraycopy(a, nna, a, 0, a.length - nna);
        Arrays.fill(a, a.length - nna, a.length, Integer.MIN_VALUE);
        return a;
    }
}

