/*
 * Decompiled with CFR 0.152.
 */
package r.builtins;

import java.io.IOException;
import org.antlr.runtime.ANTLRFileStream;
import org.antlr.runtime.ANTLRStringStream;
import r.RContext;
import r.Utils;
import r.builtins.Builtin;
import r.builtins.CallFactory;
import r.data.RAny;
import r.data.REnvironment;
import r.data.RFunction;
import r.data.RLogical;
import r.data.RString;
import r.data.RSymbol;
import r.errors.RError;
import r.nodes.ast.ASTNode;
import r.nodes.exec.RNode;
import r.runtime.Frame;

public class Source
extends CallFactory {
    static final CallFactory _ = new Source("source", new String[]{"file", "local", "echo", "print.eval", "verbose", "prompt.echo", "max.deparse.length", "chdir", "encoding", "continue.echo", "skip.echo", "keep.source"}, new String[]{"file"});

    private Source(String name, String[] params, String[] required) {
        super(name, params, required);
    }

    @Override
    public RNode create(ASTNode call, RSymbol[] names, RNode[] exprs) {
        CallFactory.ArgumentInfo ia = this.check(call, names, exprs);
        final int posFile = ia.position("file");
        final int posLocal = ia.position("local");
        if (ia.position("echo") != -1 || ia.position("print.eval") != -1 || ia.position("verbose") != -1 || ia.position("prompt.echo") != -1 || ia.position("max.deparse.length") != -1 || ia.position("chdir") != -1 || ia.position("encoding") != -1 || ia.position("continue.echo") != -1 || ia.position("skip.echo") != -1 || ia.position("keep.source") != -1) {
            Utils.nyi();
        }
        return new Builtin(call, names, exprs){

            @Override
            public RAny doBuiltIn(Frame frame, RAny[] args) {
                Frame targetFrame;
                ANTLRFileStream input;
                RAny fileArg = args[posFile];
                if (fileArg instanceof RString) {
                    RString narg = (RString)fileArg;
                    if (narg.size() != 1) {
                        throw RError.getInvalidArgument(this.ast, "file");
                    }
                    String fileName = narg.getString(0);
                    try {
                        input = new ANTLRFileStream(fileName);
                    }
                    catch (IOException e) {
                        throw RError.getCannotOpenFile(this.ast, fileName, e.toString());
                    }
                } else {
                    Utils.nyi("only file name supported");
                    return null;
                }
                ASTNode tree = RContext.parseFile((ANTLRStringStream)input);
                if (posLocal == -1) {
                    targetFrame = null;
                } else {
                    RAny localArg = args[posLocal];
                    if (localArg instanceof REnvironment) {
                        targetFrame = ((REnvironment)localArg).frame();
                    } else if (localArg instanceof RLogical) {
                        boolean local = Source.parseNonEnvironmentLocal(this.ast, localArg);
                        targetFrame = local ? frame : null;
                    } else {
                        throw RError.getMustBeTrueFalseEnvironment(this.ast, "local");
                    }
                }
                RFunction rootEnclosingFunction = targetFrame == null ? null : targetFrame.function();
                return (RAny)RContext.createRootNode(tree, rootEnclosingFunction).execute(targetFrame);
            }
        };
    }

    public static boolean parseNonEnvironmentLocal(ASTNode ast, RAny arg) {
        RLogical l;
        if (arg instanceof RLogical && (l = (RLogical)arg).size() == 1) {
            int v = l.getLogical(0);
            if (v == 1) {
                return true;
            }
            if (v == 0) {
                return false;
            }
        }
        throw RError.getMustBeTrueFalseEnvironment(ast, "local");
    }
}

