/*
 * Decompiled with CFR 0.152.
 */
package r.builtins;

import r.Convert;
import r.Utils;
import r.builtins.Builtin;
import r.builtins.CallFactory;
import r.data.RAny;
import r.data.RArray;
import r.data.RDouble;
import r.data.RInt;
import r.data.RLogical;
import r.data.RString;
import r.data.RSymbol;
import r.errors.RError;
import r.nodes.ast.ASTNode;
import r.nodes.exec.RNode;
import r.runtime.Frame;

public class Sprintf
extends CallFactory {
    static final CallFactory _ = new Sprintf("sprintf", new String[]{"fmt", "..."}, new String[]{"fmt"});

    private Sprintf(String name, String[] params, String[] required) {
        super(name, params, required);
    }

    @Override
    public RNode create(ASTNode call, RSymbol[] names, RNode[] exprs) {
        CallFactory.ArgumentInfo ia = this.check(call, names, exprs);
        final int posFmt = ia.position("fmt");
        return new Builtin(call, names, exprs){

            @Override
            public RAny doBuiltIn(Frame frame, RAny[] args) {
                return Sprintf.sprintf(args, posFmt, this.ast);
            }
        };
    }

    public static RAny sprintf(RAny[] args, int posFmt, ASTNode ast) {
        RAny fmtArg = args[posFmt];
        if (!(fmtArg instanceof RString)) {
            throw RError.getFmtNotCharacter(ast);
        }
        RString fmt = (RString)fmtArg;
        int resLength = 0;
        RArray[] refs = new RArray[args.length - 1];
        int j = 0;
        for (int i = 0; i < args.length; ++i) {
            RAny aarg = args[i];
            if (!(aarg instanceof RArray)) {
                throw RError.getUnsupportedType(ast);
            }
            RArray a = (RArray)aarg;
            int size = a.size();
            if (size == 0) {
                return RString.EMPTY;
            }
            if (size > resLength) {
                resLength = size;
            }
            if (i == posFmt) continue;
            refs[j++] = a;
        }
        int[] refIndexes = new int[refs.length];
        int fmtIndex = 0;
        String[] resContent = new String[resLength];
        for (int i = 0; i < resLength; ++i) {
            if (i > 0) {
                if (++fmtIndex == fmt.size()) {
                    fmtIndex = 0;
                }
                for (int k = 0; k < refIndexes.length; ++k) {
                    int tmp = refIndexes[k];
                    if (++tmp >= refs[k].size()) {
                        tmp = 0;
                    }
                    refIndexes[k] = tmp;
                }
            }
            StringBuilder str = new StringBuilder();
            String formatString = fmt.getString(fmtIndex);
            int formatStringLength = formatString.length();
            int formatStringPos = 0;
            int nextRef = 0;
            while (true) {
                int rindex;
                RArray r;
                if ((j = formatString.indexOf(37, formatStringPos)) == -1) break;
                str.append(formatString.substring(formatStringPos, j));
                formatStringPos = j;
                if (j + 1 < formatStringLength && formatString.charAt(j + 1) == '%') {
                    str.append('%');
                    formatStringPos += 2;
                    continue;
                }
                StringBuilder formatBit = new StringBuilder();
                formatBit.append('%');
                int fixedRef = -1;
                int remaining = formatStringLength - ++j;
                if (remaining > 2) {
                    char c1 = formatString.charAt(j);
                    char c2 = formatString.charAt(j + 1);
                    if (c1 >= '1' && c1 <= '9') {
                        int v = c1 - 48;
                        if (c2 == '$') {
                            fixedRef = v - 1;
                            j += 2;
                        } else if (remaining > 3 && c2 >= '0' && c2 <= '9' && formatString.charAt(j + 2) == '$') {
                            fixedRef = v * 10 + (c2 - 48) - 1;
                            j += 3;
                        }
                    }
                }
                if (fixedRef >= refs.length) {
                    throw RError.getReferenceNonexistent(ast, fixedRef + 1);
                }
                boolean foundStar = false;
                boolean foundEnd = false;
                char fmtChar = '0';
                while (j < formatStringLength && !foundEnd) {
                    char c = formatString.charAt(j);
                    switch (c) {
                        case '*': {
                            int rindex2;
                            RArray r2;
                            if (foundStar) {
                                throw RError.getAtMostOneAsterisk(ast);
                            }
                            foundStar = true;
                            remaining = formatStringLength - j - 1;
                            int fixedStarRef = -1;
                            if (remaining > 2) {
                                char c1 = formatString.charAt(j + 1);
                                char c2 = formatString.charAt(j + 2);
                                if (c1 >= '1' && c1 <= '9') {
                                    int v = c1 - 48;
                                    if (c2 == '$') {
                                        fixedStarRef = v - 1;
                                        j += 2;
                                    } else if (remaining > 3 && c2 >= '0' && c2 <= '9' && formatString.charAt(j + 3) == '$') {
                                        fixedStarRef = v * 10 + (c2 - 48) - 1;
                                        j += 3;
                                    }
                                }
                            }
                            if (fixedStarRef >= refs.length) {
                                throw RError.getReferenceNonexistent(ast, fixedStarRef + 1);
                            }
                            if (fixedStarRef > 0) {
                                r2 = refs[fixedStarRef];
                                rindex2 = refIndexes[fixedStarRef];
                            } else {
                                if (nextRef == refIndexes.length) {
                                    throw RError.getTooFewArguments(ast);
                                }
                                r2 = refs[nextRef];
                                rindex2 = refIndexes[nextRef];
                                ++nextRef;
                            }
                            if (!(r2 instanceof RInt) && !(r2 instanceof RDouble)) {
                                throw RError.getArgumentStarNumber(ast);
                            }
                            int refNumber = r2.asInt().getInt(rindex2);
                            if (refNumber == Integer.MIN_VALUE) {
                                throw RError.getArgumentStarNumber(ast);
                            }
                            formatBit.append(String.format("%d", refNumber));
                            break;
                        }
                        case 'i': {
                            fmtChar = c;
                            formatBit.append('d');
                            foundEnd = true;
                            break;
                        }
                        case 'A': 
                        case 'E': 
                        case 'G': 
                        case 'X': 
                        case 'a': 
                        case 'd': 
                        case 'e': 
                        case 'f': 
                        case 'g': 
                        case 'o': 
                        case 's': 
                        case 'x': {
                            foundEnd = true;
                        }
                        default: {
                            fmtChar = c;
                            formatBit.append(c);
                        }
                    }
                    ++j;
                }
                if (!foundEnd) {
                    throw RError.getUnrecognizedFormat(ast, formatString.substring(formatStringPos));
                }
                formatStringPos = j;
                if (fixedRef > 0) {
                    r = refs[fixedRef];
                    rindex = refIndexes[fixedRef];
                } else {
                    if (nextRef == refIndexes.length) {
                        throw RError.getTooFewArguments(ast);
                    }
                    r = refs[nextRef];
                    rindex = refIndexes[nextRef];
                    ++nextRef;
                }
                Sprintf.print(r.boxedGet(rindex), str, formatBit, fmtChar, ast);
                resContent[i] = str.toString();
            }
            str.append(formatString.substring(formatStringPos));
            resContent[i] = str.toString();
        }
        return RString.RStringFactory.getFor(resContent);
    }

    public static void print(RAny r, StringBuilder str, StringBuilder formatBit, char fmtChar, ASTNode ast) {
        if (r instanceof RLogical) {
            Sprintf.printLogical(((RLogical)r).getLogical(0), str, formatBit, fmtChar, ast);
        } else if (r instanceof RInt) {
            Sprintf.printInteger(((RInt)r).getInt(0), str, formatBit, fmtChar, ast);
        } else if (r instanceof RDouble) {
            Sprintf.printDouble(((RDouble)r).getDouble(0), str, formatBit, fmtChar, ast);
        } else if (r instanceof RString) {
            Sprintf.printString(((RString)r).getString(0), str, formatBit, fmtChar, ast);
        } else {
            throw RError.getUnsupportedType(ast);
        }
    }

    public static void printLogical(int value, StringBuilder str, StringBuilder formatBit, char fmtChar, ASTNode ast) {
        switch (fmtChar) {
            case 'd': 
            case 'i': {
                if (value == Integer.MIN_VALUE) {
                    formatBit.setCharAt(formatBit.length() - 1, 's');
                    str.append(String.format(formatBit.toString(), "NA"));
                    break;
                }
                str.append(String.format(formatBit.toString(), value));
                break;
            }
            case 'A': 
            case 'E': 
            case 'G': 
            case 'a': 
            case 'e': 
            case 'f': 
            case 'g': {
                Sprintf.printDouble(Convert.logical2double(value), str, formatBit, fmtChar, ast);
                break;
            }
            case 's': {
                Sprintf.printString(Convert.logical2string(value), str, formatBit, fmtChar, ast);
                break;
            }
            default: {
                throw RError.getInvalidFormatLogical(ast, formatBit.toString());
            }
        }
    }

    public static void printInteger(int value, StringBuilder str, StringBuilder formatBit, char fmtChar, ASTNode ast) {
        switch (fmtChar) {
            case 'X': 
            case 'd': 
            case 'i': 
            case 'o': 
            case 'x': {
                if (value == Integer.MIN_VALUE) {
                    formatBit.setCharAt(formatBit.length() - 1, 's');
                    str.append(String.format(formatBit.toString(), "NA"));
                    break;
                }
                str.append(String.format(formatBit.toString(), value));
                break;
            }
            case 'A': 
            case 'E': 
            case 'G': 
            case 'a': 
            case 'e': 
            case 'f': 
            case 'g': {
                Sprintf.printDouble(Convert.int2double(value), str, formatBit, fmtChar, ast);
                break;
            }
            case 's': {
                Sprintf.printString(Convert.int2string(value), str, formatBit, fmtChar, ast);
                break;
            }
            default: {
                throw RError.getInvalidFormatInteger(ast, formatBit.toString());
            }
        }
    }

    public static void printDouble(double value, StringBuilder str, StringBuilder formatBit, char fmtChar, ASTNode ast) {
        switch (fmtChar) {
            case 'X': 
            case 'd': 
            case 'i': 
            case 'o': 
            case 'x': {
                if (RDouble.RDoubleUtils.fitsRInt(value)) {
                    Sprintf.printInteger(Convert.double2int(value), str, formatBit, fmtChar, ast);
                    break;
                }
                throw RError.getInvalidFormatDouble(ast, formatBit.toString());
            }
            case 'A': 
            case 'E': 
            case 'G': 
            case 'a': 
            case 'e': 
            case 'f': 
            case 'g': {
                boolean hasPlus;
                if (RDouble.RDoubleUtils.isFinite(value)) {
                    str.append(String.format(formatBit.toString(), value));
                    break;
                }
                int dotIndex = formatBit.indexOf(".");
                if (dotIndex != -1) {
                    formatBit.setLength(dotIndex + 1);
                }
                formatBit.setCharAt(formatBit.length() - 1, 's');
                boolean hasSpace = formatBit.indexOf(" ") != -1;
                boolean bl = hasPlus = formatBit.indexOf("+") != -1;
                if (RDouble.RDoubleUtils.isNA(value)) {
                    str.append(String.format(formatBit.toString(), hasSpace ? " NA" : "NA"));
                    break;
                }
                if (RDouble.RDoubleUtils.isNAorNaN(value)) {
                    str.append(String.format(formatBit.toString(), hasSpace ? " NaN" : "NaN"));
                    break;
                }
                if (value == Double.POSITIVE_INFINITY) {
                    str.append(String.format(formatBit.toString(), hasPlus ? "+Inf" : (hasSpace ? " Inf" : "Inf")));
                    break;
                }
                assert (Utils.check(value == Double.NEGATIVE_INFINITY));
                str.append(String.format(formatBit.toString(), "-Inf"));
                break;
            }
            case 's': {
                Sprintf.printString(Convert.double2string(value), str, formatBit, fmtChar, ast);
                break;
            }
            default: {
                throw RError.getInvalidFormatDouble(ast, formatBit.toString());
            }
        }
    }

    public static void printString(String value, StringBuilder str, StringBuilder formatBit, char fmtChar, ASTNode ast) {
        switch (fmtChar) {
            case 's': {
                str.append(String.format(formatBit.toString(), Convert.prettyNA(value)));
                break;
            }
            default: {
                throw RError.getInvalidFormatString(ast, formatBit.toString());
            }
        }
    }
}

