/*
 * Decompiled with CFR 0.152.
 */
package r.builtins;

import r.RContext;
import r.builtins.Builtin;
import r.builtins.CallFactory;
import r.data.RAny;
import r.data.RDouble;
import r.data.RInt;
import r.data.RLogical;
import r.data.RSymbol;
import r.data.internal.View;
import r.errors.RError;
import r.nodes.ast.ASTNode;
import r.nodes.exec.RNode;
import r.runtime.Frame;

final class Sqrt
extends CallFactory {
    static final CallFactory _ = new Sqrt("sqrt", new String[]{"x"}, new String[]{"x"});

    private Sqrt(String name, String[] params, String[] required) {
        super(name, params, required);
    }

    @Override
    public RNode create(ASTNode call, RSymbol[] names, RNode[] exprs) {
        this.check(call, names, exprs);
        return new Builtin.Builtin1(call, names, exprs){

            @Override
            public RAny doBuiltIn(Frame frame, RAny arg) {
                RDouble typedArg;
                if (arg instanceof RDouble) {
                    typedArg = (RDouble)arg;
                } else if (arg instanceof RInt || arg instanceof RLogical) {
                    typedArg = arg.asDouble();
                } else {
                    throw RError.getNonNumericMath(this.ast);
                }
                return new View.RDoubleProxy<RDouble>(typedArg){

                    @Override
                    public double getDouble(int i) {
                        double d = ((RDouble)this.orig).getDouble(i);
                        if (RDouble.RDoubleUtils.isNAorNaN(d)) {
                            return RDouble.NA;
                        }
                        double res = Math.sqrt(d);
                        if (RDouble.RDoubleUtils.isNAorNaN(res)) {
                            RContext.warning(ast, "NaNs produced");
                        }
                        return res;
                    }
                };
            }
        };
    }
}

