/*
 * Decompiled with CFR 0.152.
 */
package r.builtins;

import r.builtins.AsBase;
import r.builtins.Builtin;
import r.builtins.CallFactory;
import r.data.RAny;
import r.data.RString;
import r.data.RSymbol;
import r.errors.RError;
import r.nodes.ast.ASTNode;
import r.nodes.exec.RNode;
import r.runtime.Frame;

public class Stop
extends CallFactory {
    static final CallFactory _ = new Stop("stop", new String[]{"..."}, null);

    private Stop(String name, String[] params, String[] required) {
        super(name, params, required);
    }

    @Override
    public RNode create(ASTNode call, RSymbol[] names, RNode[] exprs) {
        this.check(call, names, exprs);
        return new Builtin(call, names, exprs){

            @Override
            public RAny doBuiltIn(Frame frame, RAny[] args) {
                throw RError.getGenericError(this.ast, Stop.makeMessage(args, this.ast));
            }
        };
    }

    public static String makeMessage(RAny[] args, ASTNode ast) {
        StringBuilder str = new StringBuilder();
        for (RAny arg : args) {
            RString rs = AsBase.genericAsString(ast, arg);
            int rsize = rs.size();
            for (int i = 0; i < rsize; ++i) {
                String s = rs.getString(i);
                if (s == RString.NA) {
                    str.append("NA");
                    continue;
                }
                str.append(s);
            }
        }
        return str.toString();
    }
}

