/*
 * Decompiled with CFR 0.152.
 */
package r.builtins;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import r.Convert;
import r.RContext;
import r.Utils;
import r.builtins.Builtin;
import r.builtins.CallFactory;
import r.data.RAny;
import r.data.RList;
import r.data.RString;
import r.data.RSymbol;
import r.nodes.ast.ASTNode;
import r.nodes.exec.RNode;
import r.runtime.Frame;

final class Strsplit
extends CallFactory {
    static final CallFactory _ = new Strsplit("strsplit", new String[]{"x", "split", "fixed", "perl", "useBytes"}, new String[]{"x", "split"});

    private Strsplit(String name, String[] params, String[] required) {
        super(name, params, required);
    }

    @Override
    public RNode create(ASTNode call, RSymbol[] names, RNode[] exprs) {
        CallFactory.ArgumentInfo ia = this.check(call, names, exprs);
        if (ia.provided("useBytes")) {
            throw Utils.nyi();
        }
        final int posX = ia.position("x");
        final int posFixed = ia.position("fixed");
        final int posPerl = ia.position("perl");
        final int posSplit = ia.position("split");
        return new Builtin(call, names, exprs){

            @Override
            public RAny doBuiltIn(Frame frame, RAny[] args) {
                RString x = Convert.coerceToStringError(args[posX], this.ast);
                RString split = Convert.coerceToStringError(args[posSplit], this.ast);
                boolean fixed = posFixed != -1 ? Convert.checkFirstLogical(args[posFixed], 1) : false;
                boolean perl = posPerl != -1 ? Convert.checkFirstLogical(args[posPerl], 1) : false;
                return Strsplit.strsplit(this.ast, x, split, fixed, perl);
            }
        };
    }

    public static RAny strSplitRE(RString x, RString split) {
        int splitIndex = 0;
        int splitSize = split.size();
        Pattern[] patterns = new Pattern[splitSize];
        int xsize = x.size();
        RAny[] content = new RAny[xsize];
        ArrayList<String> buf = new ArrayList<String>();
        for (int i = 0; i < xsize; ++i) {
            Pattern p = patterns[splitIndex];
            if (p == null) {
                String separator = split.getString(splitIndex);
                patterns[splitIndex] = p = Pattern.compile(separator);
                if (++splitIndex == splitSize) {
                    splitIndex = 0;
                }
            }
            String str = x.getString(i);
            int strLen = str.length();
            Matcher m = p.matcher(str);
            buf.clear();
            int j = 0;
            while (j < strLen) {
                if (m.find()) {
                    if (m.end() > 0) {
                        buf.add(str.substring(j, m.start()));
                    }
                    j = m.end();
                    continue;
                }
                if (j >= strLen) break;
                buf.add(str.substring(j));
                break;
            }
            String[] econtent = new String[buf.size()];
            content[i] = RString.RStringFactory.getFor(buf.toArray(econtent));
        }
        return RList.RListFactory.getFor(content);
    }

    public static RAny strSplitFixed(RString x, RString split) {
        int xsize = x.size();
        RAny[] content = new RAny[xsize];
        int splitIndex = 0;
        int splitSize = split.size();
        ArrayList<String> buf = new ArrayList<String>();
        for (int i = 0; i < xsize; ++i) {
            String separator = split.getString(splitIndex++);
            int separatorLength = separator.length();
            if (splitIndex == splitSize) {
                splitIndex = 0;
            }
            String str = x.getString(i);
            if (separatorLength > 0) {
                int strLen = str.length();
                int j = 0;
                buf.clear();
                while (j < strLen) {
                    int separatorStart = str.indexOf(separator, j);
                    if (separatorStart != -1) {
                        buf.add(str.substring(j, separatorStart));
                        j = separatorStart + separatorLength;
                        continue;
                    }
                    if (j >= strLen) break;
                    buf.add(str.substring(j));
                    break;
                }
                String[] econtent = new String[buf.size()];
                content[i] = RString.RStringFactory.getFor(buf.toArray(econtent));
                continue;
            }
            content[i] = RString.RStringFactory.getFor(Strsplit.stringToChars(str));
        }
        return RList.RListFactory.getFor(content);
    }

    public static String[] stringToChars(String str) {
        int strLen = str.length();
        String[] chars = new String[strLen];
        for (int j = 0; j < strLen; ++j) {
            chars[j] = String.valueOf(str.charAt(j));
        }
        return chars;
    }

    public static RAny strSplitChars(RString x) {
        int xsize = x.size();
        RAny[] content = new RAny[xsize];
        for (int i = 0; i < xsize; ++i) {
            content[i] = RString.RStringFactory.getFor(Strsplit.stringToChars(x.getString(i)));
        }
        return RList.RListFactory.getFor(content);
    }

    public static RAny strsplit(ASTNode ast, RString x, RString split, boolean fixed, boolean perl) {
        int splitSize = split.size();
        if (splitSize == 0) {
            return Strsplit.strSplitChars(x);
        }
        if (splitSize == 1 && split.getString(0).length() == 0) {
            return Strsplit.strSplitChars(x);
        }
        if (!fixed) {
            if (!perl) {
                RContext.warning(ast, "Using a Perl-like regular expression syntax (non-Perl not implemented yet).");
            }
            return Strsplit.strSplitRE(x, split);
        }
        return Strsplit.strSplitFixed(x, split);
    }
}

