/*
 * Decompiled with CFR 0.152.
 */
package r.builtins;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import r.Convert;
import r.RContext;
import r.builtins.Builtin;
import r.builtins.CallFactory;
import r.data.RAny;
import r.data.RString;
import r.data.RSymbol;
import r.errors.RError;
import r.nodes.ast.ASTNode;
import r.nodes.exec.RNode;
import r.runtime.Frame;

class Sub
extends CallFactory {
    static final CallFactory _ = new Sub("sub", new String[]{"pattern", "replacement", "x", "ignore.case", "perl", "fixed", "useBytes"}, new String[]{"x", "pattern", "replacement"}, false);
    boolean global;

    Sub(String name, String[] params, String[] required, boolean global) {
        super(name, params, required);
        this.global = global;
    }

    @Override
    public RNode create(ASTNode call, RSymbol[] names, RNode[] exprs) {
        CallFactory.ArgumentInfo ia = this.check(call, names, exprs);
        final int posPattern = ia.position("pattern");
        final int posReplacement = ia.position("replacement");
        final int posX = ia.position("x");
        final int posIgnoreCase = ia.position("ignore.case");
        final int posPerl = ia.position("perl");
        final int posFixed = ia.position("fixed");
        final int posUseBytes = ia.position("useBytes");
        return new Builtin(call, names, exprs){

            @Override
            public final RAny doBuiltIn(Frame frame, RAny[] args) {
                if (posUseBytes != -1) {
                    RContext.warning(this.ast, "Ignoring useBytes.");
                }
                String pattern = Sub.parseScalarString(this.ast, args[posPattern], "pattern");
                String replacement = Sub.parseScalarString(this.ast, args[posReplacement], "replacement");
                RString x = Convert.coerceToStringError(args[posX], this.ast);
                boolean ignoreCase = posIgnoreCase != -1 ? Convert.checkFirstLogical(args[posIgnoreCase], 1) : false;
                boolean perl = posPerl != -1 ? Convert.checkFirstLogical(args[posPerl], 1) : false;
                boolean fixed = posFixed != -1 ? Convert.checkFirstLogical(args[posFixed], 1) : false;
                return Sub.sub(this.ast, pattern, replacement, x, ignoreCase, perl, fixed, Sub.this.global);
            }
        };
    }

    public static String parseScalarString(ASTNode ast, RAny value, String argName) {
        RString rstring = Convert.coerceToStringError(value, ast);
        int size = rstring.size();
        if (size == 1) {
            return rstring.getString(0);
        }
        if (size > 1) {
            RContext.warning(ast, String.format("argument '%s' has length > 1 and only the first element will be used", argName));
        }
        throw RError.getInvalidArgument(ast, argName);
    }

    public static RString sub(ASTNode ast, String pattern, String replacement, RString x, boolean ignoreCase, boolean perl, boolean fixed, boolean global) {
        if (pattern == RString.NA || replacement == RString.NA) {
            return RString.RStringFactory.getNAArray(x.size());
        }
        if (!perl) {
            RContext.warning(ast, "Using a Perl-like regular expression syntax (non-Perl not implemented yet).");
        }
        if (!fixed) {
            return Sub.subRE(pattern, replacement, x, ignoreCase, global);
        }
        return Sub.subFixed(ast, pattern, replacement, x, ignoreCase, global);
    }

    public static String convertReplacement(String replacementArg) {
        return replacementArg.replaceAll("\\\\([1-9])", "\\$$1");
    }

    public static RString subRE(String pattern, String replacementArg, RString x, boolean ignoreCase, boolean global) {
        Pattern p = Pattern.compile(pattern, ignoreCase ? 2 : 0);
        int size = x.size();
        String[] content = new String[size];
        String replacement = Sub.convertReplacement(replacementArg);
        for (int i = 0; i < size; ++i) {
            String s = x.getString(i);
            if (s != RString.NA) {
                Matcher m = p.matcher(s);
                if (global) {
                    content[i] = m.replaceAll(replacement);
                    continue;
                }
                content[i] = m.replaceFirst(replacement);
                continue;
            }
            content[i] = RString.NA;
        }
        return RString.RStringFactory.getFor(content, x.dimensions(), x.names());
    }

    public static RString subFixed(ASTNode ast, String patternArg, String replacement, RString xArg, boolean ignoreCase, boolean global) {
        int size = xArg.size();
        String[] content = new String[size];
        if (patternArg.length() == 0) {
            throw RError.getZeroLengthPattern(ast);
        }
        String pattern = !ignoreCase ? patternArg : patternArg.toLowerCase();
        int pLen = pattern.length();
        for (int i = 0; i < size; ++i) {
            String xstr = xArg.getString(i);
            if (xstr == RString.NA) {
                content[i] = RString.NA;
                continue;
            }
            String x = !ignoreCase ? xstr : xstr.toLowerCase();
            int pStart = x.indexOf(pattern);
            if (pStart != -1) {
                String init = xstr.substring(0, pStart);
                StringBuilder b = new StringBuilder(init);
                b.append(replacement);
                int xLen = xstr.length();
                int searchStart = pStart + pLen;
                if (global) {
                    while ((pStart = x.indexOf(pattern, searchStart)) != -1) {
                        b.append(xstr.substring(searchStart, pStart));
                        b.append(replacement);
                        searchStart = pStart + pLen;
                    }
                }
                b.append(xstr.substring(searchStart, xLen));
                content[i] = b.toString();
                continue;
            }
            content[i] = xstr;
        }
        return RString.RStringFactory.getFor(content, xArg.dimensions(), xArg.names());
    }
}

