/*
 * Decompiled with CFR 0.152.
 */
package r.builtins;

import r.Utils;
import r.builtins.CallFactory;
import r.data.RAny;
import r.data.RArray;
import r.data.RDots;
import r.data.REnvironment;
import r.data.RLanguage;
import r.data.RList;
import r.data.RPromise;
import r.data.RSymbol;
import r.errors.RError;
import r.nodes.ast.ASTNode;
import r.nodes.ast.ArgumentList;
import r.nodes.ast.Constant;
import r.nodes.ast.FunctionCall;
import r.nodes.ast.SimpleAccessVariable;
import r.nodes.ast.Visitor;
import r.nodes.exec.BaseR;
import r.nodes.exec.RNode;
import r.nodes.tools.DuplicateVisitor;
import r.runtime.Frame;

public class Substitute
extends CallFactory {
    static final CallFactory _ = new Substitute("substitute", new String[]{"expr", "env"}, new String[]{"expr"});
    private static final SubstituteVisitor substituteVisitor = new SubstituteVisitor();

    private Substitute(String name, String[] params, String[] required) {
        super(name, params, required);
    }

    @Override
    public RNode create(ASTNode call, RSymbol[] names, final RNode[] exprs) {
        CallFactory.ArgumentInfo ia = this.check(call, names, exprs);
        int posExpr = ia.position("expr");
        final int posEnv = ia.position("env");
        RNode expr = exprs[posExpr];
        final ASTNode exprAST = expr.getAST();
        if (posEnv == -1) {
            return new BaseR(call){

                @Override
                public Object execute(Frame frame) {
                    FindVar find = frame == null ? new NeverFind() : new FindInFrame(frame);
                    return Substitute.substitute(exprAST, find);
                }
            };
        }
        return new BaseR(call){
            @RNode.Child
            RNode envExpr;
            {
                super(x0);
                this.envExpr = this.adoptChild(exprs[posEnv]);
            }

            @Override
            public Object execute(Frame frame) {
                FindVar find;
                Object env = this.envExpr.execute(frame);
                if (env instanceof REnvironment) {
                    find = env == REnvironment.GLOBAL ? new NeverFind() : new FindInEnvironment((REnvironment)env);
                } else if (env instanceof RList) {
                    find = new FindInList((RList)env);
                } else {
                    throw RError.getInvalidEnvironment(this.ast);
                }
                return Substitute.substitute(exprAST, find);
            }

            @Override
            protected <N extends RNode> N replaceChild(RNode oldNode, N newNode) {
                assert (oldNode != null);
                if (this.envExpr == oldNode) {
                    this.envExpr = newNode;
                    return this.adoptInternal(newNode);
                }
                return super.replaceChild(oldNode, newNode);
            }
        };
    }

    public static RAny substitute(ASTNode x, FindVar env) {
        ASTNode res = substituteVisitor.substitute(x, env);
        if (res instanceof Constant) {
            return ((Constant)res).getValue();
        }
        return new RLanguage(res);
    }

    public static class SubstituteVisitor
    extends DuplicateVisitor
    implements Visitor {
        private FindVar env;
        private final DuplicateVisitor independentDuplicator = new DuplicateVisitor();

        public ASTNode substitute(ASTNode ast, FindVar env) {
            this.env = env;
            ast.accept(this);
            return this.result;
        }

        protected ASTNode substituteBinding(Object binding) {
            if (binding == null) {
                return null;
            }
            if (binding instanceof RPromise) {
                RPromise p = (RPromise)binding;
                return this.independentDuplicator.duplicate(p.expression().getAST());
            }
            if (binding instanceof RLanguage) {
                RLanguage l = (RLanguage)binding;
                return this.independentDuplicator.duplicate(l.get());
            }
            return new Constant((RAny)binding);
        }

        @Override
        public void visit(SimpleAccessVariable n) {
            RSymbol symbol = n.getSymbol();
            Object binding = this.env.find(symbol);
            ASTNode newAST = this.substituteBinding(binding);
            if (binding == null) {
                super.visit(n);
            } else {
                this.result = newAST;
            }
        }

        @Override
        protected ArgumentList d(ArgumentList l) {
            ArgumentList.Default newList = new ArgumentList.Default();
            for (ArgumentList.Entry e : l) {
                Object binding;
                ASTNode n = e.getValue();
                if (n instanceof SimpleAccessVariable && ((SimpleAccessVariable)n).getSymbol() == RSymbol.THREE_DOTS_SYMBOL && (binding = this.env.find(RSymbol.THREE_DOTS_SYMBOL)) != null && binding instanceof RDots) {
                    RDots dots = (RDots)binding;
                    RSymbol[] dnames = dots.names();
                    Object[] dvalues = dots.values();
                    int len = dnames.length;
                    for (int i = 0; i < len; ++i) {
                        ASTNode dast = this.substituteBinding(dvalues[i]);
                        RSymbol name = dnames[i];
                        if (dast != null) {
                            newList.add(name, dast);
                            continue;
                        }
                        if (name != null) {
                            newList.add(name, (ASTNode)new SimpleAccessVariable(name));
                            continue;
                        }
                        newList.add(name, null);
                    }
                    continue;
                }
                newList.add(e.getName(), this.d(e.getValue()));
            }
            return newList;
        }

        @Override
        public void visit(FunctionCall n) {
            Object newTarget;
            RSymbol symbol = n.getName();
            Object binding = this.env.find(symbol);
            if (binding == null) {
                super.visit(n);
                return;
            }
            if (binding instanceof RPromise) {
                RPromise p = (RPromise)binding;
                newTarget = p.expression().getAST();
                this.result = this.independentDuplicator.duplicate(p.expression().getAST());
            } else if (binding instanceof RLanguage) {
                RLanguage l = (RLanguage)binding;
                newTarget = l.get();
            } else {
                newTarget = binding;
            }
            if (newTarget instanceof SimpleAccessVariable) {
                this.result = new FunctionCall(((SimpleAccessVariable)newTarget).getSymbol(), this.d(n.getArgs()));
            } else if (newTarget instanceof RSymbol) {
                this.result = new FunctionCall((RSymbol)newTarget, this.d(n.getArgs()));
            } else {
                Utils.nyi("unsupported substitution");
            }
        }
    }

    public static class FindInEnvironment
    extends FindVar {
        final REnvironment env;

        public FindInEnvironment(REnvironment env) {
            this.env = env;
        }

        @Override
        Object find(RSymbol name) {
            return this.env.localGetNotForcing(name);
        }
    }

    public static class FindInList
    extends FindVar {
        final RList list;
        final RArray.Names names;

        public FindInList(RList list) {
            this.list = list;
            this.names = list.names();
        }

        @Override
        Object find(RSymbol name) {
            int i = this.names.map(name);
            if (i < 0) {
                return null;
            }
            return this.list.getRAny(i);
        }
    }

    public static class FindInFrame
    extends FindVar {
        final Frame frame;

        public FindInFrame(Frame frame) {
            this.frame = frame;
        }

        @Override
        Object find(RSymbol name) {
            return this.frame.localReadNotForcing(name);
        }
    }

    public static class NeverFind
    extends FindVar {
        @Override
        Object find(RSymbol name) {
            return null;
        }
    }

    public static abstract class FindVar {
        abstract Object find(RSymbol var1);
    }
}

