/*
 * Decompiled with CFR 0.152.
 */
package r.builtins;

import r.Convert;
import r.RContext;
import r.builtins.Builtin;
import r.builtins.CallFactory;
import r.data.RAny;
import r.data.RDouble;
import r.data.RString;
import r.data.RSymbol;
import r.errors.RError;
import r.nodes.ast.ASTNode;
import r.nodes.exec.RNode;
import r.runtime.Frame;

class Substr
extends CallFactory {
    static final CallFactory _ = new Substr("substr", new String[]{"x", "start", "stop"}, new String[]{"x", "start", "stop"});
    static final Convert.ConversionStatus warn = new Convert.ConversionStatus();

    Substr(String name, String[] params, String[] required) {
        super(name, params, required);
    }

    @Override
    public RNode create(ASTNode call, RSymbol[] names, RNode[] exprs) {
        CallFactory.ArgumentInfo ia = this.check(call, names, exprs);
        final int posX = ia.position("x");
        final int posStart = ia.position("start");
        final int posStop = ia.position("stop");
        return new Builtin(call, names, exprs){

            @Override
            public final RAny doBuiltIn(Frame frame, RAny[] args) {
                RString x = args[posX].asString();
                Substr.warn.naIntroduced = false;
                RDouble start = args[posStart].asDouble(warn);
                RDouble stop = args[posStop].asDouble(warn);
                RString res = Substr.substr(x, start, stop, this.ast);
                if (Substr.warn.naIntroduced) {
                    RContext.warning(this.ast, "NAs introduced by coercion");
                }
                return res;
            }
        };
    }

    public static RString substr(RString x, RDouble start, RDouble stop, ASTNode ast) {
        int xsize = x.size();
        int startSize = start.size();
        int stopSize = stop.size();
        int startIndex = 0;
        int stopIndex = 0;
        if (xsize == 0) {
            return RString.EMPTY;
        }
        if (startSize == 0) {
            throw RError.getInvalidArgument(ast, "start");
        }
        if (stopSize == 0) {
            throw RError.getInvalidArgument(ast, "stop");
        }
        String[] content = new String[xsize];
        for (int i = 0; i < xsize; ++i) {
            double nstart = start.getDouble(startIndex++);
            if (startIndex == startSize) {
                startIndex = 0;
            }
            double nstop = stop.getDouble(stopIndex++);
            if (stopIndex == stopSize) {
                stopIndex = 0;
            }
            String str = x.getString(i);
            if (!RDouble.RDoubleUtils.isNAorNaN(nstart) && !RDouble.RDoubleUtils.isNAorNaN(nstop) && str != RString.NA) {
                int stp = (int)nstop;
                int len = str.length();
                if (stp > len) {
                    stp = len;
                }
                content[i] = str.substring((int)nstart - 1, stp);
                continue;
            }
            content[i] = RString.NA;
        }
        return RString.RStringFactory.getFor(content);
    }
}

