/*
 * Decompiled with CFR 0.152.
 */
package r.builtins;

import r.Convert;
import r.RContext;
import r.builtins.Builtin;
import r.builtins.CallFactory;
import r.data.RAny;
import r.data.RDouble;
import r.data.RString;
import r.data.RSymbol;
import r.data.internal.ScalarDoubleImpl;
import r.errors.RError;
import r.nodes.ast.ASTNode;
import r.nodes.exec.RNode;
import r.runtime.Frame;

class Substring
extends CallFactory {
    static final CallFactory _ = new Substring("substring", new String[]{"text", "first", "last"}, new String[]{"text", "first"});
    static final Convert.ConversionStatus warn = new Convert.ConversionStatus();

    Substring(String name, String[] params, String[] required) {
        super(name, params, required);
    }

    @Override
    public RNode create(ASTNode call, RSymbol[] names, RNode[] exprs) {
        CallFactory.ArgumentInfo ia = this.check(call, names, exprs);
        final int posText = ia.position("text");
        final int posLast = ia.position("last");
        final int posFirst = ia.position("first");
        final ScalarDoubleImpl defaultLast = RDouble.RDoubleFactory.getScalar(1000000.0);
        return new Builtin(call, names, exprs){

            @Override
            public RAny doBuiltIn(Frame frame, RAny[] args) {
                RString text = args[posText].asString();
                Substring.warn.naIntroduced = false;
                RDouble first = args[posFirst].asDouble(warn);
                RDouble last = posLast != -1 ? args[posLast].asDouble(warn) : defaultLast;
                RString res = Substring.substring(text, first, last, this.ast);
                if (Substring.warn.naIntroduced) {
                    RContext.warning(this.ast, "NAs introduced by coercion");
                }
                return res;
            }
        };
    }

    public static RString substring(RString text, RDouble first, RDouble last, ASTNode ast) {
        int textSize = text.size();
        int firstSize = first.size();
        int lastSize = last.size();
        int textIndex = 0;
        int firstIndex = 0;
        int lastIndex = 0;
        if (textSize == 0) {
            return RString.EMPTY;
        }
        if (firstSize == 0) {
            throw RError.getInvalidArgument(ast, "first");
        }
        if (lastSize == 0) {
            throw RError.getInvalidArgument(ast, "last");
        }
        int n = Math.max(textSize, Math.max(firstSize, lastSize));
        String[] content = new String[n];
        for (int i = 0; i < n; ++i) {
            double nfirst = first.getDouble(firstIndex++);
            if (firstIndex == firstSize) {
                firstIndex = 0;
            }
            double nlast = last.getDouble(lastIndex++);
            if (lastIndex == lastSize) {
                lastIndex = 0;
            }
            String str = text.getString(textIndex++);
            if (textIndex == textSize) {
                textIndex = 0;
            }
            if (!RDouble.RDoubleUtils.isNAorNaN(nfirst) && !RDouble.RDoubleUtils.isNAorNaN(nlast) && str != RString.NA) {
                int stp = (int)nlast;
                int len = str.length();
                if (stp > len) {
                    stp = len;
                }
                content[i] = str.substring((int)nfirst - 1, stp);
                continue;
            }
            content[i] = RString.NA;
        }
        return RString.RStringFactory.getFor(content);
    }
}

