/*
 * Decompiled with CFR 0.152.
 */
package r.builtins;

import r.builtins.Builtin;
import r.builtins.CallFactory;
import r.data.RAny;
import r.data.RArray;
import r.data.RComplex;
import r.data.RDouble;
import r.data.RInt;
import r.data.RLogical;
import r.data.RNull;
import r.data.RSymbol;
import r.errors.RError;
import r.nodes.ast.ASTNode;
import r.nodes.ast.BinaryOperation;
import r.nodes.ast.Constant;
import r.nodes.ast.EQ;
import r.nodes.ast.GE;
import r.nodes.ast.GT;
import r.nodes.ast.LE;
import r.nodes.ast.LT;
import r.nodes.ast.NE;
import r.nodes.exec.RNode;
import r.runtime.Frame;

final class Sum
extends CallFactory {
    static final CallFactory _ = new Sum("sum", new String[]{"...", "na.rm"}, new String[0]);

    Sum(String name, String[] params, String[] required) {
        super(name, params, required);
    }

    public static void sum(RComplex v, boolean narm, double[] res) {
        int size = v.size();
        double rreal = 0.0;
        double rimag = 0.0;
        for (int i = 0; i < size; ++i) {
            double real = v.getReal(i);
            double imag = v.getImag(i);
            if (narm && RComplex.RComplexUtils.eitherIsNAorNaN(real, imag)) continue;
            rreal += real;
            rimag += imag;
        }
        res[0] = rreal;
        res[1] = rimag;
    }

    public static double sum(RDouble v, boolean narm) {
        int size = v.size();
        double res = 0.0;
        for (int i = 0; i < size; ++i) {
            double d = v.getDouble(i);
            if (narm && RDouble.RDoubleUtils.isNAorNaN(d)) continue;
            res += d;
        }
        return res;
    }

    public static double sum(RInt v, boolean narm) {
        int size = v.size();
        double res = 0.0;
        for (int i = 0; i < size; ++i) {
            int l = v.getInt(i);
            if (l == Integer.MIN_VALUE) {
                if (narm) continue;
                return -2.147483648E9;
            }
            res += (double)l;
        }
        return res;
    }

    private static int relationOperatorAgainst(ASTNode ast) {
        int cvalue;
        RAny res;
        BinaryOperation op;
        ASTNode other;
        ASTNode sumParent = ast.getParent();
        if (sumParent != null && sumParent instanceof BinaryOperation && (other = (op = (BinaryOperation)sumParent).getRHS() == ast ? op.getLHS() : op.getRHS()) instanceof Constant && ((res = ((Constant)other).getValue()) instanceof RDouble || res instanceof RInt || res instanceof RLogical) && ((RArray)res).size() == 1 && (cvalue = res.asInt().getInt(0)) >= 0) {
            return cvalue;
        }
        return -1;
    }

    private static int maxLogicalSum(ASTNode ast) {
        int res = Sum.relationOperatorAgainst(ast);
        ASTNode sumParent = ast.getParent();
        if (res != -1 && (sumParent instanceof GT || sumParent instanceof GE || sumParent instanceof EQ || sumParent instanceof NE || sumParent instanceof LT || sumParent instanceof LE)) {
            return res;
        }
        return -1;
    }

    @Override
    public RNode create(ASTNode call, RSymbol[] names, RNode[] exprs) {
        if (exprs.length == 0) {
            return new Builtin.Builtin0(call, names, exprs){

                @Override
                public RAny doBuiltIn(Frame frame) {
                    return RInt.BOXED_ZERO;
                }
            };
        }
        CallFactory.ArgumentInfo ia = this.check(call, names, exprs);
        final int narmPosition = ia.position("na.rm");
        final int maxLogicalSum = names.length > 2 || narmPosition != -1 ? -1 : Sum.maxLogicalSum(call);
        return new Builtin(call, names, exprs){

            @Override
            public RAny doBuiltIn(Frame frame, RAny[] args) {
                int l;
                int i;
                RAny v;
                boolean naRM = false;
                if (narmPosition != -1) {
                    RDouble d;
                    RInt i2;
                    RLogical l2;
                    RAny v2 = args[narmPosition];
                    naRM = v2 instanceof RLogical ? (l2 = (RLogical)v2).size() == 0 || l2.getLogical(0) != 0 : (v2 instanceof RInt ? (i2 = (RInt)v2).size() == 0 || i2.getInt(0) != 0 : (v2 instanceof RDouble ? (d = (RDouble)v2).size() == 0 || d.getDouble(0) != 0.0 : true));
                }
                boolean hasDouble = false;
                boolean hasInt = false;
                boolean hasComplex = false;
                for (int i3 = 0; i3 < args.length; ++i3) {
                    if (i3 == narmPosition) continue;
                    v = args[i3];
                    if (v instanceof RDouble) {
                        hasDouble = true;
                        continue;
                    }
                    if (v instanceof RComplex) {
                        hasComplex = true;
                        continue;
                    }
                    if (v instanceof RInt) {
                        hasInt = true;
                        continue;
                    }
                    if (v instanceof RLogical || v instanceof RNull) continue;
                    throw RError.getInvalidTypeArgument(this.ast, v.typeOf());
                }
                if (hasComplex) {
                    double[] tmp = new double[2];
                    double rreal = 0.0;
                    double rimag = 0.0;
                    for (int i4 = 0; i4 < args.length; ++i4) {
                        RAny v3;
                        if (i4 == narmPosition || (v3 = args[i4]) instanceof RNull) continue;
                        Sum.sum(v3.asComplex(), naRM, tmp);
                        double real = tmp[0];
                        double imag = tmp[1];
                        if (RComplex.RComplexUtils.eitherIsNAorNaN(real, imag)) {
                            rreal = real;
                            rimag = imag;
                            break;
                        }
                        rreal += real;
                        rimag += imag;
                    }
                    return RComplex.RComplexFactory.getScalar(rreal, rimag);
                }
                if (hasDouble) {
                    double res = 0.0;
                    for (int i5 = 0; i5 < args.length; ++i5) {
                        RAny v4;
                        if (i5 == narmPosition || (v4 = args[i5]) instanceof RNull) continue;
                        double d = Sum.sum(v4.asDouble(), naRM);
                        if (RDouble.RDoubleUtils.isNAorNaN(d)) {
                            res = d;
                            break;
                        }
                        res += d;
                    }
                    return RDouble.RDoubleFactory.getScalar(res);
                }
                if (hasInt || maxLogicalSum == -1) {
                    double res = 0.0;
                    for (int i6 = 0; i6 < args.length; ++i6) {
                        RAny v5;
                        if (i6 == narmPosition || (v5 = args[i6]) instanceof RNull) continue;
                        res += Sum.sum(v5.asInt(), naRM);
                    }
                    if (!(res < -2.147483648E9) && !(res > 2.147483647E9)) {
                        return RInt.RIntFactory.getScalar((int)res);
                    }
                    return RInt.BOXED_NA;
                }
                int argi = narmPosition == 0 ? 1 : 0;
                v = (RLogical)args[argi];
                int size = v.size();
                int res = 0;
                for (i = 0; i < size; ++i) {
                    l = v.getLogical(i);
                    if (l == Integer.MIN_VALUE) {
                        if (naRM) continue;
                        return RInt.BOXED_NA;
                    }
                    if ((res += l) > maxLogicalSum) break;
                }
                if (!naRM) {
                    while (i < size) {
                        l = v.getLogical(i);
                        if (l == Integer.MIN_VALUE) {
                            return RInt.BOXED_NA;
                        }
                        ++i;
                    }
                }
                if (res < 0) {
                    return RInt.BOXED_NA;
                }
                return RInt.RIntFactory.getScalar(res);
            }
        };
    }
}

