/*
 * Decompiled with CFR 0.152.
 */
package r.builtins;

import r.Utils;
import r.builtins.Builtin;
import r.builtins.CallFactory;
import r.data.RAny;
import r.data.RArray;
import r.data.RDouble;
import r.data.RInt;
import r.data.RSymbol;
import r.errors.RError;
import r.nodes.ast.ASTNode;
import r.nodes.exec.RNode;
import r.runtime.Frame;

final class T
extends CallFactory {
    static final CallFactory _ = new T("t", new String[]{"x"}, new String[]{"x"});
    private static final boolean IN_PLACE = true;

    T(String name, String[] params, String[] required) {
        super(name, params, required);
    }

    @Override
    public RNode create(ASTNode call, RSymbol[] names, RNode[] exprs) {
        this.check(call, names, exprs);
        return new Builtin.Builtin1(call, names, exprs){

            @Override
            public RAny doBuiltIn(Frame frame, RAny arg) {
                if (arg instanceof RArray) {
                    RArray a = (RArray)arg;
                    int[] dim = a.dimensions();
                    int size = a.size();
                    if (dim == null || dim.length == 1) {
                        dim = new int[]{1, size};
                        if (a.isTemporary()) {
                            return a.setDimensions(dim);
                        }
                        return Utils.copyArray(a).setDimensions(dim);
                    }
                    if (dim.length == 2) {
                        boolean blocked;
                        int m = dim[0];
                        int n = dim[1];
                        int[] ndim = new int[]{n, m};
                        if (a.isTemporary() && m == n) {
                            T.inPlaceSquare(a, m);
                            return a.setNames(null).setDimensions(ndim);
                        }
                        boolean bl = blocked = n > 1000 && m == n;
                        if (blocked) {
                            if (a instanceof RDouble) {
                                double[] content = new double[size];
                                T.squareBlocked(((RDouble)a).getContent(), n, content);
                                return RDouble.RDoubleFactory.getFor(content, ndim, null, a.attributesRef());
                            }
                            if (a instanceof RInt) {
                                int[] content = new int[size];
                                T.squareBlocked(((RInt)a).getContent(), n, content);
                                return RInt.RIntFactory.getFor(content, ndim, null, a.attributesRef());
                            }
                            RArray res = Utils.createArray(a, size, ndim, null, a.attributesRef());
                            T.squareBlocked(a, n, res);
                            return res;
                        }
                        RArray res = Utils.createArray(a, size, ndim, null, a.attributesRef());
                        int j = 0;
                        int size1 = size - 1;
                        for (int i = 0; i < size; ++i) {
                            res.set(i, a.getRef(j));
                            if ((j += m) <= size1) continue;
                            j -= size1;
                        }
                        return res;
                    }
                }
                throw RError.getArgumentNotMatrix(this.ast);
            }
        };
    }

    public static void inPlaceSquare(RArray a, int m) {
        for (int i = 0; i < m - 1; ++i) {
            for (int j = i + 1; j < m; ++j) {
                int first = i * m + j;
                int second = j * m + i;
                Object tmp = a.get(first);
                a.set(first, a.get(second));
                a.set(second, tmp);
            }
        }
    }

    public static void squareBlocked(RArray a, int n, RArray res) {
        int delta = n > 1000 ? 40 : 0;
        int size = n * n;
        int size1 = size - 1;
        int i = 0;
        int j = 0;
        int blocksPerSide = delta > 0 ? n / delta : 0;
        int epsilon = n - blocksPerSide * delta;
        int iadvance1 = n - delta;
        int jadvance1 = -(delta * n - 1);
        int iadvance2 = -(delta * (n - 1));
        int jadvance2 = delta * (n - 1);
        int iadvance3 = (delta - 1) * n + epsilon;
        int jadvance3 = -((n - epsilon) * n - delta);
        for (int bcol = 0; bcol < blocksPerSide; ++bcol) {
            for (int brow = 0; brow < blocksPerSide; ++brow) {
                for (int icol = 0; icol < delta; ++icol) {
                    for (int irow = 0; irow < delta; ++irow) {
                        res.set(i, a.getRef(j));
                        ++i;
                        j += n;
                    }
                    i += iadvance1;
                    j += jadvance1;
                }
                i += iadvance2;
                j += jadvance2;
            }
            i += iadvance3;
            j += jadvance3;
        }
        if (epsilon > 0) {
            j = n - epsilon;
            for (i = (n - epsilon) * n; i < size; ++i) {
                res.set(i, a.getRef(j));
                if ((j += n) <= size1) continue;
                j -= size1;
            }
            i = n - epsilon;
            int iend = j = (n - epsilon) * n;
            int rsize1 = n * epsilon - 1;
            int rowoffset = n - epsilon;
            while (i < iend) {
                res.set(i, a.getRef(j));
                ++i;
                if ((j += n) <= size1) continue;
                j -= rsize1;
                i += rowoffset;
            }
        }
    }

    public static void squareBlocked(int[] a, int n, int[] res) {
        int delta = n > 1000 ? 40 : 0;
        int size = n * n;
        int size1 = size - 1;
        int i = 0;
        int j = 0;
        int blocksPerSide = delta > 0 ? n / delta : 0;
        int epsilon = n - blocksPerSide * delta;
        int iadvance1 = n - delta;
        int jadvance1 = -(delta * n - 1);
        int iadvance2 = -(delta * (n - 1));
        int jadvance2 = delta * (n - 1);
        int iadvance3 = (delta - 1) * n + epsilon;
        int jadvance3 = -((n - epsilon) * n - delta);
        for (int bcol = 0; bcol < blocksPerSide; ++bcol) {
            for (int brow = 0; brow < blocksPerSide; ++brow) {
                for (int icol = 0; icol < delta; ++icol) {
                    for (int irow = 0; irow < delta; ++irow) {
                        res[i] = a[j];
                        ++i;
                        j += n;
                    }
                    i += iadvance1;
                    j += jadvance1;
                }
                i += iadvance2;
                j += jadvance2;
            }
            i += iadvance3;
            j += jadvance3;
        }
        if (epsilon > 0) {
            j = n - epsilon;
            for (i = (n - epsilon) * n; i < size; ++i) {
                res[i] = a[j];
                if ((j += n) <= size1) continue;
                j -= size1;
            }
            i = n - epsilon;
            int iend = j = (n - epsilon) * n;
            int rsize1 = n * epsilon - 1;
            int rowoffset = n - epsilon;
            while (i < iend) {
                res[i] = a[j];
                ++i;
                if ((j += n) <= size1) continue;
                j -= rsize1;
                i += rowoffset;
            }
        }
    }

    public static void squareBlocked(double[] a, int n, double[] res) {
        int delta = n > 1000 ? 40 : 0;
        int size = n * n;
        int size1 = size - 1;
        int i = 0;
        int j = 0;
        int blocksPerSide = delta > 0 ? n / delta : 0;
        int epsilon = n - blocksPerSide * delta;
        int iadvance1 = n - delta;
        int jadvance1 = -(delta * n - 1);
        int iadvance2 = -(delta * (n - 1));
        int jadvance2 = delta * (n - 1);
        int iadvance3 = (delta - 1) * n + epsilon;
        int jadvance3 = -((n - epsilon) * n - delta);
        for (int bcol = 0; bcol < blocksPerSide; ++bcol) {
            for (int brow = 0; brow < blocksPerSide; ++brow) {
                for (int icol = 0; icol < delta; ++icol) {
                    for (int irow = 0; irow < delta; ++irow) {
                        res[i] = a[j];
                        ++i;
                        j += n;
                    }
                    i += iadvance1;
                    j += jadvance1;
                }
                i += iadvance2;
                j += jadvance2;
            }
            i += iadvance3;
            j += jadvance3;
        }
        if (epsilon > 0) {
            j = n - epsilon;
            for (i = (n - epsilon) * n; i < size; ++i) {
                res[i] = a[j];
                if ((j += n) <= size1) continue;
                j -= size1;
            }
            i = n - epsilon;
            int iend = j = (n - epsilon) * n;
            int rsize1 = n * epsilon - 1;
            int rowoffset = n - epsilon;
            while (i < iend) {
                res[i] = a[j];
                ++i;
                if ((j += n) <= size1) continue;
                j -= rsize1;
                i += rowoffset;
            }
        }
    }
}

