/*
 * Decompiled with CFR 0.152.
 */
package r.builtins;

import r.Convert;
import r.Utils;
import r.builtins.Builtin;
import r.builtins.C;
import r.builtins.CallFactory;
import r.data.RAny;
import r.data.RArray;
import r.data.RComplex;
import r.data.RDouble;
import r.data.RInt;
import r.data.RList;
import r.data.RLogical;
import r.data.RNull;
import r.data.RRaw;
import r.data.RString;
import r.data.RSymbol;
import r.data.internal.ScalarDoubleImpl;
import r.data.internal.ScalarIntImpl;
import r.data.internal.ScalarStringImpl;
import r.errors.RError;
import r.nodes.ast.ASTNode;
import r.nodes.exec.RNode;
import r.runtime.Frame;

final class Unlist
extends CallFactory {
    static final CallFactory _ = new Unlist("unlist", new String[]{"x", "recursive", "use.names"}, new String[]{"x"});

    Unlist(String name, String[] params, String[] required) {
        super(name, params, required);
    }

    public static boolean parseLogical(RAny arg) {
        int v;
        RLogical larg = arg.asLogical();
        int size = larg.size();
        return size > 0 && (v = larg.getLogical(0)) == 1;
    }

    @Override
    public RNode create(ASTNode call, RSymbol[] names, RNode[] exprs) {
        CallFactory.ArgumentInfo ia = this.check(call, names, exprs);
        final int posX = ia.position("x");
        final int posRecursive = ia.provided("recursive") ? ia.position("recursive") : -1;
        final int posUseNames = ia.provided("use.names") ? ia.position("use.names") : -1;
        return new Builtin(call, names, exprs){

            @Override
            public RAny doBuiltIn(Frame frame, RAny[] args) {
                RAny x = args[posX];
                boolean recursive = posRecursive != -1 ? Unlist.parseLogical(args[posRecursive]) : true;
                boolean useNames = posUseNames != -1 ? Unlist.parseLogical(args[posUseNames]) : true;
                return Unlist.genericUnlist(x, recursive, useNames, this.ast);
            }
        };
    }

    public static RAny genericUnlist(RAny x, boolean recursive, boolean useNames, ASTNode ast) {
        if (x instanceof RList) {
            return Unlist.genericUnlist((RList)x, recursive, useNames);
        }
        if (x instanceof RArray || x instanceof RNull) {
            return x;
        }
        throw RError.getArgumentNotList(ast);
    }

    public static void fill(RArray target, RSymbol[] targetSymbols, RAny x, Cast cast) {
        if (targetSymbols == null) {
            Unlist.fill(target, 0, x, cast);
        } else {
            Unlist.fill(target, targetSymbols, "", 0, x, cast);
        }
    }

    public static int fill(RArray target, int offset, RAny x, Cast cast) {
        if (x instanceof RNull) {
            return offset;
        }
        int noffset = offset;
        if (x instanceof RList) {
            RList l = (RList)x;
            int lsize = l.size();
            for (int i = 0; i < lsize; ++i) {
                RAny v = l.getRAnyRef(i);
                noffset = Unlist.fill(target, noffset, v, cast);
            }
            return noffset;
        }
        RArray typedX = cast.cast(x);
        int xsize = typedX.size();
        for (int i = 0; i < xsize; ++i) {
            target.set(noffset++, typedX.get(i));
        }
        return noffset;
    }

    public static int fill(RArray target, RSymbol[] targetSymbols, String prefix, int offset, RAny x, Cast cast) {
        boolean emptyPrefix;
        if (x instanceof RNull) {
            return offset;
        }
        int noffset = offset;
        RArray.Names names = ((RArray)x).names();
        RSymbol[] symbols = names == null ? null : names.sequence();
        boolean bl = emptyPrefix = prefix.length() == 0;
        if (x instanceof RList) {
            RList l = (RList)x;
            int lsize = l.size();
            for (int i = 0; i < lsize; ++i) {
                RAny v = l.getRAnyRef(i);
                String nprefix = symbols == null || symbols[i] == RSymbol.EMPTY_SYMBOL ? (!emptyPrefix && lsize > 1 ? prefix + (i + 1) : prefix) : (!emptyPrefix ? prefix + "." + Convert.prettyNA(symbols[i].pretty()) : Convert.prettyNA(symbols[i].pretty()));
                noffset = Unlist.fill(target, targetSymbols, nprefix, noffset, v, cast);
            }
            return noffset;
        }
        RArray typedX = cast.cast(x);
        int xsize = typedX.size();
        for (int i = 0; i < xsize; ++i) {
            target.set(noffset, typedX.get(i));
            String sname = symbols == null || symbols[i] == RSymbol.EMPTY_SYMBOL ? (!emptyPrefix && xsize > 1 ? prefix + (i + 1) : prefix) : (!emptyPrefix ? prefix + "." + Convert.prettyNA(symbols[i].pretty()) : Convert.prettyNA(symbols[i].pretty()));
            targetSymbols[noffset] = RSymbol.getSymbol(sname);
            ++noffset;
        }
        return noffset;
    }

    public static RAny genericUnlist(RList x, boolean recursive, boolean useNames) {
        RArray target;
        RSymbol[] symbols;
        RAny res = Unlist.speculativeUnlist(x, useNames);
        if (res != null) {
            return res;
        }
        if (!recursive) {
            return C.genericCombine(useNames ? x.names().sequence() : null, x.materialize().getContent(), !useNames);
        }
        AnalyzeList alist = AnalyzeList.analyze(x, recursive, useNames);
        assert (Utils.check(!alist.hasList));
        int size = alist.size;
        boolean needsNames = useNames && alist.hasNames;
        RSymbol[] rSymbolArray = symbols = needsNames ? new RSymbol[size] : null;
        if (alist.hasString) {
            target = RString.RStringFactory.getUninitializedArray(size);
            Unlist.fill(target, symbols, (RAny)x, Cast.STRING);
        } else if (alist.hasComplex) {
            target = RComplex.RComplexFactory.getUninitializedArray(size);
            Unlist.fill(target, symbols, (RAny)x, Cast.COMPLEX);
        } else if (alist.hasDouble) {
            target = RDouble.RDoubleFactory.getUninitializedArray(size);
            Unlist.fill(target, symbols, (RAny)x, Cast.DOUBLE);
        } else if (alist.hasInt) {
            target = RInt.RIntFactory.getUninitializedArray(size);
            Unlist.fill(target, symbols, (RAny)x, Cast.INT);
        } else if (alist.hasLogical) {
            target = RLogical.RLogicalFactory.getUninitializedArray(size);
            Unlist.fill(target, symbols, (RAny)x, Cast.LOGICAL);
        } else if (alist.hasRaw) {
            target = RRaw.RRawFactory.getUninitializedArray(size);
            Unlist.fill(target, symbols, (RAny)x, Cast.RAW);
        } else {
            Utils.nyi("unsupported case");
            return null;
        }
        return needsNames ? target.setNames(RArray.Names.create(symbols)) : target;
    }

    public static RAny speculativeUnlist(RList x, boolean useNames) {
        int xsize = x.size();
        if (xsize == 0) {
            return RNull.getNull();
        }
        RAny xfirst = x.getRAny(0);
        RArray.Names names = x.names();
        if (xfirst instanceof ScalarDoubleImpl) {
            double[] content = new double[xsize];
            for (int i = 0; i < xsize; ++i) {
                RAny elem = x.getRAny(i);
                if (!(elem instanceof ScalarDoubleImpl)) {
                    return null;
                }
                content[i] = ((ScalarDoubleImpl)elem).getDouble();
            }
            return RDouble.RDoubleFactory.getFor(content, null, useNames ? names : null);
        }
        if (xfirst instanceof ScalarIntImpl) {
            int[] content = new int[xsize];
            for (int i = 0; i < xsize; ++i) {
                RAny elem = x.getRAny(i);
                if (!(elem instanceof ScalarIntImpl)) {
                    return null;
                }
                content[i] = ((ScalarIntImpl)elem).getInt();
            }
            return RInt.RIntFactory.getFor(content, null, useNames ? names : null);
        }
        if (xfirst instanceof ScalarStringImpl) {
            String[] content = new String[xsize];
            for (int i = 0; i < xsize; ++i) {
                RAny elem = x.getRAny(i);
                if (!(elem instanceof ScalarStringImpl)) {
                    return null;
                }
                content[i] = ((ScalarStringImpl)elem).getString();
            }
            return RString.RStringFactory.getFor(content, null, useNames ? names : null);
        }
        return null;
    }

    public static abstract class Cast {
        public static final Cast STRING = new Cast(){

            @Override
            public RArray cast(RAny src) {
                return src.asString();
            }
        };
        public static final Cast COMPLEX = new Cast(){

            @Override
            public RArray cast(RAny src) {
                return src.asComplex();
            }
        };
        public static final Cast DOUBLE = new Cast(){

            @Override
            public RArray cast(RAny src) {
                return src.asDouble();
            }
        };
        public static final Cast INT = new Cast(){

            @Override
            public RArray cast(RAny src) {
                return src.asInt();
            }
        };
        public static final Cast LOGICAL = new Cast(){

            @Override
            public RArray cast(RAny src) {
                return src.asLogical();
            }
        };
        public static final Cast RAW = new Cast(){

            @Override
            public RArray cast(RAny src) {
                return src.asRaw();
            }
        };

        public abstract RArray cast(RAny var1);
    }

    public static class AnalyzeList {
        public boolean hasList;
        public boolean hasNull;
        public boolean hasNames;
        public boolean hasString;
        public boolean hasComplex;
        public boolean hasDouble;
        public boolean hasInt;
        public boolean hasLogical;
        public boolean hasRaw;
        public int size;
        private boolean recursive;
        private boolean useNames;
        private static final AnalyzeList instance = new AnalyzeList();

        public static AnalyzeList create(boolean recursive, boolean useNames) {
            AnalyzeList.instance.hasList = false;
            AnalyzeList.instance.hasNull = false;
            AnalyzeList.instance.hasNames = false;
            AnalyzeList.instance.hasString = false;
            AnalyzeList.instance.hasComplex = false;
            AnalyzeList.instance.hasDouble = false;
            AnalyzeList.instance.hasInt = false;
            AnalyzeList.instance.hasLogical = false;
            AnalyzeList.instance.hasRaw = false;
            AnalyzeList.instance.size = 0;
            AnalyzeList.instance.recursive = recursive;
            AnalyzeList.instance.useNames = useNames;
            return instance;
        }

        public static AnalyzeList analyze(RList x, boolean recursive, boolean useNames) {
            AnalyzeList res = AnalyzeList.create(recursive, useNames);
            res.analyze(x);
            return res;
        }

        private void analyze(RList x) {
            int xsize = x.size();
            for (int i = 0; i < xsize; ++i) {
                RAny v = x.getRAny(i);
                if (v instanceof RNull) {
                    this.hasNull = true;
                    continue;
                }
                if (v instanceof RList) {
                    if (this.recursive) {
                        RList l = (RList)v;
                        if (this.useNames && l.names() != null) {
                            this.hasNames = true;
                        }
                        this.analyze(l);
                        continue;
                    }
                    this.hasList = true;
                } else if (v instanceof RString) {
                    this.hasString = true;
                } else if (v instanceof RComplex) {
                    this.hasComplex = true;
                } else if (v instanceof RDouble) {
                    this.hasDouble = true;
                } else if (v instanceof RInt) {
                    this.hasInt = true;
                } else if (v instanceof RLogical) {
                    this.hasLogical = true;
                } else if (v instanceof RRaw) {
                    this.hasRaw = true;
                } else {
                    Utils.nyi("unsupported type");
                    return;
                }
                RArray a = (RArray)v;
                this.size += a.size();
                if (!this.useNames || a.names() == null) continue;
                this.hasNames = true;
            }
        }
    }
}

