/*
 * Decompiled with CFR 0.152.
 */
package r.builtins;

import r.RContext;
import r.Utils;
import r.builtins.Builtin;
import r.builtins.CallFactory;
import r.data.RAny;
import r.data.RArray;
import r.data.RDouble;
import r.data.RInt;
import r.data.RLogical;
import r.data.RSymbol;
import r.errors.RError;
import r.nodes.ast.ASTNode;
import r.nodes.exec.RNode;
import r.runtime.Frame;

class UpperTri
extends CallFactory {
    static Triangular UPPER = new Triangular(){

        @Override
        public RArray triangular(int m, int n, boolean diag) {
            int[] content = new int[m * n];
            int takeFromColumn = diag ? 1 : 0;
            for (int j = 0; j < n; ++j) {
                for (int i = 0; i < takeFromColumn; ++i) {
                    content[j * m + i] = 1;
                }
                if (takeFromColumn >= m) continue;
                ++takeFromColumn;
            }
            return RLogical.RLogicalFactory.getFor(content);
        }
    };
    static final CallFactory _ = new UpperTri("upper.tri", new String[]{"x", "diag"}, new String[]{"x"}, UPPER);
    final Triangular trian;

    UpperTri(String name, String[] params, String[] required, Triangular trian) {
        super(name, params, required);
        this.trian = trian;
    }

    @Override
    public RNode create(ASTNode call, RSymbol[] names, RNode[] exprs) {
        boolean xfirst;
        CallFactory.ArgumentInfo ia = this.check(call, names, exprs);
        boolean bl = xfirst = ia.position("x") == 0;
        if (names.length == 1) {
            return new Builtin.Builtin1(call, names, exprs){

                @Override
                public RAny doBuiltIn(Frame frame, RAny argx) {
                    return UpperTri.this.trian.triangular(argx, false);
                }
            };
        }
        return new Builtin.Builtin2(call, names, exprs){

            @Override
            public RAny doBuiltIn(Frame frame, RAny arg0, RAny arg1) {
                return xfirst ? UpperTri.this.trian.triangular(this.ast, arg0, arg1) : UpperTri.this.trian.triangular(this.ast, arg1, arg0);
            }
        };
    }

    public static abstract class Triangular {
        public abstract RArray triangular(int var1, int var2, boolean var3);

        public RAny triangular(RAny argx, boolean diag) {
            if (!(argx instanceof RArray)) {
                throw Utils.nyi("unsupported (invalid) argument type");
            }
            RArray a = (RArray)argx;
            int[] dim = a.dimensions();
            if (dim == null) {
                int m = a.size();
                return this.triangular(m, 1, diag).setDimensions(new int[]{m, 1});
            }
            if (dim.length == 2) {
                return this.triangular(dim[0], dim[1], diag).setDimensions(dim);
            }
            throw Utils.nyi("unsupported case");
        }

        public RAny triangular(ASTNode ast, RAny argx, RAny argdiag) {
            if (argdiag instanceof RLogical || argdiag instanceof RDouble || argdiag instanceof RInt) {
                int l;
                RArray diag = (RArray)argdiag;
                int size = diag.size();
                if (size == 0) {
                    throw RError.getInvalidArgument(ast, "diag");
                }
                if (size > 1) {
                    RContext.warning(ast, "the condition has length > 1 and only the first element will be used");
                }
                if ((l = diag.asLogical().getLogical(0)) != Integer.MIN_VALUE) {
                    return this.triangular(argx, l == 1);
                }
            }
            throw RError.getInvalidArgument(ast, "diag");
        }
    }
}

