/*
 * Decompiled with CFR 0.152.
 */
package r.builtins;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import r.RContext;
import r.Utils;
import r.builtins.Builtin;
import r.builtins.CallFactory;
import r.builtins.File;
import r.data.RAny;
import r.data.RInt;
import r.data.RNull;
import r.data.RRaw;
import r.data.RString;
import r.data.RSymbol;
import r.data.internal.Connection;
import r.data.internal.ConnectionMode;
import r.errors.RError;
import r.nodes.ast.ASTNode;
import r.nodes.exec.RNode;
import r.runtime.Frame;

final class WriteBin
extends CallFactory {
    static final CallFactory _ = new WriteBin("writeBin", new String[]{"object", "con", "size", "endian", "useBytes"}, new String[]{"object", "con"});

    WriteBin(String name, String[] params, String[] required) {
        super(name, params, required);
    }

    public static void write(RRaw arg, OutputStream output) throws IOException {
        int size = arg.size();
        for (int i = 0; i < size; ++i) {
            output.write(arg.getRaw(i));
        }
    }

    public static void write(RAny arg, OutputStream output) throws IOException {
        if (arg instanceof RRaw) {
            WriteBin.write((RRaw)arg, output);
            return;
        }
        throw Utils.nyi("unsupported argument");
    }

    @Override
    public RNode create(ASTNode call, RSymbol[] names, RNode[] exprs) {
        CallFactory.ArgumentInfo ia = this.check(call, names, exprs);
        if (ia.provided("size") || ia.provided("endian") || ia.provided("useBytes")) {
            Utils.nyi("argument of writeBin not yet implemented");
        }
        final ConnectionMode defaultMode = ConnectionMode.get("wb");
        final int posCon = ia.position("con");
        final int posObject = ia.position("object");
        return new Builtin(call, names, exprs){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public RAny doBuiltIn(Frame frame, RAny[] args) {
                Connection con = null;
                boolean wasOpen = false;
                RAny conArg = args[posCon];
                if (conArg instanceof RString) {
                    String description = File.getScalarString(conArg, this.ast, "description");
                    con = Connection.FileConnection.createOpened(description, defaultMode, this.ast);
                } else if (conArg instanceof RInt) {
                    RInt iarg = (RInt)conArg;
                    if (iarg.size() != 1) {
                        throw RError.getNotConnection(this.ast, "con");
                    }
                    int handle = iarg.getInt(0);
                    con = RContext.getConnection(handle);
                    Utils.check(con != null);
                    if (con.isOpen()) {
                        ConnectionMode mode = con.currentMode();
                        if (!mode.binary()) {
                            throw RError.getWriteOnlyBinary(this.ast);
                        }
                        if (!mode.write()) {
                            throw RError.getCannotWriteConnection(this.ast);
                        }
                        wasOpen = true;
                    } else {
                        con.open(defaultMode, this.ast);
                    }
                }
                try {
                    BufferedOutputStream output = new BufferedOutputStream(con.output(this.ast));
                    try {
                        WriteBin.write(args[posObject], (OutputStream)output);
                        output.flush();
                    }
                    catch (IOException e) {
                        throw RError.getGenericError(this.ast, e.toString());
                    }
                    RNull rNull = RNull.getNull();
                    return rNull;
                }
                finally {
                    if (!wasOpen) {
                        con.close(this.ast);
                    }
                }
            }
        };
    }
}

