/*
 * Decompiled with CFR 0.152.
 */
package r.builtins.internal;

import r.RContext;
import r.data.RAny;
import r.data.RArray;
import r.data.RDouble;
import r.data.RInt;
import r.data.RLogical;
import r.data.RSymbol;
import r.data.internal.IntImpl;
import r.errors.RError;
import r.gnur.GNUR;
import r.nodes.ast.ASTNode;

public final class Random {
    private static RSymbol seedSymbol = RSymbol.getSymbol(".Random.seed");
    public static final RInt defaultSeed = (RInt)RArray.RArrayUtils.markShared(RInt.RIntFactory.getFor(new int[]{401, 1234, 5678}));

    public static void resetSeed() {
        seedSymbol.setValue(defaultSeed);
    }

    public static int[] updateNativeSeed(ASTNode ast) {
        Object v = seedSymbol.getValue();
        if (v == null) {
            v = defaultSeed;
        }
        if (!(v instanceof RInt)) {
            throw RError.getSeedType(ast, ((RAny)v).typeOf());
        }
        RInt iv = (RInt)v;
        int size = iv.size();
        if (size < 3) {
            throw RError.getSeedLength(ast);
        }
        if (!(iv instanceof IntImpl) || !iv.isTemporary()) {
            iv = RInt.RIntFactory.copy(iv);
            seedSymbol.setValue(iv);
        }
        int[] kind = iv.getContent();
        GNUR.set_seed(kind);
        return kind;
    }

    public static void updateWorkspaceSeed(int[] res) {
        GNUR.get_seed(res);
    }

    public static int parseNArgument(RAny narg, ASTNode ast) {
        if (!(narg instanceof RArray)) {
            throw RError.getInvalidUnnamedArguments(ast);
        }
        RArray a = (RArray)narg;
        int size = a.size();
        if (size == 1) {
            int i = a.asInt().getInt(0);
            if (i < 0) {
                throw RError.getInvalidUnnamedArguments(ast);
            }
            return i;
        }
        return size;
    }

    public static double[] parseNumericArgument(RAny narg, ASTNode ast) {
        if (narg instanceof RDouble) {
            return ((RDouble)narg).getContent();
        }
        if (narg instanceof RInt || narg instanceof RLogical) {
            return narg.asDouble().getContent();
        }
        throw RError.getInvalidUnnamedArguments(ast);
    }

    public static RDouble allNAs(int n, ASTNode ast) {
        if (n == 0) {
            return RDouble.EMPTY;
        }
        RContext.warning(ast, "NAs produced");
        return RDouble.RDoubleFactory.getNAArray(n);
    }
}

