/*
 * Decompiled with CFR 0.152.
 */
package r.data;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import r.Convert;
import r.Utils;
import r.data.RComplex;
import r.data.RDouble;
import r.data.RInt;
import r.data.RList;
import r.data.RLogical;
import r.data.RRaw;
import r.data.RString;
import r.data.RSymbol;
import r.nodes.ast.OperationFactory;
import r.nodes.exec.RNode;

public interface RAny {
    public static final String TYPE_STRING = "any";

    public String typeOf();

    public Attributes attributes();

    public Attributes attributesRef();

    public RAny setAttributes(Attributes var1);

    public RAny stripAttributes();

    public String pretty();

    public String prettyMatrixElement();

    public RRaw asRaw();

    public RLogical asLogical();

    public RInt asInt();

    public RDouble asDouble();

    public RComplex asComplex();

    public RString asString();

    public RList asList();

    public RRaw asRaw(Convert.ConversionStatus var1);

    public RLogical asLogical(Convert.ConversionStatus var1);

    public RInt asInt(Convert.ConversionStatus var1);

    public RDouble asDouble(Convert.ConversionStatus var1);

    public RComplex asComplex(Convert.ConversionStatus var1);

    public RString asString(Convert.ConversionStatus var1);

    public void ref();

    public boolean isShared();

    public boolean isTemporary();

    public boolean dependsOn(RAny var1);

    public <T extends RNode> T callNodeFactory(OperationFactory<T> var1);

    public static class Attributes {
        private boolean shared = false;
        private LinkedHashMap<RSymbol, RAny> map = new LinkedHashMap();
        private PartialEntry pmap;
        public static final boolean PROPAGATE_PARTIAL_MAP = true;

        public static Attributes createAndPut(String name, RAny value) {
            Attributes attr = new Attributes();
            attr.put(RSymbol.getSymbol(name), value);
            return attr;
        }

        public void createPartialMap() {
            assert (Utils.check(this.pmap == null));
            this.pmap = new PartialEntry();
            for (RSymbol s : this.map.keySet()) {
                this.partialAdd(s);
            }
        }

        public void put(RSymbol key, RAny value) {
            if (this.pmap == null) {
                this.map.put(key, value);
            } else {
                boolean present = this.map.containsKey(key);
                this.map.put(key, value);
                if (!present) {
                    this.partialAdd(key);
                }
            }
        }

        public void remove(RSymbol key) {
            if (this.pmap == null) {
                this.map.remove(key);
            } else if (this.map.remove(key) != null) {
                this.partialRemove(key);
            }
        }

        private void partialAdd(RSymbol symbol) {
            char[] key = symbol.name().toCharArray();
            PartialEntry root = this.pmap;
            for (int i = 0; i < key.length - 1; ++i) {
                TreeMap<Character, PartialEntry> cmap = root.children;
                char k = key[i];
                root = cmap.get(Character.valueOf(k));
                if (root != null) continue;
                root = new PartialEntry();
                cmap.put(Character.valueOf(k), root);
            }
            TreeMap<Character, PartialEntry> cmap = root.children;
            char k = key[key.length - 1];
            root = cmap.get(Character.valueOf(k));
            if (root == null) {
                cmap.put(Character.valueOf(k), new PartialEntry(symbol));
            } else {
                assert (Utils.check(root.fullName == null));
                root.fullName = symbol;
            }
        }

        private void partialRemove(RSymbol symbol) {
            char[] key = symbol.name().toCharArray();
            PartialEntry root = this.pmap;
            for (int i = 0; i < key.length - 1; ++i) {
                char k = key[i];
                TreeMap<Character, PartialEntry> cmap = root.children;
                root = cmap.get(Character.valueOf(k));
                assert (Utils.check(root != null));
            }
            char k = key[key.length - 1];
            TreeMap<Character, PartialEntry> cmap = root.children;
            root = cmap.get(Character.valueOf(k));
            assert (Utils.check(root != null));
            cmap.remove(Character.valueOf(k));
        }

        public boolean hasPartialMap() {
            return this.pmap != null;
        }

        public RSymbol partialFind(RSymbol partialName) {
            assert (Utils.check(this.pmap != null));
            assert (Utils.check(partialName != RSymbol.NA_SYMBOL));
            return this.partialFind(partialName.name().toCharArray(), 0, this.pmap);
        }

        private RSymbol partialFind(char[] key, int keyStart, PartialEntry root) {
            PartialEntry pe = root.children.get(Character.valueOf(key[keyStart]));
            if (pe == null) {
                return null;
            }
            int nextStart = keyStart + 1;
            if (nextStart == key.length) {
                return this.countPresentValues(pe) == 1 ? pe.fullName : null;
            }
            return this.partialFind(key, nextStart, pe);
        }

        private int countPresentValues(PartialEntry root) {
            int cnt = root.fullName == null ? 0 : 1;
            for (PartialEntry pe : root.children.values()) {
                cnt += this.countPresentValues(pe);
            }
            return cnt;
        }

        public boolean areShared() {
            return this.shared;
        }

        public static Attributes markShared(Attributes a) {
            if (a != null) {
                a.shared = true;
            }
            return a;
        }

        public Attributes markShared() {
            this.shared = true;
            return this;
        }

        public LinkedHashMap<RSymbol, RAny> map() {
            return this.map;
        }

        public Attributes copy() {
            Attributes nattr = new Attributes();
            LinkedHashMap<RSymbol, RAny> nmap = nattr.map();
            for (Map.Entry<RSymbol, RAny> entry : this.map.entrySet()) {
                nmap.put(entry.getKey(), Utils.copyAny(entry.getValue()));
            }
            nattr.pmap = this.pmap;
            this.pmap = null;
            return nattr;
        }

        public Attributes getOrCopy() {
            if (this.shared) {
                return this.copy();
            }
            return this;
        }

        public static Attributes getOrCopy(Attributes attr) {
            if (attr == null) {
                return null;
            }
            return attr.getOrCopy();
        }

        public static class PartialEntry {
            TreeMap<Character, PartialEntry> children = new TreeMap();
            RSymbol fullName;

            public PartialEntry(RSymbol fullName) {
                this.fullName = fullName;
            }

            public PartialEntry() {
                this(null);
            }
        }
    }

    public static enum Mode {
        RAW,
        LOGICAL,
        INT,
        DOUBLE,
        COMPLEX,
        STRING,
        LIST,
        NULL;

    }
}

